#####################################################################
;# NAME:   aureporter.tcl
;# AUTHOR: Clif Flynt
;# DATE:   7/31/2006
;# DESC:   Generates customized reports from ausearch or Clif-style
;#   reduced log files.
;#
;# PARAMETERS:  None
;#
;#
#####################################################################
# This code is written and copyrighted by Clif Flynt, 2006
#
# It is licenced for public use with these terms:
#
#  This licence agreement must remain intact with the code.
# 
#  You may use this code freely for commercial or non-commercial purposes.
#
#  You may examine and modify the code to your heart's content.
#
#  You may not claim to have authored the code, aside from modifications
#  you may have made.
#
#  You may not distribute the code without this license agreement
#
#  Maintenance, extension, modification, etc can be performed by:
#
#   Noumena Corporation
#   9300 Fleming Rd.
#   Dexter, MI  48130
#
#   Contact: clif@noucorp.com
#
#####################################################################
set release(aureporter.tcl) {$Header: /home/cvs/AuStuff/aureporter.tcl,v 1.3 2006/08/03 00:13:55 clif Exp $}

# This code modifies the look/feel of Tk to be a bit more 'modern'
# and Windows-like instead of Motif-like.  It's from the Tk reviitalization
# project
set release(options.tcl) {$Header: /home/cvs/readi/code/dpe/src/balloon.tcl,v 1.
2 2003/12/02 14:41:31 clif Exp $}

option add *background #d8d8d8
option add *Listbox.background white
option add *Listbox.selectBorderWidth 0
option add *Listbox.selectForeground white
option add *Listbox.selectBackground #4a6984

option add *Entry.background white
option add *Entry.selectBorderWidth 0
option add *Entry.selectForeground white
option add *Entry.selectBackground #4a6984

option add *Text.background white
option add *Text.selectBorderWidth 0
option add *Text.selectForeground white
option add *Text.selectBackground #4a6984

option add *Menu.activeBackground #4a6984
option add *Menu.activeForeground white
option add *Menu.activeBorderWidth 0
option add *Menu.highlightThickness 0
option add *Menu.borderWidth 2
option add *Menu.tearOff 0

option add *MenuButton.activeBackground #4a6984
option add *MenuButton.activeForeground white
option add *MenuButton.activeBorderWidth 0
option add *MenuButton.highlightThickness 0
option add *MenuButton.borderWidth 0

option add *highlightThickness 0
option add *troughColor #bdb6ad

# End of code from Tk Revitalization project.

option add *Menu.background #d8d8d8
option add *Frame.background #d8d8d8
option add *Menubutton.background #d8d8d8

# These convert fonts to 'normal' instead of bold.
# And set colors to values that seem closer to MS-Windows 2K.

 if {$tcl_platform(platform) eq "unix"} {
   set fontSize 8
 } 
 
 if {$tcl_platform(platform) eq "windows"} {
   set fontSize 8
 } 
 
 if {[string first Macin $tcl_platform(machine)] < 0} {
   option add *Label.font [list arial $fontSize normal]
   option add *Labelframe.font [list arial $fontSize normal]
   option add *Button.font [list arial $fontSize normal]
   option add *Menu.font [list arial $fontSize normal]
   option add *Menubutton.font [list arial $fontSize normal]
   option add *Radiobutton.font [list arial $fontSize normal]
   option add *Checkbutton.font [list arial $fontSize normal]
   option add *Listbox.font [list arial $fontSize normal]
   option add *Scrollbar.width 12
  }


set release(notebook2.tcl) {$Header: /home/cvs/AuStuff/notebook2.tcl,v 1.1 2006/08/03 00:14:56 clif Exp $}
namespace eval notebook {
  variable tabState
  
  array set tabState {
    dflt.relief flat            dflt.highlightcolor black
    dflt.container 0            dflt.highlightthickness 0
    dflt.height 0               dflt.highlightbackground #d9d9d9
    dflt.width 0                dflt.background #d9d9d9 
    dflt.visual {}              dflt.font {arial 8 normal}
    dflt.cursor {}              dflt.unselected #ddd
    dflt.padx 0                 dflt.background #d8d8d8
    dflt.pady 0                 dflt.colormap {}
    dflt.height 25              dflt.takefocus 0
    dflt.selected #fff          dflt.borderwidth 0 
    dflt.class Notebook 	id               0
    dflt.labelFont {arial 8 normal}
  }
  
proc setKey {top key {value NoSuChVaLuE}} {
  variable tabState
  # Get rid of any possible preceeding -
  set key [string trimleft $key {-}]

  if {[string equal $value "NoSuChVaLuE"]} {
    if {[info exists tabState($top.keys.$key)]} {
      return $tabState($top.keys.$key)
    } else {
      return ""
    }
  } 
  set tabState($top.keys.$key) $value
}

proc configure {top key {value NoSuChVaLuE}} {
  variable tabState
  # Get rid of any possible preceeding -
  set key [string trimleft $key {-}]

  if {[string equal $value "NoSuChVaLuE"]} {
    if {[info exists tabState($top.$key)]} {
      return $tabState($top.$key)
    } else {
      return ""
    }
  } 
  set tabState($top.$key) $value
}

proc makeNotebook {top args} {
  variable tabState
  
  foreach n [array names tabState dflt.*] {
      set tabState($top.[string range $n 5 end]) $tabState($n)
  }
  
  set tabState($top.tabSpace) 5
  foreach {k v} $args {
    if {[info exists tabState($top.[string range $k 1 end])]} {
      set tabState($top.[string range $k 1 end]) $v
    } else {
      error "INVALID FLAG: $k "
    }
  }
  
  set tabState($top.y) [expr {$tabState($top.height) -1}]

  set top [frame $top -class Notebook]

  canvas $top.c -height $tabState($top.height) -width $tabState($top.width) \
      -background $tabState($top.background) \
      -borderwidth 0 -highlightthickness 0

  grid $top.c -row 0 -column 0 -sticky news
  grid columnconfigure $top 0 -weight 1
  grid rowconfigure $top 1 -weight 1
  set tabState($top.x) 10
  $top.c create line 0 $tabState($top.y) 10000 $tabState($top.y) -fill black -tag no_del
  set tabState($top.ul) [$top.c create line 0 $tabState($top.y) 10 $tabState($top.y) \
      -fill $tabState($top.selected) -width 3 -tag no_del]

  return $top
}

proc redrawTabs {top} {
  variable tabState
  # Wipes underlines also.  Oops.
  # $top.c delete all 
  
  foreach el [$top.c find all] {
    if {[string first no_del [$top.c gettags $el]] < 0}  {
      catch {$top.c delete $el}
    }
  }
  
  foreach n [lsort -command notebook::cmp [array names tabState *.label]] {
    foreach {id label} [split $n .] {break;}
    if {[winfo exists $top.f_$id]} {
      drawTab $top $tabState($n) $id
    }
  }
#  normalizeTabs $top

}

proc cmp {a b} {
  foreach {a aa} [split $a .] {break;}
  foreach {b aa} [split $b .] {break;}
  return [expr $a > $b]
}

proc drawTab {top label id} {
  variable tabState

  incr tabState($top.x) $tabState($top.tabSpace)
  set el [$top.c create text $tabState($top.x) $tabState($top.y) \
      -anchor sw -text $label -tag "i_$id t_$id" -font $tabState($top.labelFont)]

  foreach {l t r b} [$top.c bbox $el] {}

  incr r 2; incr l -2; incr t -2; set b $tabState($top.y)
  
  incr b -1
  $top.c create rectangle $l $b $r $t -fill $tabState($top.unselected) \
      -tag "i_$id r_$id" -outline $tabState($top.unselected)

  $top.c create line $l $b $l $t $r $t -fill #ffffff -tag i_$id
  $top.c create line $r $t $r $b -fill black -tag i_$id
  incr r 2
  set tabState($top.x) $r
  $top.c bind i_$id <ButtonRelease-1> "[namespace current]::raiseTab $top $id"
  $top.c bind r_$id <ButtonRelease-1> "[namespace current]::raiseTab $top $id"
  $top.c raise t_$id
}

proc calcNeed {top} {
  variable tabState
  set need 0
  set cvs $top.c
  for {set i 0} {$i < $tabState(id)} {incr i} {
    set cid [$cvs find withtag r_$i]

    if {![string equal "" $cid]} {
      foreach {l t r b} [$cvs bbox $cid] {break;}
      set need [expr {$need + $r - $l}]
    }
  }
  return $need
}
proc normalizeTabs {top} {
  variable tabState
  update idletasks

#  if {$tabState($top.x) > [winfo width $top.c]} {
    set need [expr {[winfo width $top.c] - [calcNeed $top]}]
    if {$need > 0} {
      set tabState($top.tabSpace) 4
    } else {
      set count [llength [array names tabState *label]]
      if {$count > 1} {incr count -1}
      set tabState($top.tabSpace) [expr {($need/$count) + 2}]
    }
    set tabState($top.x) [expr {5 - $tabState($top.tabSpace)}]
    redrawTabs $top
#  }
}

proc whereami {} {
  for {set i 0} {$i < [info level]} {incr i} {
    debugputs "I: $i [info level $i]"
  }
}

proc removeTab {top id} {
# debug
# puts "REMOVETAB: $top $id [info level] -- [info level [expr [info level ]-1]]"
# whereami

  variable tabState
  # We can get called twice in the rebuild loop.  Return immediately
  #   if this happens.
  if {![info exists tabState($id.label)]} {return}
  unset tabState($id.label)

  catch {$top.c delete i_$id}
  catch {$top.c delete t_$id}
  catch {destroy $top.f_$id}
  foreach index [array names tabState $top.*$id*] {
    catch {unset tabState($index)}
  }
  update idle;

  # Let's see if this will work at full width, and correct on the fly.
  set tabState($top.x) 5
  set tabState($top.tabSpace) 5
  catch {
    redrawTabs $top
    normalizeTabs $top
  
    foreach w [winfo children $top] {
      if {[string first "$top.f_" $w] == 0} {
        foreach {w tab} [split $w "_"] {break;}
        catch {[namespace current]::raiseTab $top $tab}
      }
    }
  }
}

proc replaceTab {top id} {
  variable tabState
  frame $top.f_$id -background $tabState($top.selected) -borderwidth 0 -highlightthickness 0
  grid $top.f_$id -row 1 -column 0 -sticky news
  bind $top.f_$id <Destroy> "[namespace current]::removeTab $top $id"
  
  drawTab $top $tabState($id.label) $id 
  [namespace current]::raiseTab $top $id
  return $top.f_$id
}

proc insertTab {top label {return mt}} {
  variable tabState
  upvar $return id
  
  set id [incr tabState(id)]

  set tabState($id.label) $label

  frame $top.f_$id -background $tabState($top.selected) -borderwidth 0 -highlightthickness 0
  grid $top.f_$id -row 1 -column 0 -sticky news
  bind $top.f_$id <Destroy> "[namespace current]::removeTab $top $id"
  
  drawTab $top $label $id 
  normalizeTabs $top
  [namespace current]::raiseTab $top $id
  return $top.f_$id
}

proc newTab {top id} {
  variable tabState
  
  set id [incr tabState(id)]

  frame $top.f_$id -background $tabState($top.selected) -borderwidth 0 -highlightthickness 0
  grid $top.f_$id -row 1 -column 0 -sticky news
  bind $top.f_$id <Destroy> "[namespace current]::removeTab $top $id"
  
  drawTab $top $label $id 
  [namespace current]::raiseTab $top $id
  return $top.f_$id
}

proc getID {frame} {
  return [lindex [split $frame _] end]
}

proc raiseTab {top id} {
  variable tabState

  if {$tabState($top.tabSpace) < 0} {
    set tabState($top.x) [expr {5 - $tabState($top.tabSpace)}]
    redrawTabs $top
  }

  raise $top.f_$id
  update idle;
  foreach {l t r b} [$top.c bbox i_$id] {}
  incr l -1; incr r -1

  $top.c coords $tabState($top.ul) $l $tabState($top.y) $r $tabState($top.y)
  $top.c raise $tabState($top.ul) 
  foreach i [$top.c find all] {
    if {[string first r_ [$top.c gettags $i]] >= 0} {
      $top.c itemconfigure $i -fill $tabState($top.unselected) \
      -outline $tabState($top.unselected)
    }
  }
  $top.c itemconfigure r_$id -fill $tabState($top.selected) \
      -outline $tabState($top.selected)
  $top.c raise i_$id
  set tabState($top.topID) $id
}
proc getTopID {top} {
  variable tabState
  return $tabState($top.topID)
}
proc getLabel {top id} {
  variable tabState
  return $tabState($id.label)
}
}

proc notebook {args} {
  return [eval notebook::makeNotebook $args]
}

if {[info exists argv] && ([lsearch $argv "-testnote"] >= 0)} {

# eval destroy [winfo children .]
notebook::makeNotebook .nt
grid .nt -row 0 -column 0 -sticky news
grid rowconfigure . 0 -weight 1
grid columnconfigure . 0 -weight 1

set f [notebook::insertTab .nt one]
canvas $f.c1 -width 20 -height 30 -background red
grid $f.c1

set id [notebook::getID $f]

set f [notebook::insertTab .nt two]
canvas $f.c1 -width 30 -height 50 -background red
grid $f.c1

set f [notebook::insertTab .nt three]
canvas $f.c1 -width 50 -height 90 -background red
grid $f.c1

notebook::raiseTab .nt $id

notebook::makeNotebook .nt2 -selected #ecc -unselected #caa \
    -background #dbb -labelFont {times 18 bold} -height 35 -font {arial 10}
grid .nt2 -row 1 -column 0 -sticky news
grid rowconfigure . 1 -weight 1

set f [notebook::insertTab .nt2 one]
canvas $f.c1 -width 20 -height 30 -background red
grid $f.c1

set f [notebook::insertTab .nt2 two]
canvas $f.c1 -width 30 -height 50 -background yellow
grid $f.c1

set f [notebook::insertTab .nt2 three]
canvas $f.c1 -width 50 -height 90 -background green
grid $f.c1

set id [notebook::getID $f]

notebook::raiseTab .nt2 $id
}

set release(togglebut.tcl) {$Header: /home/cvs/AuStuff/togglebut.tcl,v 1.1.1.1 2006/08/01 21:09:37 clif Exp $}
proc toggleButton {name vals textvar args} {
    global tcl_platform
    ::Togglebutton::init $name $vals $textvar
    if {[string match $args {}]} {set args ""}

if {[string match $tcl_platform(platform) "windows"]} {
    eval button $name -textvariable $textvar $args \
        -text [list [lindex $vals 0]] \
        -command {"::Togglebutton::cycle $name"} -pady 0
    } else {
    eval button $name -textvariable $textvar $args \
        -text [list [lindex $vals 0]] \
        -command {"::Togglebutton::cycle $name"} -pady 0
    }
    return $name
}

namespace eval Togglebutton {
    variable values
    variable indices
    variable textvars
    
    proc init {id valList textvar} {
    variable values
    variable indices
    variable textvars
        set values($id) $valList
	set indices($id) 0
	set textvars($id) $textvar
    }
    
    proc cycle {id} {
    variable values
    variable indices
    variable textvars
        incr indices($id)
	if {$indices($id) >= [llength $values($id)]} {set indices($id) 0}
	namespace eval :: " \
	global $textvars($id); \
	[list set $textvars($id) [lindex $values($id) $indices($id)] ]; \
	"
    }
}

if {[info exists argv] && [string match $argv "-test"] } {
  set b [toggleButton .t1 { {Ignore A} {Or A} {And A} {And NOT A} {Or NOT A}} \
    foo(a) -background pink]
  pack $b

  set b [toggleButton .t2 { {Ignore B} {Or B} {And B} {And NOT B} {Or NOT B}} \
    foo(b) -background yellow ]
  pack $b

  set b [button .b -text "WHAT?" -command {parray foo}]
  pack $b
}

set release(help.tcl) {$Header: /home/cvs/AuStuff/help.tcl,v 1.1.1.1 2006/08/01 21:09:37 clif Exp $}
# This file contains code used to implement the Help menu
#

# Everything in its own namespace
#
namespace eval ::help {

# Pop up the "About" dialog box.
#
proc about {{parent .}} {
  catch {destroy .about}
  toplevel .about
  wm title .about About
  wm iconname .about About
  wm withdraw .about
  wm protocol .about WM_DELETE_WINDOW {.about.bb.can invoke}

  frame .about.bb
  pack .about.bb -side bottom -fill x
  button .about.bb.can -text Dismiss -command {destroy .about}
  pack .about.bb.can -side left -expand 1 -padx 10 -pady 5

  label .about.l1 -text "AuReporter.tcl- Linux Kernel Audit Reports" -font {arial 18 bold}
  label .about.l2 -text "Copyright Clif Flynt, 2006" -font {arial 12 bold}
  label .about.l3 -text "clif@noucorp.com" -font {arial 12 bold}
  label .about.l4 -text {
 This licence agreement must remain intact with the code.

 You may use this code freely for commercial or non-commercial purposes.

 You may examine and modify the code to your heart's content.

 You may not claim to have authored the code (aside from modifications you may have made.)

 You may not distribute the code without this license agreement

}

  pack .about.l1 -side top -fill both -expand 1 -padx 10 -pady 10
  pack .about.l2 -side top -fill both -expand 1 -padx 10 -pady 10
  pack .about.l3 -side top -fill both -expand 1 -padx 10 -pady 10
  pack .about.l4 -side top -fill both -expand 1 -padx 10 -pady 10
  ::update idletasks
  centerWindow .about $parent
}

proc versions {} {
  global release
  global tcl_platform
  catch {destroy .versions}
  toplevel .versions
  wm withdraw .versions

  grid [text .versions.t -bg white] -row 0 -column 0
  grid [button .versions.b -text OK -command {destroy .versions}]

  foreach n [array names release] {
    set l "$n: [lindex $release($n) 2]"
    .versions.t insert end "$l\n"
  }
  centerWindow .versions .
}

proc help {{helpType {}}} {
  variable helps
  global tcl_platform
  set helps(_stack) ""

  catch {destroy .help}
  toplevel .help

  wm withdraw .help

  set w [text .help.t -yscrollcommand {.help.sb set} -bg white -width 90]
  grid $w -row 1 -column 1 -sticky news
  grid columnconfigure .help 1 -weight 1
  grid rowconfigure .help 1 -weight 1
  HMinit_win $w
  
  set w [scrollbar .help.sb -orient vertical -command {.help.t yview}]
  grid $w -row 1 -column 2 -sticky ns
  
  set f [frame .help.f1]
  grid $f -row 0 -column 1 -columnspan 2 -sticky ew
  
  set w [button $f.back -image icon:back -command {help::_back} -relief flat]
  pack $w -side left
  
  if {![string equal $tcl_platform(platform) windows]} {
    set w [button $f.q -image icon:del -command {destroy .help} -relief flat]
    pack $w -side right
  }

  set hit 0
  
  if {[string match $helpType ""]} {
    foreach w [winfo children .bb] {
      if {[string match [$w cget -relief] sunken]} {
        set hit 1
        _insertHelp $w
      }
    }
    if {!$hit} {
      _insertHelp generic
    }
  } else {
      _insertHelp $helpType
  }
  centerWindow .help .

}

proc _back {} {
  variable helps
  if {[llength $helps(_stack)] == 1} {return}
  # Clear the current page
  set helps(_stack) [lrange $helps(_stack) 0 end-1]
  set bck [lindex $helps(_stack) end]
  set helps(_stack) [lrange $helps(_stack) 0 end-1]
  _insertHelp $bck
}

proc _insertHelp {id} {
  variable helps
  
  .help.t configure -state normal

  if {[string equal $helps(_stack) ""]} {
    .help.f1.back configure -state disabled
  } else {
    .help.f1.back configure -state normal
  }

  lappend helps(_stack) $id

  .help.t delete 0.0 end

  if {[info exists helps($id)]} {
    # .help.t insert end $helps($id)
    set n [lindex [split [string trim $id .] .] end]
    set n [string map {_ { }} $n]
    wm title .help $n

    HMparse_html $helps($id) "HMrender .help.t"
  } else {
    .help.t insert end $helps(generic)
  }
    .help.t configure -state disabled
}

# End of the ::help namespace

# PUT helpfiles in another file.
# set helps(IDENTIFIER) {
# HTML Help message
# CAN INCLUDE <A HREF=OTHERIDENTIFIER> fofo </A>
# and IMG 
# }
}

namespace eval help {

image create photo help:over -data {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}
image create photo help:selTime -data {
R0lGODlhmABuAPEDAAAAAIKCgtnZ2f///yH5BAAAAAAAIf4RU2VsZWN0IFRpbWUg
UmFuZ2UALAAAAACYAG4AAAL+lI+py+0Po5y02ouz3rz7D4YgQJZmZwIHObHi+7qf
7MqQDeccrfZsuQIqeIJTUfhL6ZYbYk11jEoTwqDheQTimNxE4AtGOKFYLKO6TUKn
4Lb7DY/L5/T6e4DHi9fJK9lndGaW1WdlkIeYqLjI2Oj4CJkYMCBoZVZY6acphTnV
9SkwOZkZdemzuWeopmnzA/opSrkwtvm05VfFqbaG+soU6xssfAE8bHzcUIy8vKzM
/CzsDD0NOzBqh52tvc3d7Y0dak35TV5ufo7eNi4eGkD9nqMH/AVfHyLPTm+/z4F/
7c4vIAZ/4wAKPDiBYDuEDCMo1Ncw4oKHBiVaPLTu38X+jQIocrzo8aPEkCIbkiyJ
8CRKgSpX8mvp0h7FSDRr2ryJM6dOSOGu7fwJNKjQoYh6yooZMVa6pUybOlU3iajU
qVSrJkKKNavWrdNSKGny1cEtrg3GZjA7ixfZB06yuMWltlcpPqfWRqClKy8VtVpO
5Vr7JhWrP4PlEiqEGMrTxeeuGppbC9BfT3nNWL0cdFRaS4Qhl+VLeBBZaY8TF6ZM
uQwgu0ZJmdZ1y6veTlxJs55m+/az3Lqbsev9jjdwY/MYGz+OPEzx5Mybo8tYcDgy
mNJBUa/e5Tp2Jtq36+juHQb48CLGkwdh/ryH9Or7QV/Yngv7+Bnm079g/36F/Pr+
E76H2F95/0WFWYEGHtgagQcuyKBUrQXIhVLOTUghOeI0iGGGREHIjIZF7edhUBaE
aM2IJO5UkQR6+AKgikcJ1KJDL8KSoowMxQjBiq/g+ICOMNaY44xd8OiAjwER2YCR
QwLZo5D7IMmAkhEyWaST9kA5kZVLYKmAlFdSmaSWaU1GAZcJeCkIWheoeYCZCKA5
BF0ZuHkAnHsZpgGbBtCJkQRjBQIBnx2JKdgeqgXBg2gOCGrnY4LpCR8Fjcqlml+h
XSoBo4Sq0heeC2jqZ1ycncYpagyAehcvrwUKZpSbGqbEoYZ2GgGqN6haF6S2sgXa
abThoGurWbYgp6LJCNtf5auRyWqarKyaSMEJf0AaqX/RIrHLsnQZeyqyZyobwq5H
evsmuCCIyw+6U0KLkLq/kFunuc3A2yeL9A56472TiuBuPf3q8G9w+srrQcDUaFrh
wAmTM+LCDS/8DYfLFAAAOw==
}

image create photo help:selName -data {
R0lGODlhmABGAPEDAAAAAIKCgtnZ2f///yH5BAAAAAAAIf4JQ3VzdG9taXplACwA
AAAAmABGAAAC/pSPqcvtD6OctNqLs968+w+GIECWpkGiQGSmlCvAmSuLYq3mED6V
ukZb2Yaw1CnIq51iK2VQ9WT+DkYfk3bNDllCqbc6nT5bCaN0LIwiomgdDxSIy9dd
djPdpR7x2nLzzAfo5efGZ2cgl6i4yNgYMAAJSadXeGU1SSm4gGTZlhTYclcpEFlq
eoqa+shQBCraINO2ifc6CaZwiKkm8rg6m1n1ihNrmIep2RoGfFc8atM7wFo3/XV5
DBWIS22pa5xZnfvWAb1Vbn7uQI6+zr6l3g4fv/EuX28fQX+vv39A7vgPMKDAgQQL
GjwIUIA/hAwbOnwIkWC0hfwqypNE0aLG/nUYB6yKszGkuY4fA4g8aYPkRJMoW3pQ
qZCly5kZYIKkidOCTZk5e0LY6TPoA6BCiyogajQpqYkeVypVivSp0KhSfVKtmvMq
Vpo7U3n9Cjas2LFky5o9y/Qj2rVs27p9W1Zh061PoUW8izev3oFN4fr9CzgwWbqE
jwqOW+Gw4lM6F4flKcGxY8gRJMW7ScFyTswTNLfjHDlaT9CVRcMj/dM0TtRDVbNj
7cAzTdgNZK+jzcC2S9wLdJ/jbdgn8AS+zQ1HUPzk8QPJtVmzsNxAcz/iMFRHEH1p
j20Xsk9fNsIbA++uYYnnJoG8hGFWbqFHf70f5dTrxe9KN791fUKArkTJcv+Aelxg
U016+cVWnjTmFehEDvEhcmBtCf5CyX0NCLiDN2TIosceBja2X4XZBBhhbhNqw98t
AA6izHgl9nYiig6OiB+IIS6hojA6slhjYjE698d7EGDIBSc40jKNhS7aeNqLwY3m
JHE/DkHkbFEiN+UzVzKXpUZV3raldF1a9CU6ZbZ0pnFhagclk5+t+Z2XcI4Jx5zC
zbkXQY3lyWciOvUp0J+A9llYoQYUAAA7
}

image create photo help:selName2 -data {
R0lGODlhmABGAPIFAAAAAIKCgo6OjtnZ2ezs7P///wAAAAAAACH5BAAAAAAAIf4J
Q3VzdG9taXplACwAAAAAmABGAAAD/ji63P4wykmrvTjrzbv/YCiOZEkCaKoqKAtU
aovJA93Jtmnmbk/xl5TPg3vpjrTWqgjMrWovZ9E1hQ4XSiEUt+0eYUarOHu9TmMN
pfVsrDKqbB+QFKjb32F4tB3GLvleaVFrgIRignKAegp2jY6PkJEBBZSUeH6JW1qX
mIYPTJpxTYUxe5kDlamqq6ytkxBJpKYRNnGffLOXZA6LnG4mk6+3nVmzPLWKfZye
sWXEe8mnOsEFsHnXY5vLVIW82Jq+yp3ZvXMh1F/p6usS6Ozv8F/u8fT1H/P2+foV
1KX+/wADChxIsKDBgwgD9pPEsKHDhxAjSpxIsSGAhRUzatzI/rFjxAIXC0y6GGCf
yZOoQGJEKcEcSw+UQo6s89JazRIxV4JAM0LbTRA5RaosufNNT5c/MwSdSTSXlzxY
ahilEhUZVJ5JgaoUSlIOi6pRv/ZpE5aL1K/ksoZYOhTtWahv0WKFS7esH3FqNbDt
evbtE7Jx3fKsK/du3g97afYFbHQQ48BTITP2eVjpVqaCM2vuK9nrYsFIK0tI3DRs
oM9uFyc5FOgaXtEVSMd73ZI27NGX28KzbfO2ZZm63/Ee5huD7OLIcQMn2aq58+fQ
o0ufTr269dwhr2vfzr279+nLE4ofT768+fPUPKpfz749RKHf48ufT3968vsi6lfX
q7+//ir+/j0nAIAB6keUcQUQoOCCDDbo4IMQPijAgJYVpxiCEWao4YYETMifhQde
QAmHJJbYIYUIgsifiSxm6GGFvl0oYoIt1tjgiynGGKIFI9ro44kf6rjijzbiOKOK
lpkYw49G8lhNEJR9EBojO8ZGI4coLJhlkSgeacEvOw1H5ZAbbumgCiU2aeWX4vyV
yxPgsNZOlRT0WCYAD25ppoZq1vnkD8qwYYotu1Ago5Mk6pkCAYqS2OcEloBBizFO
ZSNnBIdamSieWuLZKIeP4samN0LYclepYg6QqZ+bMpjlpxuGGkGkgCLCTKVSWLAq
pFfe2SmjnO7pYpdOQslND4RSg3opBLvipuSiwS7qKLFrQgmKm8dmO6WqdPJKJJdB
3tbsrL1+mya1fiKJobksygoBrbCN+2657MaKLq/qzlivie4+AK9o8vpL774R9uvA
v5UFfPDABEt4r6hCJtmwveHG2y1uE2as8cYcd+zxxw+T697Ij+gF8skop6wXySzf
gd/LHSQAADs=
}

image create photo help:over2 -data {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}

image create photo help:custom1shrink -data {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}
image create photo help:syscall -data {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}
image create photo help:cus2 -data {
R0lGODlhBwMzAPcAAAAAAAALAAgLCAARAAAeABwHBBAQEBgaGAAkAAAqAAAyAAA6
ACoKBjkOCCAcICAhICAoICgkKCgqKCgwKDMzMzg0ODg4OABDAABLAABUAABcAABk
AABrAAB0AAB8AEcRClUUDEcjI2MYDnYcEUA7QEBAOEBAQEhBSEhKQEhKSFBMSFBR
SFBRUFBYUFhaUFhZWFhgWFBoYGlcTGhiWGhoWGBhYGhpaHBqYHBqaHBwaHhyaHh4
aHBycHB4cHhzcHh4cHx8fAAA2AAA+ACAAACLAACWAACeAACjAACrAAC1AAC8AADE
AADMAADVAADcAADkAADpAADzAAD8AAD8+DD8+I0iFZslF6opGbgsG7IiIrAwYIB4
cIB7eJhoYJh6aKBsaKh4aMYvHdQzH/4AAOI2IfovL5gA+IB8gPgAmNtwk4iEYICB
eIiCePr8APj8MIGCgYCMgIiCgIiJgIyMjJCKgJCKiJCAkJCQgJCRiJiSiJiYiJSU
lJiUkJiZkJiZmKCIgKCZkKCcmKCgkKCgmKiimKCkoKikoKiooLCsoLCsqLCwqLiy
qLi4qLGysbC4sLi0sLi5sLq6upj7mLjAuM23nsC8sMqzysDAsMDCuMjEuMjIuMDA
wMjMwNDMwNDQwNDUyNjUyNjYyNPT09ja0NjY2ODc0ODg0ODk2Ojo2OXm5ezs7P7+
/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAACH+IVNlbGVjdGlvbiBiYXNlZCBvbiBTWVNDQUxMIGZpZWxk
cwAsAAAAAAcDMwAACP4ASQkcSLCgwYMIEypcyLChw4cQI0qcSLGixYsYM2rcyLGj
x48gQyJctUoigJMARKpcefHNG5YwY8qcSbOmzZs4c+rcyZMhyZ5Ac7oMSrSo0aNI
kypdyhQnSZdQo7o8I7Wq1atYs2alqrWr169gww5tSras2bNo06pdG3GV2Ldw48qd
S9cr0Lp48+IFordvVK5bwQKGynfuYKiHA//FWthqYsGQ3w5+DLZx3MeUI7/JjFgz
YayctYb2O7qzVMt+U4NWzZpuacVfX7tEDZWk7du4c+vezbu379/AgwsfTry48ePI
kytfzry58+fQo0ufTr269evYs1tny7279+/gw/6LH0++vPnz6NOrX8++vfv38OPL
n0+/vv37+PPr38+fPkqUBKUEkYAcEViWgf0lqOCCDOaHIIIDegRhgxRWaOGFGBZo
kIAEAihQSh6S0qGHDwY4UIciinhSgCGCuOJBIar4YoortqiijDCeOOOEGfbo449A
igQhhx+e+CGKKSZZZIlGFrkkkgZyiKSJTkZ55JVJvqjlhk4qGeSXYIYppkJRddkk
kQVZ6eWZTZoIYpZUqqkmlXTC2SWaSg5ppkFXnSHbZoY5JtufX9HWp5+e5WXoaq0B
ClujkDoWqWiTPlrppZhWRShpmd62p504momnjHjq+eaoUv4nKpdpxtlmqf5tvjoj
QdrVauutuOaq66689urrr8DeyqqrrXoJ651rLknjqskaO2ysx4I6Zayfjmnttdj6
qGeyqFZJ55tcnsrshHNS62yebCJbbJ3Ztuvuu/wxKS2Wdo5oJI9Tyknsp1Du26+6
/sIr8MAEw/ffrCOiaOOR4FYL8JyqMpsmwgujazG3Ok5b8MYcd9wejwyB7PHIJJds
8kQiK5TyySy37PLIK28Y88s012zzzTjnrPPOPPe8X7BABy300EQX7avPSDtk9NLA
vcE0rk4/Dd0cUmv3UtJYJ/STtS5tbV/Xq6gi9thkl2322WinrfbabK89B9Ul1TdW
1nTTGveYYOMHdv7bfPft9998v+31fHPXXffgYeZ9396AN+7442rPsQfi8RVueNaU
f6n411FD7vnnjgt+N+FX0yfK5WplnqPBE22+0Mwdwb56RIyzDQDouJ99O997wO2Q
7GhZDtTpqDOo+rMftx717zUBvy5Eta+9e+7UqzI926Izb57wxfd8/LoAEhljxDSm
im/FeVKsvsKp3jvrQq6rnDGc49uoZYzuR1k/+7BHr/b0KLGe2G4XwLH9x4DW290B
dXcSsi1wgW7zXUMSRr/1uY9h5wOXizCYv4dwr3s7+56/pJSuKk1rW94qYbfOtaMz
aSwh8UtIqUiYQhNCS2YlnNeNHManzrVNgf4GVCAAB+jAAQ4RgWU74vWAyDsJhuxO
NARVlk44rPvdcIfNOsgHQZgzEeZwhfq6ogzH9SxySUyM8FveBMn4xTOisFmjOiOZ
fGg7IiJxiXa0Ix6RWMT/5RF7TnwdG2soxXINkoXsgmHpuOi90ckPkW001sEQEjGI
7WiSGVthnWYWQ0oeEowsIh8ayYc+TtJRen9koh77uMSDme16DiwgLCMXyEeGkZCo
wuQmRYVJQyqSkUjzIi4/KcfZaTKH3yqmLxHSydXdspDFfF6+WLVMLZ7SjwK8Iyu3
yUe0zTKb2fwm2rK3RkgO81xjjKQ0HbJFYNZMmNA0ZzzTec597RKdaP6cIzxBGclq
XtGXx9Rn2H6YyoKCM5x9TNss9yjOs0lun8SUZ8qeaUZzMXOR7gQS8UQC0fRFtFwo
3BKW/lVDkarLnwVpJjV19NF7skiFx0IpQfyn0Dw28KCqRGg3F6pNI/4xgh21l0Td
WMVjRtGUGeVZR3GkSVJO7H3zoyAFMxlKKYYKnwLVHlMl5tRQmnF/6aNiQ2jqzSAS
0KAJvOlB0yrOAhrxrGltGzmfyLB5dpWqMKrRnpyKvzkmNYSOjIjz1qPScn6HrH1r
aPWoN1eUyQR2g23nX1kGz3zqTY0PkelZEFvTbi72s6roXWWjqSGLelIikp3sRzZK
odFysD+FpdlkX7nDWYW6FbSgbezvZish3p6WdhhVbctO51oKxbY9tcWtcgFZXPKk
VmesZS1gM0Xd6krlKdbNrldIIrm3va133g0veMUbXu+Cd7zl/a4dyjte9Jo3ve79
rny7S1+4afe+VxFuSKSrFv7KxC34DXCjACzgAjstveyd73vJW98Fx/e8CZ6veyes
YASvV7QGznB1F3UpDs/Fw5kKzaYm9RgQ62U0I9awiiml4RSv+MXUdbF2ZVyVqtn4
xjjOsY53zOMe+/jHw9GvkIdM5CIb+chITrKSl8zkjQQEADs=
}
image create photo help:cus2a -data {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}

set helps(overview) {
This application allows the user to select and view audit events
from /var/log/audit/Log*gz files or using ausearch.
<P>
Data can be selected to match certain fields and values, and can
display fields from different views of an event.
<P>
<IMG SRC="help:over">
}

set helps(File/Exit) {
This selection exits the application.  All changes will be saved.
}

set helps(File/Rescan) {
  Rescans the flat files and rebuilds the database used to construct
the reports.
<P>
  The user is first prompted for new start and end times.  These can
be entered as with ausearch as either a date <B>MM/DD/YY</B>, a time,
<B>HH:MM</B>, or as both: <B>MM/DD/YY HH:MM</B>
<P>
<IMG SRC="help:selTime">
}

set helps(Tools/Scan_for_Logins_and_Password_changes) {
  Scans /var/log/messages for PAM, pam and password change events.
  <P>
  This is not associated with auditd, but is something a security 
check needs to view.
}

set helps(Tools/Save_Custom_Report) {
  Allows the user the save the settings of the last run custom report.
<P>
After generating a custom report (see <A HREF="Generate_A_Customized_Report">
a sample custom report </A> for details), the user can save those settings
by selecting this menu option.
<P>
  A button to build the new custom report will be placed in the
button bar after this is evaluated, and whenever the application 
is rerun.
<P>
The user is prompted for a name for the new button as shown here:
<P><IMG SRC="help:selName">
Assuming the new report is to be named <B>newReport</B>, the entry
is filled in as shown:
<P><IMG SRC="help:selName2">
Which causes the GUI to be reconstructed with the new button as 
shown below:
<P><IMG SRC="help:over2">
}

set helps(.Menu) {
  The Main Menu
  <P>
  The menu window contains the File, Tools and Help menus.  More
details are under the Help/Menu menu area.
}

set helps(.Task_Buttons) {
  The Task Buttonbar
  <P>
  The buttonbar holds the quick task buttons.  These will always include
the 
  <DL>
    <DT> <IMG SRC="icon:clear">
    <DD> Clear the text window.
    <DT> <IMG SRC="icon:stop">
    <DD> Stop a currently running report.  If you can see that the selection
    criteria is too broad, or you can already see the event you want to look 
    at, you might as well hit this.
  </DL>
  <P>
  If the user has created custom reports, the buttons for them will
be placed in this area next to the picture Icons.
}

set helps(.textWin) {
  The Main Text Window
  <P>
  When a report is generated, the results appear in this window, one
report record per line.
  <P>
Each line is active.  Left clicking on the line will bring up a detail
window showing all the elements in the database that have the same
MSG field value as the value displayed on this line.
}

set helps(Generate_A_Customized_Report) {
Customized reports can be generated using the fields in any single
table as the selection criteria, and displaying data from all records
that have <B>Msg</B> field value that matches the <B>Msg</B> field
in the selected record.
<P>
In terms of <CODE>ausearch</CODE>, this is selecting certain values from
the lines that are grouped together between a set of <B>---</B> characters.
<P>
The Customized Report definition windows all resemble this:
<P>
<IMG SRC="help:custom1shrink">
<P>
The upper, white section is a list of the types of reports generated,
and the fields that can be selected to be displayed.  Clicking a label
will select that field to be displayed.  The image below shows the possible
fields to display from a <CODE>SYSCALL</CODE> report.
<P>
<IMG SRC="help:syscall">
<P>
The lower, gray section is a list of all the fields in the table you
have requested to make a selection from, and the possible values these
fields can have.  The default condition is to ignore the values in
each field, as shown below for a selection from the <CODE>comm</CODE>
field.
<P>
<IMG SRC="help:cus2">
<P>
The buttons will toggle state when they are clicked, allowing the user to
select for records in which this field has a value <B>(AND value)</B> or
does not have a value <B>(AND NOT value)</B> and some other value or if
the value is a logical OR with other values.
<P>
The image below shows the different options for the comm field in this
collection of records:
<IMG SRC="help:cus2a">
<P>
If there are more than 40 distinct options for a field, a button is displayed
instead.  When this button is clicked, a new window is created with more toggle
buttons. This window resembles the frames in the gray selection area of the 
custom report window.  It also has a scrollbar allowing the user to page
through the possible values.
<P>
When you've created the selection criteria and the fields to be displayed,
you can click the <B>Generate Report</B> button at the bottom of the display
to generate the report.
}

set helps(Tools/Custom_Report_On_CWD) {
Generates a custom report using the fields in the CWD table as the
selection clauses.
<P>
(see <A HREF="Generate_A_Customized_Report">
Generate A Customized Report </A> for details)
}

set helps(Tools/Custom_Report_On_PATH) {
Generates a custom report using the fields in the PATH table as the
selection clauses.
<P>
(see <A HREF="Generate_A_Customized_Report">
Generate A Customized Report </A> for details)
}

set helps(Tools/Custom_Report_On_SYSCALL) {
Generates a custom report using the fields in the SYSCALL table as the
selection clauses.
<P>
(see <A HREF="Generate_A_Customized_Report">
Generate A Customized Report </A> for details)
}

set helps(Tools/Custom_Report_On_DAEMON_END) {
Generates a custom report using the fields in the DAEMON_END table as the
selection clauses.
<P>
(see <A HREF="Generate_A_Customized_Report">
Generate A Customized Report </A> for details)
}

set helps(Tools/Custom_Report_On_DAEMON_START) {
Generates a custom report using the fields in the DAEMON_START table as the
selection clauses.
<P>
(see <A HREF="Generate_A_Customized_Report">
Generate A Customized Report </A> for details)
}

set helps(Tools/Custom_Report_On_DAEMON_ABORT) {
Generates a custom report using the fields in the DAEMON_ABORT table as the
selection clauses.
<P>
(see <A HREF="Generate_A_Customized_Report">
Generate A Customized Report </A> for details)
}

set helps(Tools/Custom_Report_On_CONFIG_CHANGE) {
Generates a custom report using the fields in the CONFIG_CHANGE table as the
selection clauses.
<P>
(see <A HREF="Generate_A_Customized_Report">
Generate A Customized Report </A> for details)
}



}

set release(imgs.tcl) {$Header: /home/cvs/AuStuff/imgs.tcl,v 1.1.1.1 2006/08/01 21:09:37 clif Exp $}


image create photo icon:stop -data {
R0lGODdhFgAWAJEAAMi0yAAAAPj8+PgAACwAAAAAFgAWAAACo4RP8TEIPgbJRwmC
byE0H0eC4IfQfDwJAAIiNB9TAoAizsc0iSBxPiZGCM3HxAihjfJlbuZoiYzMDE0b
kRGhaTIRMqRtRmaEZo2MSFA0kZkR2mQjI0NaQmZGSNOMzAxpEpkIoXkyYnKkaWYi
hObJiInQpJGZCYomIjNCs0RMbCgRzcc8CaCI8zFHAgiI0HxECYIdQvPRJAg+BMlH
C4J/FB+NYBcAOw==}

image create photo icon:clear -data {
R0lGODlhFgAWALMAANnZ2QAAAMjMyPjMMPj8AJhkADAwMJiYmPj8+PhkYP//////
/////////////////yH5BAEAAAAALAAAAAAWABYAAASzEMhJq714hpBzgCEECOSk
VQYxQrC2wjAGCRDISSsIYgwSrKVQGIOEAIGctAYxSAkVGHjklCEEEoI0AEAADERy
ypBCKAGdACAAwEAkpwwppSBPAAACYBAMcsqUAkLoBAAgAAYiOWcI9AQAADAQyUnr
CQAAYGqt0AkAAGAQDHLSiU4AAAADkZy0ngAAAKbWCp0AAAAGwSAnnegEAAAwEMlJ
6wkAAGAMPHJSagIEcsIgJ60BgAgAOw==}


image create photo icon:back -data {
R0lGODlhGAAYANUAANnZ2ejw+KjA2EiQ4DCA2BBw0JCo0PDw8EiI0JjI+IjA+Fig
6ODg4Pj46PD4+MjU4PD08NDo8LjY+KjQ+Ojo6Mjg+HjA+Giw8ABgyNjY2Njo+Ljg
+EigyJCgsPj4+DCY6Li0uFBwyDBosLCwsACA2Gh4qCBYqMDE0BBIkKioqIiMiIiI
iGhwkOjo8NDQ0AhYsDBUgMjEyEhIUJiYmDBIeJig4FhYWFBYiGhsaMDAwOjY0JCQ
kHh4eP///////////yH5BAEAAAAALAAAAAAYABgAAAb/QIBwSCwaj8SAYEAoEAiG
A9IYKCAMgoRiQUAwGkih40F4NCARyWSiIBQMFKSBEIFEKpOEwqK4XICLASbjAAKE
QgdBc9BsJonNRLG4DDgLQocxFAYeh0clodg4PJXL5TMYDAogyhBAqEwSCUXA4xGE
BoPCpwAkYEQjCsDxIEwmCovG4/GEBh8CoUAqYDClDACAQCgUl4vH42EQCARSAVPA
YDCmEwBAuCgUl4oH6PE8FpfLYIEgYDAYVAoAKFwuFwfQIxwShQQMBqUCAAqLC4dR
LAoJGAxqBXAQPgsEi0KEtA6Hw8FVwGBQKwCgUxh8CKghA/gSDjEYDAa2AgBiGMKA
ilQAeTweIEY4HL5kMwDgYCIUCgWay+OpEYkoWwcAANQKpILwxvBACsShDJcDAACA
FxGDKpmIQxkudwAAAEAA6wXECIWo4RDzsnUYQIBQqLu9gBjhkIhByXYuCBAgHB4y
O9oLg8FgXiiZDDc7DIdDAIMnk8FoNJkMpxplhsPhMANKqXg8nmp0ag2FQQA7}

 
image create photo icon:del -data {
R0lGODlhEwATANUAANnZ2fj4+OiMcOh8YOh0WOBoSOBgQOBYOOBcOOBUKNhMKNg8
ENBQMOigkOiYgOBwWOhwUMhAILhAKNBIIKgwEOBsUOBgSPj8+PDQyKgwCOBYMNhM
IOBIGMAwCOhUIOhMEOBoQOhgMOA8ANA8CNgwCKAkANAsALAkAP//////////////
////////////////////////////////////////////////////////////////
/////////////////yH5BAEAAAAALAAAAAATABMAAAb/QIAQGBAOiUMgQCgUDAgF
g+GAOBwSCcWCMRQ0Gg7BYDAgEB6QwoERkQACg0bDIQAOhELCo2A4TCiBwMPREAgG
j0elYCkgDowJJRCACASCy6VSMCAOF4yCMckEAobhIxAwHDSBwEUBVEwygYCBMCAQ
AoHAIRAIbDibSSYQODwehEcBGBAKFRzOZtIRHgqVB6RQGHo2HA5n0hEmCpAKpDAU
ejgfToQiVBgKkMrQIMR8OJxFR8g5WAoVIRAUCgUCH45olAkEFhqDJRAAGQwhTyDw
EY0ygcCCw9AcDqGDJ+H5fEQiUikQIC02CUaCoVBsOBygSEQylQKASKfTmUgiklFk
IDQymUydDAAAkJSAFOEwkzmdTqUMECAUAgPCIXEIAACCADs=}
     


#####################################################################
# NAME:   help.tcl
# AUTHOR: Clif Flynt, Brent Welch, Steve Uhler, others
# DATE:   10/2005
# DESC:   html display library
#         
# PARAMETERS:  
#  many and varied
#
#####################################################################
#
#   Contact: clif@noucorp.com
#
#####################################################################
set release(htmllib.tcl) {$Header: /home/cvs/AuStuff/htmllib.tcl,v 1.1.1.1 2006/08/01 21:09:37 clif Exp $}
#!/bin/sh
# \
exec wish "$0" ${1+"$@"}

# source debugit.tcl

set HMDebug 0

proc calledFrom {} {
    return [info level -2]
    set l [info level]
    incr l -1
    set rtn ""
    for {set i 2} {$i < $l} {incr i} {   
        append rtn "-- [info level $i]\n"
    }
    return $rtn
}

proc fullCalledFrom {} {
    set l [info level]
    set rtn ""
    for {set i 2} {$i < $l} {incr i} {
        append rtn "-- [info level $i]\n"
    }
    return $rtn
}
  
proc showVariable {n i o} {
    upvar $n nn
    if {[string match $i ""]} {
        puts "$n: $nn"
    } else {
        puts [format "%s(%s) %s" $n $i $nn($i)]
    }
    puts [FullCalledfrom]  
}

proc debug {args} {
    global HMDebug

    if {$HMDebug == 1} {
        eval puts $args
    } elseif {$HMDebug == 2} {
        if {[llength $args] == 2} {
	    foreach {opt str} $args {}
            puts $opt "[calledFrom] >> $str"
	} else {
            puts "[calledFrom] >> $args"
	}
        puts "---------------------------------------------------"
    } elseif {$HMDebug == 3} {
        if {[llength $args] == 2} {
	    foreach {opt str} $args {}
            puts "[fullCalledFrom] >> $str"
	} else {
            puts "[fullCalledFrom] >> $args"
	}
        puts "==================================================="
    }
}



# CONFIGURATION DETAIL: SET THIS FOR YOUR IMAGE VIEWER:
#  (xli, xv, ee, etc)
set HMGlobal(imageViewer) ee


# Simple HTML display library by Stephen Uhler (stephen.uhler@sun.com)
# Copyright (c) 1995 by Sun Microsystems
# Version 0.3 Fri Sep  1 10:47:17 PDT 1995
#
# Modified to support some 8.0 and 8.1 font conventions by Clif Flynt
#	(clif@cflynt.com)
#   Modifications copyright (c) 1998 by Flynt Consulting Services, 
# Version 0.3.1 Jan 10, 1999
#
#   Modifications copyright (c) 1999 by Flynt Consulting Services, 
# Added table support (another new idea).  7/31/99
#   Version 0.3.2 July, 31, 1999
#
#   Modifications copyright (c) 1999 by Flynt Consulting Services, 
# Modified table support - support for lists in tables
#                          beginning of support for nested tables.
#                          fixed italics
#   Version 0.3.3 Sep, 29, 1999
#
#   Modifications copyright (c) 2000 by Flynt Consulting Services, 
# Modified table support - improved support for nested tables.
#                          Changed default font to helvetica
#   Version 0.3.4 April 27, 2000
#
;# RCSID: $Header: /home/cvs/AuStuff/htmllib.tcl,v 1.1.1.1 2006/08/01 21:09:37 clif Exp $
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# To use this package,  create a text widget (say, .text)
# and set a variable full of html, (say $html), and issue:
#	HMinit_win .text
#	HMparse_html $html "HMrender .text"
# You also need to supply the routine:
#   proc HMlink_callback {win href} { ...}
#      win:  The name of the text widget
#      href  The name of the link
# which will be called anytime the user "clicks" on a link.
# The supplied version just prints the link to stdout.
# In addition, if you wish to use embedded images, you will need to write
#   proc HMset_image {handle src}
#      handle  an arbitrary handle (not really)
#      src     The name of the image
# Which calls
#	HMgot_image $handle $image
# with the TK image.
#
# To return a "used" text widget to its initialized state, call:
#   HMreset_win .text
# See "sample.tcl" for sample usage
##################################################################
############################################
# package require http 2

# mapping of html tags to text tag properties
# properties beginning with "T" map directly to text tags

# These are Defined in HTML 2.0

array set HMtag_map {
	large	{size 18}
	large2	{size 22}
	large3	{size 20}
	large4	{size 18}
	b      {weight bold}
	blockquote	{style italic indent 1 Trindent rindent}
	bq		{style italic indent 1 Trindent rindent}
	cite   {style italic}
	code   {family courier}
	dfn    {style italic}	
	dir    {indent 1}
	dl     {indent 1}
	em     {style italic}
	h1     {size 24 weight bold}
	h2     {size 22}		
	h3     {size 20}	
	h4     {size 18}
	h5     {size 16}
	h6     {style italic}
	i      {style italic}
	kbd    {family courier weight bold}
	menu     {indent 1}
	ol     {indent 1}
	pre    {fill 0 family courier Tnowrap nowrap}
	samp   {family courier}		
	strong {weight bold}		
	tt     {family courier}
	u	 {Tunderline underline}
	ul     {indent 1}
	var    {style italic}
}

# These are in common(?) use, but not defined in html2.0

array set HMtag_map {
	center {Tcenter center}
	strike {Tstrike strike}
	u	   {Tunderline underline}
}

# initial values

set HMtag_map(hmstart) {
	family arial   weight medium   style r   size 14
	Tcenter ""   Tlink ""   Tnowrap ""   Tunderline ""   list list
	fill 1   indent "" counter 0 adjust 0
}

# set HMtag_map(hmstart) {
# 	family helvetica weight medium   style r   size 14
# 	Tcenter ""   Tlink ""   Tnowrap ""   Tunderline ""   list list
# 	fill 1   indent "" counter 0 adjust 0
# }

# html tags that insert white space

array set HMinsert_map {
	blockquote "\n\n" /blockquote "\n"
	br	"\n"
	dd	"\n" /dd	"\n"
	dl	"\n" /dl	"\n"
	dt	"\n"
	form "\n"	/form "\n"
	h1	"\n"	/h1	"\n"
	h2	"\n"	/h2	"\n"
	h3	"\n"	/h3	"\n"
	h4	"\n"	/h4	"\n"
	h5	"\n"	/h5	"\n"
	h6	"\n"	/h6	"\n"
	li   "\n"
	/dir "\n"
	/ul ""
	/ol ""
	/menu "\n"
	p	"\n\n"
	pre "\n"	/pre "\n"
}

#	/ul "\n"

# tags that are list elements, that support "compact" rendering

array set HMlist_elements {
	ol 1   ul 1   menu 1   dl 1   dir 1
}

;# Default to no font size scaling
set HM_globals(S_adjust_size) 0

############################################
# initialize the window and stack state

proc HMinit_win {win {win2 {} } } {
	upvar #0 HM$win var
	
	HMinit_state $win

        if {[string match $win2 ""]} {
	    set win2 $win
	}
	upvar #0 HM$win2 var

	$win tag configure underline -underline 1
	$win tag configure center -justify center
	$win tag configure nowrap -wrap none
	$win tag configure rindent -rmargin $var(S_tab)c
	$win tag configure strike -overstrike 1
	$win tag configure mark -foreground red		;# list markers
	$win tag configure list -spacing1 3p -spacing3 3p		;# regular lists
	$win tag configure compact -spacing1 0p		;# compact lists
	$win tag configure link -borderwidth 2 -foreground blue	;# hypertext links


	HMset_indent $win $var(S_tab)
	$win configure -wrap word

	# configure the text insertion point
	$win mark set $var(S_insert) 1.0

        # trace variable var(style) w what 

	# for horizontal rules
	set size 1;
	while {[catch "$win tag configure thin -font [list [HMx_font arial $size medium r]]" ]} {
	  puts "Failed to open horizontal rule $size, trying larger"
	  global errorCode errorInfo
	  puts "$errorCode -- $errorInfo"
	  incr size;
	} 

	$win tag configure hr -relief sunken -borderwidth 2 -wrap none \
		-tabs [winfo width $win]
	bind $win <Configure> {
		%W tag configure hr -tabs %w
		%W tag configure last -spacing3 %h
	}

	# generic link enter callback
	$win tag bind link <1> "HMlink_hit $win %x %y $win2"
}

# set the indent spacing (in cm) for lists
# TK uses a "weird" tabbing model that causes \t to insert a single
# space if the current line position is past the tab setting

proc HMset_indent {win cm} {
	set tabs [expr $cm / 2.0]
	$win configure -tabs ${tabs}c
	foreach i {1 2 3 4 5 6 7 8 9} {
		set tab [expr $i * $cm]
		$win tag configure indent$i -lmargin1 ${tab}c -lmargin2 ${tab}c \
			-tabs "[expr $tab + $tabs]c [expr $tab + 2*$tabs]c"
	}
}

# reset the state of window - get ready for the next page
# remove all but the font tags, and remove all form state

proc HMreset_win {win} {
	upvar #0 HM$win var
	regsub -all { +[^L ][^ ]*} " [$win tag names] " {} tags
	catch "$win tag delete $tags"
	eval $win mark unset [$win mark names]
	$win delete 0.0 end
	$win tag configure hr -tabs [winfo width $win]

	# configure the text insertion point
	$win mark set $var(S_insert) 1.0

	# remove form state.  If any check/radio buttons still exists, 
	# their variables will be magically re-created, and never get
	# cleaned up.
	catch unset [info globals HM$win.form*]

	HMinit_state $win
	return HM$win
}

# initialize the window's state array
# Parameters beginning with S_ are NOT reset
#  adjust_size:		global font size adjuster
#  unknown:		character to use for unknown entities
#  tab:			tab stop (in cm)
#  stop:		enabled to stop processing
#  update:		how many tags between update calls
#  tags:		number of tags processed so far
#  symbols:		Symbols to use on un-ordered lists

proc HMinit_state {win} {
	upvar #0 HM$win var
	array set tmp [array get var S_*]
	catch {unset var}
	array set var {
		stop 0
		tags 0
		fill 0
		list list
		S_adjust_size 0
		S_tab 1.0
		S_unknown \xb7
		S_update 10
		S_symbols O*=+-o\xd7\xb0>:\xb7
		S_insert Insert
	}

	array set var [array get tmp]
}

# alter the parameters of the text state
# this allows an application to over-ride the default settings
# it is called as: HMset_state -param value -param value ...

array set HMparam_map {
	-update S_update
	-tab S_tab
	-unknown S_unknown
	-stop S_stop
	-size S_adjust_size
	-symbols S_symbols
    -insert S_insert
}

proc HMset_state {win args} {
	upvar #0 HM$win var
	global HMparam_map
	set bad 0
	if {[catch {array set params $args}]} {return 0}
	foreach i [array names params] {
		incr bad [catch {set var($HMparam_map($i)) $params($i)}]
	}
	return [expr $bad == 0]
}

proc HMinsert_FromMap { win text id } {
	global HMtag_map HMinsert_map HMlist_elements
	upvar #0 HM$win var

	# insert white space (with current font)
	# adding white space can get a bit tricky.  This isn't quite right

debug "HMinsert_FromMap WIN: $win TEXT: $text ID: $id"

	set bad [catch {$win insert $var(S_insert) $HMinsert_map($id) "space $var(font)"}]

	if {!$bad && [lindex $var(fill) end]} {
		set text [string trimleft $text]
	}
}	

############################################
# manage the display of html

# HMrender gets called for every html tag
#   win:   The name of the text widget to render into
#   tag:   The html tag (in arbitrary case)
#   not:   a "/" or the empty string
#   param: The un-interpreted parameter list
#   text:  The plain text until the next html tag

proc HMrender {win tag not param text} {
	upvar #0 HM$win var

	if {$var(stop)} return
	global HMtag_map HMinsert_map HMlist_elements
	set tag [string tolower $tag]
	set text [HMmap_esc $text]

	# Check for TD - that sets the divert.
        if {[string match $tag td] || [string match $tag table]} {
	    set fail [catch {HMtag_$not$tag $win $param text} msg]
	}

	if {[info exists var(divert)]} {
		set win $var(divert)
		upvar #0 HM$win var
	}

	# manage compact rendering of lists
	if {[info exists HMlist_elements($tag)]} {
		set list "list [expr {[HMextract_param $param compact] ? "compact" : "list"}]"
	} else {
		set list ""
	}

	# adjust (push or pop) tag state
	catch {HMstack $win $not "$HMtag_map($tag) $list"} xx
	debug "HMstack: $xx"

	HMinsert_FromMap $win $text $not$tag

	# to fill or not to fill
	if {[lindex $var(fill) end]} {
		set text [HMzap_white $text]
	}

	# generic mark hook
	catch {HMmark $not$tag $win $param text} err
	debug "HMmark: $err"

	# do any special tag processing
        if {![string match $tag td] && ![string match $tag table]} {
	 set fail [catch {HMtag_$not$tag $win $param text} msg]
	 if {$fail} {
	  global errorInfo
	  if {[string first "invalid command na" $errorInfo] < 0} {
	      puts "$errorInfo"
	      puts "FAILED: HMtag_$not$tag $win $param text "
	  }
	 }
	}

	# add the text with proper tags
	set tags [HMcurrent_tags $win]

	# Allow text to be diverted to a different window (for tables)
	# this is not currently used

	if {[info exists var(divert)]} {
		set win [lindex $var(divert) end]
		upvar #0 HM$win var
	}
debug "TEXT: $text"
debug "TAGS: $tags"
debug "TST:	$win insert $var(S_insert) $text $tags"
	$win insert $var(S_insert) $text $tags

	# We need to do an update every so often to insure interactive response.
	# This can cause us to re-enter the event loop, and cause recursive
	# invocations of HMrender, so we need to be careful.
	if {!([incr var(tags)] % $var(S_update))} {
		update
	}
}



# html tags requiring special processing
# Procs of the form HMtag_<tag> or HMtag_</tag> get called just before
# the text for this tag is displayed.  These procs are called inside a 
# "catch" so it is OK to fail.
#   win:   The name of the text widget to render into
#   param: The un-interpreted parameter list
#   text:  A pass-by-reference name of the plain text until the next html tag
#          Tag commands may change this to affect what text will be inserted
#          next.

# A pair of pseudo tags are added automatically as the 1st and last html
# tags in the document.  The default is <HMstart> and </HMstart>.
# Append enough blank space at the end of the text widget while
# rendering so HMgoto can place the target near the top of the page,
# then remove the extra space when done rendering.

proc HMtag_hmstart {win param text} {
	upvar #0 HM$win var
	$win mark gravity $var(S_insert) left
	$win insert end "\n " last
	$win mark gravity $var(S_insert) right
}

proc HMtag_/hmstart {win param text} {
	# May fail if text was diverted to another window.
	catch {$win delete last.first end}
}

# put the document title in the window banner, and remove the title text
# from the document

proc HMtag_title {win param text} {
	upvar $text data
	wm title [winfo toplevel $win] $data
	set data ""
}

proc HMtag_hr {win param text} {
	upvar #0 HM$win var
	$win insert $var(S_insert) "\n" space "\n" thin "\t" "thin hr" "\n" thin
}

# list element tags

proc HMtag_ol {win param text} {
	upvar #0 HM$win var

        if {[regexp -nocase {type="*(.)"*} $param a type]} {
	  switch $type {
	    A {
	      set lst {. A B C D E F G H I J K L M N O P Q R S T U V W X Y Z}
	      }
	    a {
	      set lst {. a b c d e f g h i j k l m n o p q r s t u v w x y z}
	      }
	    i {
	      set lst {. i ii iii iv v vi vii viii ix x xi xii xiii xiv xv xvi xvii}
	      }
	    I {
	      set lst {. I II III IV V VI VII VIII IX X XI XII XIII XIV XV XVI XVII}
	      }
	  }
	  set var(list$var(level)) $lst
	}
	set var(count$var(level)) 0
}

proc HMtag_ul {win param text} {
	upvar #0 HM$win var
	catch {unset var(count$var(level))}
}

proc HMtag_menu {win param text} {
	upvar #0 HM$win var
	set var(menu) ->
	set var(compact) 1
}

proc HMtag_/menu {win param text} {
	upvar #0 HM$win var
	catch {unset var(menu)}
	catch {unset var(compact)}
}
	
proc HMtag_dt {win param text} {
	upvar #0 HM$win var
	upvar $text data
	set level $var(level)
	incr level -1
	$win insert $var(S_insert) "$data" \
		"hi [lindex $var(list) end] indent$level $var(font)"
	set data {}
}

proc HMtag_li {win param text} {
	upvar #0 HM$win var
	set level $var(level)
	incr level -1
	set x [string index $var(S_symbols)+-+-+-+-" $level]
	catch {set x [incr var(count$level)]}
	catch {set x [lindex $var(list$level) $var(count$level)]}
	catch {set x $var(menu)}

	if {[info exists var(divert)]} {
		set win $var(divert)
		# upvar #0 HM$win var
	}
	$win insert $var(S_insert) \t$x\t "mark [lindex $var(list) end] indent$level $var(font)"
}

# Manage hypertext "anchor" links.  A link can be either a source (href)
# a destination (name) or both.  If its a source, register it via a callback,
# and set its default behavior.  If its a destination, check to see if we need
# to go there now, as a result of a previous HMgoto request.  If so, schedule
# it to happen with the closing </a> tag, so we can highlight the text up to
# the </a>.

proc HMtag_a {win param text} {
	upvar #0 HM$win var

	# a source

	if {[HMextract_param $param href]} {
		set var(Tref) [list L:$href]
		HMstack $win "" "Tlink link"
		HMlink_setup $win $href
	}

	# a destination

	if {[HMextract_param $param name]} {
		set var(Tname) [list N:$name]
		HMstack $win "" "Tanchor anchor"
		$win mark set N:$name "$var(S_insert) - 1 chars"
		$win mark gravity N:$name left
		if {[info exists var(goto)] && $var(goto) == $name} {
			unset var(goto)
			set var(going) $name
		}
	}
}

# The application should call here with the fragment name
# to cause the display to go to this spot.
# If the target exists, go there (and do the callback),
# otherwise schedule the goto to happen when we see the reference.

proc HMgoto {win where {callback HMwent_to}} {
	upvar #0 HM$win var
	if {[regexp N:$where [$win mark names]]} {
		$win see N:$where
		update
		eval $callback $win [list $where]
		return 1
	} else {
		set var(goto) $where
		return 0
	}
}

# We actually got to the spot, so highlight it!
# This should/could be replaced by the application
# We'll flash it orange a couple of times.

proc HMwent_to {win where {count 0} {color orange}} {
	upvar #0 HM$win var
	if {$count > 5} return
	catch {$win tag configure N:$where -foreground $color}
	update
	after 200 [list HMwent_to $win $where [incr count] \
				[expr {$color=="orange" ? "" : "orange"}]]
}

proc HMtag_/a {win param text} {
	upvar #0 HM$win var
	if {[info exists var(Tref)]} {
		unset var(Tref)
		HMstack $win / "Tlink link"
	}

	# goto this link, then invoke the call-back.

	if {[info exists var(going)]} {
		$win yview N:$var(going)
		update
		HMwent_to $win $var(going)
		unset var(going)
	}

	if {[info exists var(Tname)]} {
		unset var(Tname)
		HMstack $win / "Tanchor anchor"
	}
}

#           Inline Images
# This interface is subject to change
# Most of the work is getting around a limitation of TK that prevents
# setting the size of a label to a widthxheight in pixels
#
# Images have the following parameters:
#    align:  top,middle,bottom
#    alt:    alternate text
#    ismap:  A clickable image map
#    src:    The URL link
# Netscape supports (and so do we)
#    width:  A width hint (in pixels)
#    height:  A height hint (in pixels)
#    border: The size of the window border

proc HMtag_img {win param text} {
	upvar #0 HM$win var

	# get alignment
	array set align_map {top top    middle center    bottom bottom}
	set align bottom		;# The spec isn't clear what the default should be
	HMextract_param $param align
	catch {set align $align_map([string tolower $align])}

	# get alternate text
	set alt "<image>"
	HMextract_param $param alt
	set alt [HMmap_esc $alt]

	set speed 0
	HMextract_param $param speed

	# get the border width
	set border 1
	HMextract_param $param border

	# see if we have an image size hint
	# If so, make a frame the "hint" size to put the label in
	# otherwise just make the label

	if {[info exists var(divert)]} {
		set win $var(divert)
		upvar #0 HM$win var
	}

	set item $win.$var(tags)
	# catch {destroy $item}
	if {[HMextract_param $param width] && [HMextract_param $param height]} {
		frame $item -width $width -height $height
		pack propagate $item 0
		set label $item.label
		label $label
		pack $label -expand 1 -fill both
	} else {
		set label $item
		label $label 
	}

	$label configure -relief ridge -fg orange -text $alt
	catch {$label configure -bd $border}
	$win window create $var(S_insert) -align $align -window $item -pady 2 -padx 2

	# add in all the current tags (this is overkill)
	set tags [HMcurrent_tags $win]
	foreach tag $tags {
		$win tag add $tag $item
	}

	# set imagemap callbacks
	if {[HMextract_param $param ismap]} {
		# regsub -all {[^L]*L:([^ ]*).*}  $tags {\1} link
		set link [lindex $tags [lsearch -glob $tags L:*]]
		regsub L: $link {} link
		global HMevents
		regsub -all {%} $link {%%} link2
		foreach i [array names HMevents] {
			bind $label <$i> "catch \{%W configure $HMevents($i)\}"
		}
		bind $label <1> "+HMlink_callback $win $link2?%x,%y"
	} 

	# now callback to the application
	set src ""
	HMextract_param $param src

	HMset_image $win $label $src $speed

	return $label	;# used by the forms package for input_image types
}

# The app needs to supply one of these
# proc HMset_image {win handle src} {
#	HMgot_image $handle "can't get\n$src"
# }

# When the image is available, the application should call back here.
# If we have the image, put it in the label, otherwise display the error
# message.  If we don't get a callback, the "alt" text remains.
# if we have a clickable image, arrange for a callback

proc HMgot_image {win image_error} {
	# if we're in a frame turn on geometry propogation
	if {[winfo name $win] == "label"} {
		pack propagate [winfo parent $win] 1
	}
	if {[catch {$win configure -image $image_error}]} {
		$win configure -image {}
		$win configure -text $image_error
	}
}

# Sample hypertext link callback routine - should be replaced by app
# This proc is called once for each <A> tag.
# Applications can overwrite this procedure, as required, or
# replace the HMevents array
#   win:   The name of the text widget to render into
#   href:  The HREF link for this <a> tag.

array set HMevents {
	Enter	{-borderwidth 2 -relief raised }
	Leave	{-borderwidth 2 -relief flat }
	1		{-borderwidth 2 -relief sunken}
	ButtonRelease-1	{-borderwidth 2 -relief raised}
}

# We need to escape any %'s in the href tag name so the bind command
# doesn't try to substitute them.

proc HMlink_setup {win href} {
	global HMevents
	regsub -all {%} $href {%%} href2
	foreach i [array names HMevents] {
		eval {$win tag bind  L:$href <$i>} \
			\{$win tag configure \{L:$href2\} $HMevents($i)\}
	}
}

# generic link-hit callback
# This gets called upon button hits on hypertext links
# Applications are expected to supply ther own HMlink_callback routine
#   win:   The name of the text widget to render into
#   x,y:   The cursor position at the "click"

proc HMlink_hit {win x y win2} {
	set tags [$win tag names @$x,$y]
	set link [lindex $tags [lsearch -glob $tags L:*]]
	# regsub -all {[^L]*L:([^ ]*).*}  $tags {\1} link
	regsub L: $link {} link
	HMlink_callback $win2 $link
}

# replace this!
#   win:   The name of the text widget to render into
#   href:  The HREF link for this <a> tag.

proc HMlink_callback {win href} {
	puts "Got hit on $win, link $href"
}

# extract a value from parameter list (this needs a re-do)
# returns "1" if the keyword is found, "0" otherwise
#   param:  A parameter list.  It should alredy have been processed to
#           remove any entity references
#   key:    The parameter name
#   val:    The variable to put the value into (use key as default)

proc HMextract_param {param key {val ""}} {

	if {$val == ""} {
		upvar $key result
	} else {
		upvar $val result
	}
    set ws "    \n\r"
 
    # look for name=value combinations.  Either (') or (") are valid delimeters
    if {
      [regsub -nocase [format {.*%s[%s]*=[%s]*"([^"]*).*} $key $ws $ws] $param {\1} value] ||
      [regsub -nocase [format {.*%s[%s]*=[%s]*'([^']*).*} $key $ws $ws] $param {\1} value] ||
      [regsub -nocase [format {.*%s[%s]*=[%s]*([^%s]+).*} $key $ws $ws $ws] $param {\1} value] } {
        set result $value
        return 1
    }

	# now look for valueless names
	# I should strip out name=value pairs, so we don't end up with "name"
	# inside the "value" part of some other key word - some day
	
	set bad \[^a-zA-Z\]+
	if {[regexp -nocase  "$bad$key$bad" -$param-]} {
		return 1
	} else {
		return 0
	}
}

# These next two routines manage the display state of the page.

# Push or pop tags to/from stack.
# Each orthogonal text property has its own stack, stored as a list.
# The current (most recent) tag is the last item on the list.
# Push is {} for pushing and {/} for popping

proc HMstack {win push list} {
	upvar #0 HM$win var
	array set tags $list
	if {$push == ""} {
		foreach tag [array names tags] {
			lappend var($tag) $tags($tag)
		}
	} else {
		foreach tag [array names tags] {
			# set cnt [regsub { *[^ ]+$} $var($tag) {} var($tag)]
			set var($tag) [lreplace $var($tag) end end]
		}
	}
}

# extract set of current text tags
# tags starting with T map directly to text tags, all others are
# handled specially.  There is an application callback, HMset_font
# to allow the application to do font error handling

proc HMcurrent_tags {win} {
	upvar #0 HM$win var
	set font font
	foreach i {family size weight style} {
		set $i [lindex $var($i) end]
		append font :[set $i]
	}

debug "HMcurrent style: $win :: $var(style) :: $style"
debug "HMcurrent_tags: $win \n[array get var]\n"

	set xfont [HMx_font $family $size $weight $style $var(S_adjust_size)]
	HMset_font $win $font $xfont
	set indent [llength $var(indent)]
	incr indent -1
	lappend tags $font indent$indent
	foreach tag [array names var T*] {
		lappend tags [lindex $var($tag) end]	;# test
	}
	set var(font) $font
#	set var(xfont) [$win tag cget $font -font]
debug "$win tag cget $font -font :: [$win tag cget $font -font] :: $xfont"
	set var(level) $indent
	return $tags
}

# allow the application to do do better font management
# by overriding this procedure

proc HMset_font {win tag font} {
	set fail [catch {$win tag configure $tag -font $font} msg]
	if {$fail} {
	    global errorCode errorInfo
	    puts "setFontFail: FONT: $font TAG: $tag\n$errorCode: $errorInfo"
            set lvl [info level]
            incr lvl -1;
            puts "called from: '[info level $lvl]'"
	}
}

# Set a global to adjust the size of all text displayed.
#  This may be a positive or negative value.
#  It allows all the text on a set of HTML windows to be scaled.

proc HM_setFontAdjust {newAdjustSize} {
	global HM_globals
	set HM_globals(S_adjust_size) $newAdjustSize
}

# generate an X font name
proc HMx_font {family size weight {style {}} {adjust_size 0}} {
	global tcl_version HM_globals
debug "FROM: [info level -1]"

#   puts "FAMILY: $family - $size .. $weight .. $style .. $adjust_size"
#        if {[string match $family ""]} {set family helvetica}
        if {[string match $family ""]} {set family arial}

	set size [expr $size + $HM_globals(S_adjust_size)]
	set size [expr $size + $adjust_size]

	if {[string match courier [string tolower $family]]} {
	    debug -nonewline "COURIER: START: $size"
	    incr size 1;
	    debug "COURIER: END: $size"
	}
        
	if {$tcl_version < 8.0} {
            return "-*-$family-$weight-$style-normal-*-*-${size}0-*-*-*-*-*-*"
	} else {
    	    if {[string match $weight "medium"]} {
	        set weight "normal"
    	    }
    	    if {[string match $style "r"]} {
	        set style "roman"
    	    }
	    return "$family $size $weight $style"
    	}
}

# Optimize HMrender (hee hee)
# This is experimental

proc HMoptimize {} {
	regsub -all "\n\[ 	\]*#\[^\n\]*" [info body HMrender] {} body
	regsub -all ";\[ 	\]*#\[^\n]*" $body {} body
	regsub -all "\n\n+" $body \n body
	proc HMrender {win tag not param text} $body
}
############################################
# Turn HTML into TCL commands
#   html    A string containing an html document
#   cmd		A command to run for each html tag found
#   start	The name of the dummy html start/stop tags

proc HMparse_html {html {cmd HMtest_parse} {start hmstart}} {
	regsub -all \{ $html {\&ob;} html
	regsub -all \} $html {\&cb;} html
	regsub -all {\\} $html {\&#92;} html
	set w " \t\r\n"	;# white space
	proc HMcl x {return "\[$x\]"}
	set exp <(/?)([HMcl ^$w>]+)[HMcl $w]*([HMcl ^>]*)>
	set sub "\}\n$cmd {\\2} {\\1} {\\3} \{"
	regsub -all $exp $html $sub html
 	eval "$cmd {$start} {} {} \{ $html \}"
	eval "$cmd {$start} / {} {}"
}

proc HMtest_parse {command tag slash text_after_tag} {
	puts "==> $command $tag $slash $text_after_tag"
}

# Convert multiple white space into a single space

proc HMzap_white {data} {
	regsub -all "\[ \t\r\n\]+" $data " " data
	return $data
}

# find HTML escape characters of the form &xxx;

proc HMmap_esc {text} {
	if {![regexp & $text]} {return $text}
	regsub -all {([][$\\])} $text {\\\1} new
	regsub -all {&#([0-9][0-9]?[0-9]?);?} \
		$new {[format %c [scan \1 %d tmp;set tmp]]} new
	regsub -all {&([a-zA-Z]+);?} $new {[HMdo_map \1]} new
	return [subst $new]
}

# convert an HTML escape sequence into character

proc HMdo_map {text {unknown ?}} {
	global HMesc_map
	set result $unknown
	catch {set result $HMesc_map($text)}
	return $result
}

# table of escape characters (ISO latin-1 esc's are in a different table)

array set HMesc_map {
   lt <   gt >   amp &   quot \"   copy \xa9
   reg \xae   ob \x7b   cb \x7d   nbsp \xa0
}
#############################################################
# ISO Latin-1 escape codes

array set HMesc_map {
	#92 \x5c
	nbsp \xa0 iexcl \xa1 cent \xa2 pound \xa3 curren \xa4
	yen \xa5 brvbar \xa6 sect \xa7 uml \xa8 copy \xa9
	ordf \xaa laquo \xab not \xac shy \xad reg \xae
	hibar \xaf deg \xb0 plusmn \xb1 sup2 \xb2 sup3 \xb3
	acute \xb4 micro \xb5 para \xb6 middot \xb7 cedil \xb8
	sup1 \xb9 ordm \xba raquo \xbb frac14 \xbc frac12 \xbd
	frac34 \xbe iquest \xbf Agrave \xc0 Aacute \xc1 Acirc \xc2
	Atilde \xc3 Auml \xc4 Aring \xc5 AElig \xc6 Ccedil \xc7
	Egrave \xc8 Eacute \xc9 Ecirc \xca Euml \xcb Igrave \xcc
	Iacute \xcd Icirc \xce Iuml \xcf ETH \xd0 Ntilde \xd1
	Ograve \xd2 Oacute \xd3 Ocirc \xd4 Otilde \xd5 Ouml \xd6
	times \xd7 Oslash \xd8 Ugrave \xd9 Uacute \xda Ucirc \xdb
	Uuml \xdc Yacute \xdd THORN \xde szlig \xdf agrave \xe0
	aacute \xe1 acirc \xe2 atilde \xe3 auml \xe4 aring \xe5
	aelig \xe6 ccedil \xe7 egrave \xe8 eacute \xe9 ecirc \xea
	euml \xeb igrave \xec iacute \xed icirc \xee iuml \xef
	eth \xf0 ntilde \xf1 ograve \xf2 oacute \xf3 ocirc \xf4
	otilde \xf5 ouml \xf6 divide \xf7 oslash \xf8 ugrave \xf9
	uacute \xfa ucirc \xfb uuml \xfc yacute \xfd thorn \xfe
	yuml \xff
}

##########################################################
# html forms management commands

# As each form element is located, it is created and rendered.  Additional
# state is stored in a form specific global variable to be processed at
# the end of the form, including the "reset" and "submit" options.
# Remember, there can be multiple forms existing on multiple pages.  When
# HTML tables are added, a single form could be spread out over multiple
# text widgets, which makes it impractical to hang the form state off the
# HM$win structure.  We don't need to check for the existance of required
# parameters, we just "fail" and get caught in HMrender

# This causes line breaks to be preserved in the inital values
# of text areas
array set HMtag_map {
	textarea    {fill 0}
}

##########################################################
# html isindex tag.  Although not strictly forms, they're close enough
# to be in this file

# is-index forms
# make a frame with a label, entry, and submit button

proc HMtag_isindex {win param text} {
	upvar #0 HM$win var

	set item $win.$var(tags)
	if {[winfo exists $item]} {
		destroy $item
	}
	frame $item -relief ridge -bd 3
	set prompt "Enter search keywords here"
	HMextract_param $param prompt
	label $item.label -text [HMmap_esc $prompt] -font $var(xfont)
	entry $item.entry
	bind $item.entry <Return> "$item.submit invoke"
	button $item.submit -text search -font $var(xfont) -command \
		[format {HMsubmit_index %s {%s} [HMmap_reply [%s get]]} \
		$win $param $item.entry]
	pack $item.label -side top
	pack $item.entry $item.submit -side left

	# insert window into text widget

	$win insert $var(S_insert) \n isindex
	HMwin_install $win $item
	$win insert $var(S_insert) \n isindex
	bind $item <Visibility> {focus %W.entry}
}

# This is called when the isindex form is submitted.
# The default version calls HMlink_callback.  Isindex tags should either
# be deprecated, or fully supported (e.g. they need an href parameter)

proc HMsubmit_index {win param text} {
	HMlink_callback $win ?$text
}

# initialize form state.  All of the state for this form is kept
# in a global array whose name is stored in the form_id field of
# the main window array.
# Parameters: ACTION, METHOD, ENCTYPE

proc HMtag_form {win param text} {
	upvar #0 HM$win var

	# create a global array for the form
	set id HM$win.form$var(tags)
	upvar #0 $id form

	# missing /form tag, simulate it
	if {[info exists var(form_id)]} {
		puts "Missing end-form tag !!!! $var(form_id)"
		HMtag_/form $win {} {}
	}
	catch {unset form}
	set var(form_id) $id

	set form(param) $param		;# form initial parameter list
	set form(reset) ""			;# command to reset the form
	set form(reset_button) ""	;# list of all reset buttons
	set form(submit) ""			;# command to submit the form
	set form(submit_button) ""	;# list of all submit buttons
}

# Where we're done try to get all of the state into the widgets so
# we can free up the form structure here.  Unfortunately, we can't!

proc HMtag_/form {win param text} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form

	# make submit button entries for all radio buttons
	foreach name [array names form radio_*] {
		regsub radio_ $name {} name
		lappend form(submit) [list $name \$form(radio_$name)]
	}

	# process the reset button(s)

	foreach item $form(reset_button) {
		$item configure -command $form(reset)
	}

	# no submit button - add one
	if {$form(submit_button) == ""} {
		HMinput_submit $win {}
	}

	# process the "submit" command(s)
	# each submit button could have its own name,value pair

	foreach item $form(submit_button) {
		set submit $form(submit)
		catch {lappend submit $form(submit_$item)}
		$item configure -command  \
				[list HMsubmit_button $win $var(form_id) $form(param) \
				$submit]
	}

	# unset all unused fields here
	unset form(reset) form(submit) form(reset_button) form(submit_button)
	unset var(form_id)
}

###################################################################
# handle form input items
# each item type is handled in a separate procedure
# Each "type" procedure needs to:
# - create the window
# - initialize it
# - add the "submit" and "reset" commands onto the proper Q's
#   "submit" is subst'd
#   "reset" is eval'd

proc HMtag_input {win param text} {
	upvar #0 HM$win var

	set type text	;# the default
	HMextract_param $param type
	set type [string tolower $type]
	if {[catch {HMinput_$type $win $param} err]} {
		puts stderr $err
	}
}

# input type=text
# parameters NAME (reqd), MAXLENGTH, SIZE, VALUE

proc HMinput_text {win param {show {}}} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form

	# make the entry
	HMextract_param $param name		;# required
	set item $win.input_text,$var(tags)
	set size 20; HMextract_param $param size
	set maxlength 0; HMextract_param $param maxlength
	entry $item -width $size -show $show

	# set the initial value
	set value ""; HMextract_param $param value
	$item insert 0 $value
		
	# insert the entry
	HMwin_install $win $item

	# set the "reset" and "submit" commands
	append form(reset) ";$item delete 0 end;$item insert 0 [list $value]"
	lappend form(submit) [list $name "\[$item get]"]

	# handle the maximum length (broken - no way to cleanup bindtags state)
	if {$maxlength} {
		bindtags $item "[bindtags $item] max$maxlength"
		bind max$maxlength <KeyPress> "%W delete $maxlength end"
	}
}

# password fields - same as text, only don't show data
# parameters NAME (reqd), MAXLENGTH, SIZE, VALUE

proc HMinput_password {win param} {
	HMinput_text $win $param *
}

# checkbuttons are missing a "get" option, so we must use a global
# variable to store the value.
# Parameters NAME, VALUE, (reqd), CHECKED

proc HMinput_checkbox {win param} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form

	HMextract_param $param name
	HMextract_param $param value

	# Set the global variable, don't use the "form" alias as it is not
	# defined in the global scope of the button
	set variable $var(form_id)(check_$var(tags))	
	set item $win.input_checkbutton,$var(tags)
	checkbutton $item -variable $variable -off {} -on $value -text "  "
	if {[HMextract_param $param checked]} {
		$item select
		append form(reset) ";$item select"
	} else {
		append form(reset) ";$item deselect"
	}

	HMwin_install $win $item
	lappend form(submit) [list $name \$form(check_$var(tags))]
}

# radio buttons.  These are like check buttons, but only one can be selected

proc HMinput_radio {win param} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form

	HMextract_param $param name
	HMextract_param $param value

	set first [expr ![info exists form(radio_$name)]]
	set variable $var(form_id)(radio_$name)
	set variable $var(form_id)(radio_$name)
	set item $win.input_radiobutton,$var(tags)
	radiobutton $item -variable $variable -value $value -text " "

	HMwin_install $win $item

	if {$first || [HMextract_param $param checked]} {
		$item select
		append form(reset) ";$item select"
	} else {
		append form(reset) ";$item deselect"
	}

	# do the "submit" actions in /form so we only end up with 1 per button grouping
	# contributing to the submission
}

# hidden fields, just append to the "submit" data
# params: NAME, VALUE (reqd)

proc HMinput_hidden {win param} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form
	HMextract_param $param name
	HMextract_param $param value
	lappend form(submit) [list $name $value]
}

# handle input images.  The spec isn't very clear on these, so I'm not
# sure its quite right
# Use std image tag, only set up our own callbacks
#  (e.g. make sure ismap isn't set)
# params: NAME, SRC (reqd) ALIGN

proc HMinput_image {win param} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form
	HMextract_param $param name
	set name		;# barf if no name is specified
	set item [HMtag_img $win $param {}]
	$item configure -relief raised -bd 2 -bg blue

	# make a dummy "submit" button, and invoke it to send the form.
	# We have to get the %x,%y in the value somehow, so calculate it during
	# binding, and save it in the form array for later processing

	set submit $win.dummy_submit,$var(tags)
	if {[winfo exists $submit]} {
		destroy $submit
	}
	button $submit	-takefocus 0;# this never gets mapped!
	lappend form(submit_button) $submit
	set form(submit_$submit) [list $name $name.\$form(X).\$form(Y)]
	
	$item configure -takefocus 1
	bind $item <FocusIn> "catch \{$win see $item\}"
	bind $item <1> "$item configure -relief sunken"
	bind $item <Return> "
		set $var(form_id)(X) 0
		set $var(form_id)(Y) 0
		$submit invoke	
	"
	bind $item <ButtonRelease-1> "
		set $var(form_id)(X) %x
		set $var(form_id)(Y) %y
		$item configure -relief raised
		$submit invoke	
	"
}

# Set up the reset button.  Wait for the /form to attach
# the -command option.  There could be more that 1 reset button
# params VALUE

proc HMinput_reset {win param} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form

	set value reset
	HMextract_param $param value

	set item $win.input_reset,$var(tags)
	button $item -text [HMmap_esc $value]
	HMwin_install $win $item
	lappend form(reset_button) $item
}

# Set up the submit button.  Wait for the /form to attach
# the -command option.  There could be more that 1 submit button
# params: NAME, VALUE

proc HMinput_submit {win param} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form

	HMextract_param $param name
	set value submit
	HMextract_param $param value
	set item $win.input_submit,$var(tags)
	button $item -text [HMmap_esc $value] -fg blue
	HMwin_install $win $item
	lappend form(submit_button) $item
	# need to tie the "name=value" to this button
	# save the pair and do it when we finish the submit button
	catch {set form(submit_$item) [list $name $value]}
}

#########################################################################
# selection items
# They all go into a list box.  We don't what to do with the listbox until
# we know how many items end up in it.  Gather up the data for the "options"
# and finish up in the /select tag
# params: NAME (reqd), MULTIPLE, SIZE 

proc HMtag_select {win param text} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form

	HMextract_param $param name
	set size 5;  HMextract_param $param size
	set form(select_size) $size
	set form(select_name) $name
	set form(select_values) ""		;# list of values to submit
	if {[HMextract_param $param multiple]} {
		set mode multiple
	} else {
		set mode single
	}
	set item $win.select,$var(tags)
    frame $item
    set form(select_frame) $item
	listbox $item.list -selectmode $mode -width 0 -exportselection 0
	HMwin_install $win $item
}

# select options
# The values returned in the query may be different from those
# displayed in the listbox, so we need to keep a separate list of
# query values.
#  form(select_default) - contains the default query value
#  form(select_frame) - name of the listbox's containing frame
#  form(select_values)  - list of query values
# params: VALUE, SELECTED

proc HMtag_option {win param text} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form
	upvar $text data
	set frame $form(select_frame)

	# set default option (or options)
	if {[HMextract_param $param selected]} {
        lappend form(select_default) [$form(select_frame).list size]
    }
    set value [string trimright $data " \n"]
    $frame.list insert end $value
	HMextract_param $param value
	lappend form(select_values) $value
	set data ""
}
 
# do most of the work here!
# if SIZE>1, make the listbox.  Otherwise make a "drop-down"
# listbox with a label in it
# If the # of items > size, add a scroll bar
# This should probably be broken up into callbacks to make it
# easier to override the "look".

proc HMtag_/select {win param text} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form
	set frame $form(select_frame)
	set size $form(select_size)
	set items [$frame.list size]

	# set the defaults and reset button
	append form(reset) ";$frame.list selection clear 0  $items"
	if {[info exists form(select_default)]} {
		foreach i $form(select_default) {
			$frame.list selection set $i
			append form(reset) ";$frame.list selection set $i"
		}
	} else {
		$frame.list selection set 0
		append form(reset) ";$frame.list selection set 0"
	}

	# set up the submit button. This is the general case.  For single
	# selections we could be smarter

	for {set i 0} {$i < $size} {incr i} {
		set value [format {[expr {[%s selection includes %s] ? {%s} : {}}]} \
				$frame.list $i [lindex $form(select_values) $i]]
		lappend form(submit) [list $form(select_name) $value]
	}
	
	# show the listbox - no scroll bar

	if {$size > 1 && $items <= $size} {
		$frame.list configure -height $items
		pack $frame.list

	# Listbox with scrollbar

	} elseif {$size > 1} {
		scrollbar $frame.scroll -command "$frame.list yview"  \
				-orient v -takefocus 0
		$frame.list configure -height $size \
			-yscrollcommand "$frame.scroll set"
		pack $frame.list $frame.scroll -side right -fill y

	# This is a joke!

	} else {
		scrollbar $frame.scroll -command "$frame.list yview"  \
			-orient h -takefocus 0
		$frame.list configure -height 1 \
			-yscrollcommand "$frame.scroll set"
		pack $frame.list $frame.scroll -side top -fill x
	}

	# cleanup

	foreach i [array names form select_*] {
		unset form($i)
	}
}

# do a text area (multi-line text)
# params: COLS, NAME, ROWS (all reqd, but default rows and cols anyway)

proc HMtag_textarea {win param text} {
	upvar #0 HM$win var
	upvar #0 $var(form_id) form
	upvar $text data

	set rows 5; HMextract_param $param rows
	set cols 30; HMextract_param $param cols
	HMextract_param $param name
	set item $win.textarea,$var(tags)
	frame $item
	text $item.text -width $cols -height $rows -wrap none \
			-yscrollcommand "$item.scroll set" -padx 3 -pady 3
	scrollbar $item.scroll -command "$item.text yview"  -orient v
	$item.text insert 1.0 $data
	HMwin_install $win $item
	pack $item.text $item.scroll -side right -fill y
	lappend form(submit) [list $name "\[$item.text get 0.0 end]"]
	append form(reset) ";$item.text delete 1.0 end; \
			$item.text insert 1.0 [list $data]"
	set data ""
}

# procedure to install windows into the text widget
# - win:  name of the text widget
# - item: name of widget to install

proc HMwin_install {win item} {
	upvar #0 HM$win var
	$win window create $var(S_insert) -window $item -align bottom
	$win tag add indent$var(level) $item
	set focus [expr {[winfo class $item] != "Frame"}]
	$item configure -takefocus $focus
	bind $item <FocusIn> "$win see $item"
}

#####################################################################
# Assemble and submit the query
# each list element in "stuff" is a name/value pair
# - The names are the NAME parameters of the various fields
# - The values get run through "subst" to extract the values
# - We do the user callback with the list of name value pairs

proc HMsubmit_button {win form_id param stuff} {
	upvar #0 HM$win var
	upvar #0 $form_id form
	set query ""
	foreach pair $stuff {
		set value [subst [lindex $pair 1]]
		if {$value != ""} {
			set item [lindex $pair 0]
			lappend query $item $value
		}
	}
	# this is the user callback.
	HMsubmit_form $win $param $query
}

# sample user callback for form submission
# should be replaced by the application
# Sample version generates a string suitable for http

proc HMsubmit_form {win param query} {
	set result ""
	set sep ""
	foreach i $query {
		append result  $sep [HMmap_reply $i]
		if {$sep != "="} {set sep =} {set sep &}
	}
	puts $result
}

# do x-www-urlencoded character mapping
# The spec says: "non-alphanumeric characters are replaced by '%HH'"
 
set HMalphanumeric	a-zA-Z0-9	;# definition of alphanumeric character class
for {set i 1} {$i <= 256} {incr i} {
    set c [format %c $i]
    if {![string match \[$HMalphanumeric\] $c]} {
        set HMform_map($c) %[format %.2x $i]
    }
}

# These are handled specially
array set HMform_map {
    " " +   \n %0d%0a
}

# 1 leave alphanumerics characters alone
# 2 Convert every other character to an array lookup
# 3 Escape constructs that are "special" to the tcl parser
# 4 "subst" the result, doing all the array substitutions
 
proc HMmap_reply {string} {
    global HMform_map HMalphanumeric
    regsub -all \[^$HMalphanumeric\] $string {$HMform_map(&)} string
    regsub -all \n $string {\\n} string
    regsub -all \t $string {\\t} string
    regsub -all {[][{})\\]\)} $string {\\&} string
    return [subst $string]
}

# convert a x-www-urlencoded string int a a list of name/value pairs

# 1  convert a=b&c=d... to {a} {b} {c} {d}...
# 2, convert + to  " "
# 3, convert %xx to char equiv

proc HMcgiDecode {data} {
	set data [split $data "&="]
	foreach i $data {
		lappend result [cgiMap $i]
	}
	return $result
}

proc HMcgiMap {data} {
	regsub -all {\+} $data " " data
	
	if {[regexp % $data]} {
		regsub -all {([][$\\])} $data {\\\1} data
		regsub -all {%([0-9a-fA-F][0-9a-fA-F])} $data  {[format %c 0x\1]} data
		return [subst $data]
	} else {
		return $data
	}
}

# There is a bug in the tcl library focus routines that prevents focus
# from every reaching an un-viewable window.  Use our *own*
# version of the library routine, until the bug is fixed, make sure we
# over-ride the library version, and not the otherway around

auto_load tkFocusOK
proc tkFocusOK w {
    set code [catch {$w cget -takefocus} value]
    if {($code == 0) && ($value != "")} {
    if {$value == 0} {
        return 0
    } elseif {$value == 1} {
        return 1
    } else {
        set value [uplevel #0 $value $w]
        if {$value != ""} {
        return $value
        }
    }
    }
    set code [catch {$w cget -state} value]
    if {($code == 0) && ($value == "disabled")} {
    return 0
    }
    regexp Key|Focus "[bind $w] [bind [winfo class $w]]"
}

set HMtable(unique) 0

set rev(htmllib.tcl) { RCSID: $Header: /home/cvs/AuStuff/htmllib.tcl,v 1.1.1.1 2006/08/01 21:09:37 clif Exp $}

################################################################
# proc HMtag_table {win param text}--
#    Process the &lt;TABLE&gt; tag - Called from html_library
#    Creates a new frame widget to hold the table rows
#    Creates HM.WindowName state variables with default values
#
# Arguments
#   win		The window that will hold everything
#   param	Any parameters in the <TABLE ...> tag
#   text	The name of a variable with associated text
# Results
#   
# 
proc HMtag_table {win param text} {
    global HMtable

    upvar #0 HM$win var
    debug "HMtag_table : WIN: $win PARAM: $param TEXT: $text "

    # Define a unique name for the text widget 
    #   that will contain this table
    
    if {[info exists var(divert)]} {
        set w $var(divert)
    } else {
        set w $win
    }
    
    set newTable $w.tbl_$HMtable(unique)
    lappend HMtable(Frame) $newTable
    set HMtable(Background)  yellow
    set fail [catch {$win cget -background} HMtable(Background) ]
debug "WIN: BACK: $HMtable(Background) -- $fail"

    frame $newTable -background $HMtable(Background)
    incr HMtable(unique)

    upvar #0 HM$newTable newvar
debug "TABLE: WIN: $win - newTable $newTable r"

    # and initialize it

    HMinit_state $newTable

    # trace variable newvar(style) w what 

    set newvar(S_insert) end
    set newvar(oldWindow) $win

    lappend HMtable(row) 0
    lappend HMtable(column) 0
    if {![string match $param ""]} {
      foreach p $param {
        regsub -all {"} $p {} p
        foreach {key val} [split $p =] {
	    if {![string match $val ""]} {
	        set newvar(CFG_[string tolower $key]) $val
debug "ADDING $key CONFIG to HM$newTable"
	    }
	}
      }
    }    
#    puts "NEW TABLE $newTable"
}



################################################################
# proc HMtag_/table {win param text}--
#    Process the </TABLE> tag
#    This procedure resets the window to receive text to the master
#    window.
# Arguments
#   
#   table	The window that holds the table
#   param	Any parameters in the </TABLE ...> tag
#   text	The name of a variable with associated text
# 
# Results
#   Maps the new window into the master text window.
#   Sets tab locations in new window
#

proc HMtag_/table {win param text} {

    global HMtable errorInfo
    upvar #0 HM$win var

    set parentFrame [lindex $HMtable(Frame) end]
    puts "HMtag_/table: $win :: $param :: $text  ::PARENTFRAME: $parentFrame"
    
    # unset var(divert) so that text will no longer be diverted to 
    #  the table window
    
    if {[info exists var(divert)]} {
        unset var(divert)
    }

    update idle;

    foreach p [list row column Frame ] {
        set HMtable($p) [lreplace $HMtable($p) end end]
    }
    
    if {[llength $HMtable(row)] == 0} {
        TABLEsetWindowWidths $win $parentFrame
#        TABLEsetWindowWidths $win [lindex $HMtable(Frame) 0]
    }

    #
    # Reconfigure child windows 
    # Necessary for nested tables
    #
    foreach child [winfo children $parentFrame] {
      foreach ch [winfo children $child ] {
	    TABLEsetWindowWidths $win $ch
      }
    }
} 

proc modTxtHt {txtWin a b} {
    global TABLE_oldB

puts " txtWin: $txtWin A: $a B: $b"
    if {![info exist TABLE_oldB($txtWin)]} {
        set TABLE_oldB($txtWin) 0
	}
    if {($b == $TABLE_oldB($txtWin)) || ($b == 1)} {return}
    set TABLE_oldB($txtWin) $b
    set currHt [$txtWin cget -height] 
    set newHt [expr ceil($currHt / $b)]
puts "INCR $txtWin $currHt -> $newHt -- $b"

#    if {$newHt == $currHt} {
#        incr newHt
#    }
    $txtWin configure -height $newHt

#  Does not cause modTxtHt to be invoked.
#     set gpWin [winfo parent [winfo parent $txtWin]]
#     if {[string length $gpWin] > 2} {
#puts "INCR GPW: $gpWin"
#        update idle;
#        $gpWin yview moveto .99
#        update idle;
#        $gpWin yview moveto .0
#        update idle;
#     }
# Goes too far
#

     set gpWin [winfo parent [winfo parent $txtWin]]
     if {[string length $gpWin] > 2} {
#puts "INCR GPW: $gpWin"
        $gpWin insert 0.0 " "
        update 
        $gpWin delete 0.0
        update 
     }


}

proc TABLEsetWindowWidths {win parentFrame}  {
    global HMtable errorInfo

     puts "TABLEsetWindowWidths: $win $parentFrame"
    set parentWin [string range $parentFrame 0 [expr [string last "." $parentFrame] -1]]

    # Set the var pointer for the table text widget
#    upvar #0 HM$parentWin var
    upvar #0 HM$win var
    

    update idle;

    set HMtable(hasFixed) 1.0
    
    catch {lindex [grid size $parentFrame] 0} columns

    # find the max requested size for each column

    $parentWin window create $var(S_insert) -window $parentFrame
update idle;
 update;
if {$columns <= 0} {return}

    for {set c 0} {$c < $columns} {incr c} {
        set txtwinLst($c) [grid slaves $parentFrame -column $c]
	set txtSize($c) -1
	set pixReq($c) -1
	set firstSpace($c) -1


        # Make each window extremely wide - this should make the lines
	#  one-per-line with no wrap to find the initial 
	#  max requested width for each window

	foreach txtwin $txtwinLst($c) {
	    $txtwin configure -width 990
	}
	    
        update idle;

	foreach txtwin $txtwinLst($c) {

	  # Returns the size of the text window as created, not
	  #  the size needed to hold the text in the window.
          #  foreach {w h x y} [split [winfo geometry $txtwin] "+x"] {}
          #  puts "TXTWIN: $txtwin W: $w H: $h"
	    
	    set line 0
	    set maxw -1

	    while {![string match "" [set lfo [$txtwin dlineinfo $line.1]]]} {
	        foreach {x y w h p} $lfo {}
		if {$w > $maxw} {set maxw [expr $w + 2]}
		incr line
	    }

	    if {$maxw > $pixReq($c)} {
 	      set pixReq($c) $maxw
	    }

            set nSize [font measure [$txtwin cget -font] -displayof $txtwin "n"]
	    set len [expr $pixReq($c) / $nSize]
	    
	    if {$len > $txtSize($c)} {
	      set txtSize($c) $len
	    }

	    set fsp [$txtwin search -forwards " " 0.0]
	    if {$firstSpace($c) < $fsp} {
	      set firstSpace($c) $fsp
	    }
        }
     }

    set aTextWidget [lindex $txtwinLst(0) 0]

    set parentPixelWidth [winfo width $parentWin]
    
    if {$parentPixelWidth < 10} {
        set parentPixelWidth [winfo width $win]
    }
	;# To account for the borders, shouldn't be hardcoded
    incr parentPixelWidth -30 

#  This looks like an old calculation, I think nSize is better.
#    set tablePixelWidth [winfo width $aTextWidget]
#    set charWidth [expr $tablePixelWidth / [$aTextWidget cget -width]]

    set charWidth $nSize

    set totalPixWid 0

    for {set c 0} {$c < $columns} {incr c} {
	incr totalPixWid $pixReq($c)
    }
    
#    if {$totalPixWid < $parentPixelWidth} {}
# This loses the font tag in the window
# and breaks html2ps
# Why?
    if {0} {
        set totalPixWid $parentPixelWidth

        for {set c 0} {$c < $columns} {incr c} {
          foreach w $txtwinLst($c) {
	    set cw [expr $pixReq($c) / $nSize]
	    incr cw 3

	    set txt [string trimright [$w get 1.0 end]]
	    $w delete 0.0 end
	    $w insert 1.0 $txt
	    set h [llength [split $txt \n]]
	    puts "TXT: ..$txt.."
	    puts "HH: $h"
	    $w configure -width $cw -height $h
	  }
        }
	return
    }

    # Look for child tables, might adjust the width here.
puts "totalPixWid $totalPixWid :: parentPixelWidth $parentPixelWidth"

    for {set c 0} {$c < $columns} {incr c} {
        puts "PRE: PIXREQ WIDTH: $c: $pixReq($c) Char: [expr $pixReq($c) / $nSize] -- $txtwinLst($c)"
    }

  for {set c 0} {$c < $columns} {incr c} {
      foreach w $txtwinLst($c) {
         foreach ch [winfo children $w ] {
	    update idle

            set prevWidth $pixReq($c)
puts "PREVWIDTH $ch: $prevWidth :: $pixReq($c)"
	    update idle;
	    TABLEsetWindowWidths $parentFrame $ch
	    update idle;
	    set childWidth [lindex [split [winfo geometry $ch] +x] 0]
puts "CHILDWIDTH: $childWidth"
	    if {($childWidth > $prevWidth) && 
	        ($childWidth < [expr $prevWidth * 2])} {
		set pixReq($c) [expr $childWidth + 15]
	    }
	    update idle;
#	    TABLEsetWindowWidths $parentFrame $ch
         }
      }
  }

    for {set c 0} {$c < $columns} {incr c} {
        puts "PIXREQ WIDTH: $c: $pixReq($c)"
    }
    
#  foreach child [winfo children $parentFrame] {
#      foreach ch [winfo children $child ] {
#	    update idle;
#	    TABLEsetWindowWidths $parentFrame $ch
#	    update idle;
#      }
#    }
  

    # Decide which columns get how many pixels/chars
    # Start by dividing the requested width by what's available.
    # Then jiggle it a bit for aesthetics.
    
    for {set c 0} {$c < $columns} {incr c} {
        set colWidth($c) [expr int ((((double($pixReq($c)) / $totalPixWid) * \
	     $parentPixelWidth) / $charWidth)* $HMtable(hasFixed))]

      puts " CALC: $c $colWidth($c) :: ((((double($pixReq($c)) / $totalPixWid) * \
	     $parentPixelWidth) / $charWidth)* $HMtable(hasFixed))"
    }

    set shrink 0
    

    # Aesthetics, hardcoded rules.
    # If it's within a few pixels of not wrapping, shift the edge over
    # If this column has < 10% of the total, expand
    # If this column has no spaces, expand


 puts "PRE JIGGLES"
    for {set c 0} {$c < $columns} {incr c} {
       puts "WIDTH: $c $colWidth($c)"
     }

    set shrink 0;
    for {set c 0} {$c < $columns} {incr c} {
         puts "Col: $c TXT: $txtSize($c) Col: $colWidth($c) : PixReq: $pixReq($c) :: $firstSpace($c)" 
        if {(($txtSize($c) > $colWidth($c)) && 
	    (($txtSize($c) - $colWidth($c)) < 15)) ||
	   ($pixReq($c) < [expr $totalPixWid / 10])  || 
	   ($firstSpace($c) >= $colWidth($c))   ||
	   ($firstSpace($c) == -1)   } {
	   if {(($firstSpace($c) > 0) && ($firstSpace($c) < ($txtSize($c) *.8))) 
	       && ($c != [expr $columns -1]) && 
	       ($pixReq($c) > (($parentPixelWidth / $columns) * 1.5) )  } {
	       set txtSize($c) $firstSpace($c)
	       puts "SET TxtSize to $firstSpace($c)"
	   }
	   set shrink [expr $shrink + $txtSize($c) - $colWidth($c) + 1]
	   set colWidth($c) [expr $txtSize($c) ]
	} else {
	puts "COLWID: $colWidth($c) SHR: $shrink"
	   set colWidth($c)  [expr $colWidth($c)  - $shrink]
	   set shrink 0;
	}
    }
    
    set charTotal 0
    for {set c 0} {$c < $columns } {incr c} {
        incr charTotal $colWidth($c)
    }
   
   set parentCwidth [expr [winfo width $parentWin] / $nSize]
   if {[expr $charTotal +2] <$parentCwidth } {
       # puts "USING: $charTotal - AVAILABLE CHARS: $parentCwidth"
       # puts "  set colWidth([expr $columns -1])  [expr $colWidth([expr $columns -1]) + $parentCwidth  - $charTotal -2 ]"
       set colWidth([expr $columns -1])  [expr $colWidth([expr $columns -1]) + \
           $parentCwidth - $charTotal -2 ]
   }

#  set backgs {pink yellow cyan green purple red}
    for {set c 0} {$c < $columns} {incr c} {
	foreach txtwin $txtwinLst($c) {
	    $txtwin configure -width  [expr int($colWidth($c) + 1)]
#	    puts "WIN: $txtwin WIDTH:  $colWidth($c) [lindex $backgs $c]"
#	    $txtwin configure -background [lindex $backgs $c]
	}
    }

    set c [expr $columns -1]
    set newcolWidth $colWidth($c)
#   puts "START NEWCOL: $colWidth($c) :: $c"

    if {![info exists txtwinLst($c)]} {continue}

    foreach txtwin $txtwinLst($c) {
        $txtwin configure -width $newcolWidth
	update idle;
        # puts "RECONFIG: $txtwin $newcolWidth [$txtwin cget -background]"
	update idle;
        foreach {w h x y} [split [winfo geometry $txtwin] "+x"] {}
	set right [expr $w + $x]
        # puts "RIGHT: $right :: X: $x W: $w $parentPixelWidth :: $newcolWidth :$charWidth [expr int($right - $parentPixelWidth) / ($charWidth)]"
	if {$right > $parentPixelWidth} {
	    set newcolWidth [expr int(($parentPixelWidth - $x) / \
	        ($charWidth * $HMtable(hasFixed)) )]
            # puts "NEWCOL: $newcolWidth"
            $txtwin configure -width $newcolWidth
	}
    }

    set colWidth($c) $newcolWidth 


  set row [lindex $HMtable(row) end]
  # puts "ROW - ..$row.. [grid size $parentFrame]"

  if {[string match $row ""]} {
      set row [lindex [grid size $parentFrame] 1]
      }

  set parentht 0;

  for {set r 0} {$r <= $row} {incr r} {
    set windows ""
    set max -1;
    debug "THIS ROW: $r :: [grid slaves $parentFrame -row $r]"
    foreach w [grid slaves $parentFrame -row $r] {
        if {[string match [winfo class $w] "Text"]} {
            $w configure -height 99
	    set fontHt [font metrics [$w cget -font] -displayof $w -linespace] 
            update; update idle;
            set ypos ""
	    set ii 1
	    while {[string match $ypos ""]} {
 	        foreach {xpos ypos wid ht base} [$w dlineinfo "end - $ii chars"] {}
debug "DLINEINFO for $w: [string trim [$w get 0.0 end]] .. [$w dlineinfo [list end - $ii chars]] "
		incr ii
	    }
	    set lines [expr {1 + (round (double($base) / $ht))}]
	    set lines [expr { (round (double($ht + $ypos) / $fontHt))}]

	    lappend windows $w
	    if {$lines > $max} {set max $lines}
	    }
	 }

	 incr parentht [expr $max + 1]

	 foreach w $windows {
	    $w configure -height $max
	}
    }
}

################################################################
#  proc HMtag_tr {win param text}--
#    Process the <TR> tag
#    This begins a new row by setting the row and column values.
# Arguments
#   
#   win		The window that holds the table
#   param	Any parameters in the </TR ...> tag
#   text	The name of a variable with associated text
# 
# Results
#   Increments the row position.
#   Sets the column to 0.
# 
 proc HMtag_tr {win param text} {
    global HMtable
upvar $text t
puts " WIN tr: $win -- $t"
    set row [lindex $HMtable(row) end]
    incr row

    set HMtable(row) [lreplace $HMtable(row) end end $row]
    set HMtable(column)  [lreplace $HMtable(column) end end 0]
}


################################################################
# proc HMtag_td {win param text}--
#    Process the <TD> tag
# Arguments
#   
#   win		The window that holds the table
#   param	Any parameters in the <TD ...> tag
#   text	The name of a variable with associated text
# 
# Results
#   Sets a tag for the start of this table entry to be used to 
#   set tab positions
# 
# Here's the idea.  When we get a <TABLE> we create a new frame to hold
#  the table cells.
# When there's a <TD>, we create a new text widget, and assign it to
#  var(divert)
# The new text window needs to be a member of the parent frame.
#    =====================================
#    | Window 1                          |
#    |   -----------------------------   |
#    |   | Table 1  (Frame)          |   |
#    |   | -----------  ------------ |   |
#    |   | |TD Win 2 | |   TD Win 3| |   |
#    |   | |         | |---------- | |   |
#    |   | |-------  | ||Tbl2 fr | | |   |
#    |   | |TD WIn 4 | || ------ | | |   |
#    |   | |TD WIn 4 | || TD W5  | | |   |
#    |   | |---------| |---------- | |   |
#    |   | -----------  ------------ |   |
#    |   -----------------------------   |
#    =====================================
    

proc HMtag_td {win param text} {

    global HMtable

    upvar #0 HM$win var
    upvar $text t

    if {[info exists var(Parent)]} {
        set win $var(Parent)
    }

    # Get rid of any leading spaces - spaces between <TD> and "start of text"

    set t [string trimleft $t]
    debug "HMtag_td : WIN: $win PARAM: $param TEXT: $text :: $t"

    set parentFrame [lindex $HMtable(Frame) end]

     array set parentVars [array get var]

# if {[info exists var(divert)]} {
#     puts "PARENT FRAME:  $HMtable(Frame) ::  VAR DIV: $var(divert)"
#     } else {
#     puts "PARENT:  $HMtable(Frame) NO DIVERT"
#     }

    catch {set newTable $parentFrame.txt_$HMtable(unique)}
debug "POINT 2"

   # tag resolution for items in the table happen after
   #  the <TD> tag - but before the text is inserted - It's 
   #  inserted with appropriate tags.

    # Get the current font from the master
    set curFont [HMx_font $parentVars(family) [lindex $parentVars(size) 0] $parentVars(weight) r [expr $parentVars(S_adjust_size) + 6]]

debug "BACK FROM HMx_font: $curFont"

#    puts "HMx_font $parentVars(family) 'lindex $parentVars(size) 1' $parentVars(weight) r $parentVars(S_adjust_size)"
#    puts "CURFONT: $curFont :: $newTable :: $parentVars(S_adjust_size) $parentVars(S_adjust_size)"

    upvar #0 HM$parentFrame tableVar
    debug "TABLEVAR: (HM$parentFrame) [array get tableVar]"

    catch {
    text $newTable -width 990 -height 2 -background $HMtable(Background) \
        -font $curFont -relief flat -borderwidth 0 -insertborderwidth 0 \
	-wrap word -highlightcolor $HMtable(Background) \
	-yscrollcommand "modTxtHt $newTable" \
	-highlightthickness 2 -highlightbackground $HMtable(Background) } ff

debug "HMTABLE: [array get HMtable]"
    
    array set conversion {
        border {-relief ridge -borderwidth}
	bgcolor -background
    }

    foreach n [array names tableVar CFG_*] {
        set key [string range $n 4 end]
	if {[info exists conversion($key)]} {
debug "N: $n KEY: $key"
debug "TABLE CONFIG:        $newTable configure $conversion($key) $tableVar($n)"
        eval $newTable configure $conversion($key) $tableVar($n)
	}
    }

    if {![string match $param ""]} {
      foreach p $param {
        regsub -all {"} $p {} p
        regsub -all { } $p {} p
        foreach {key val} [split $p =] {
	if {[info exists conversion($key)]} {
	    eval $newTable configure $conversion($key) $val
	 }
	}
      }
    }

#    array set col {0 pink 1 red 2 blue 3 orange 4 yellow 5 green 6 purple}
#    $newTable configure -background $col($HMtable(unique))

    incr HMtable(unique)
    
    HMinit_win $newTable $win

    # Divert output to the new window.

    set var(divert) $newTable

    # Make a new global state variable for the new text widget

    upvar #0 HM$newTable newvar
   
    # and initialize it - by inheriting settings from parent window.

    HMinit_state $newTable
    array set newvar [array get parentVars]
    set newvar(Parent) $win
    catch { unset newvar(divert)}

    # trace variable newvar(style) w what 
    
    # Create the new text widget
    update; update idle;

    set curFont [HMx_font $newvar(family) [lindex $newvar(size) 0] $newvar(weight) $newvar(style)]

    update; update idle;
    debug "$newTable :: $HMtable(row) -column $HMtable(column) -sticky nsew"
    grid  $newTable -row [lindex $HMtable(row) end] -column [lindex $HMtable(column) end] -sticky nsew

    set column [lindex $HMtable(column) end]
    incr column
    set HMtable(column) [lreplace $HMtable(column) end end $column]
}

################################################################
# proc HMtag_/td {win param text}--
#    
# Arguments
#
#   win		The window that holds the table
#   param	Any parameters in the </TD ...> tag
#   text	The name of a variable with associated text
# 
# Results
#   Increments the column position.  
#   If there are more columns in this table row than in previous
#      rows, set the max column

proc HMtag_/td {win param text} {
# upvar $text t
debug "WIN:  $win PARAM: $param TXT: $t"
}

################################################################
# proc HMlink_callback {win href}--
#    This proc is called by the html_library code to parse a 
#	hypertext reference.
#
# Arguments
#   win		The text window that is used by the html_library to
#  		display the text
#   href	A hypertext reference to use for the next hypertext.
#
# Results
#   This example simply replaces the contents of the display with
#   hardcoded new text.

proc HMlink_callback {win href} {
    global newHTMLtxt

    # Clear the old contents from the window.

    HMreset_win $win

    # Display the new text.

#    HMparse_html "<HTML><BODY><H2>links not implemented</H2></BODY></HTML>" "HMrender $win"
#    HMparse_html $help::helps($href) "HMrender  $win"
     help::_insertHelp $href
}

 ################################################################
 # proc HMset_image {win handle src}--
 #    Acquire image data, create a Tcl image object, 
 #    and return the image handle.
 #
 # Arguments
 #   win         The text window in which the html is rendered.
 #   handle      A handle to return to the html library with the image handle
 #   src         The description of the image from: <IMG src=XX> 
 #   speed 	 Optional value for a list of images that will cycle.
 #               Only used in TclPoint.
 # 
 # Results
 #   Loads an image from a local file.  Does not download images
 #   Invokes HMgot_image with the handle for the image created.

 proc HMset_image {win handle src {speed {0}}} {
     debug "IMG TclPoint HMset_image was invoked with WIN: $win HANDLE: $handle SRC: $src SPEED: $speed"

     global PointerState tcl_platform
     upvar #0 HM$win var


     # In a real application this would parse the src, and load the 
     #  appropriate image data.
     
     set imgSrc [lindex $src 0]

     HMgot_image $handle $imgSrc

     return ""
 }

set release(balloon.tcl) {$Header: /home/cvs/AuStuff/balloon.tcl,v 1.1.1.1 2006/08/01 21:09:37 clif Exp $}
#
##############################################################################
# balloon.tcl - procedures used by balloon help
#
# Copyright (C) 1996-1997 Stewart Allen
# 
# This is part of vtcl source code
# Adapted for general purpose by 
# Daniel Roche <dan@lectra.com>
# version 1.1 ( Dec 02 1998 ) 
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

##############################################################################
#

bind Bulle <Enter> {
    set Bulle(set) 0
    set Bulle(first) 1
    set Bulle(id) [after 250 {balloon %W $Bulle(%W) %X %Y}]
}

bind Bulle <Button> {
    set Bulle(first) 0
    kill_balloon
}

bind Bulle <Leave> {
    set Bulle(first) 0
    kill_balloon
}

bind Bulle <Destroy> {
    if {[info exists Bulle(target)] && "%W"==$Bulle(target)} {
        kill_balloon
    }
}

bind Bulle <Motion> {
    if {$Bulle(set) == 0} {
        after cancel $Bulle(id)
        set Bulle(id) [after 250 {balloon %W $Bulle(%W) %X %Y}]
    }
}

proc set_balloon {target message} {
    global Bulle
    set Bulle($target) $message
    set x [bindtags $target]
    if {[lsearch $x Bulle]<0} {
        lappend x Bulle
        bindtags $target $x
    }
}

proc kill_balloon {} {
    global Bulle
    after cancel $Bulle(id)
    if {[winfo exists .balloon] == 1} {
        destroy .balloon
    }
    set Bulle(set) 0
}

proc balloon {target message {cx 0} {cy 0} } {
    global Bulle
    if {$message==""} return
    if {$Bulle(first) == 1 } {
        set Bulle(first) 2
	if { $cx == 0 && $cy == 0 } {
	    set x [expr [winfo rootx $target] + ([winfo width $target]/2)]
	    set y [expr [winfo rooty $target] + [winfo height $target] + 4]
	} else {
	    set x [expr $cx + 4]
	    set y [expr $cy + 4]
	}
        catch {destroy .balloon}
        toplevel .balloon -bg black
        wm overrideredirect .balloon 1
        set sw [winfo screenwidth .balloon]
        set sh [winfo screenheight .balloon]
        label .balloon.l -justify left \
            -text $message -relief flat \
            -bg #ffffaa -fg black -padx 2 -pady 0 -anchor w
        pack .balloon.l -side left -padx 1 -pady 1
        wm geometry .balloon +${sw}+${sh}
        update idletasks
        if {![winfo exists .balloon]} return
        set width [winfo reqwidth .balloon]
        set height [winfo reqheight .balloon]
        if {$x+$width>$sw} {set x [expr {$cx - ($width+4)}]}
        if {$y>$sh*0.75} {set y [expr {$cy - ($height+4)}]}
        wm geometry .balloon +${x}+${y}
        set Bulle(set) 1
        set Bulle(target) $target
    }
}


array set tags {no FAIL yes OK}
array set showField {SYSCALL,msg 0 SYSCALL,success 1}

proc centerWindow {w {parent {}}} {
  ::update
  set ww [winfo reqwidth $w]
  set wh [winfo reqheight $w]
  if {$parent==""} {
    set px 0
    set py 0
    set pw [winfo screenwidth .]
    set ph [winfo screenheight .]
    if {$pw>$ph*1.25} {set pw [expr {int($ph*1.25)}]}
    if {$ph>$pw*1.25} {set ph [expr {int($pw*1.25)}]}
  } else {
    set px [winfo rootx $parent]
    set py [winfo rooty $parent]
    set pw [winfo width $parent]
    set ph [winfo height $parent]
  }
  set x [expr {$px+($pw-$ww)/2}]
  set y [expr {$py+($ph-$wh)/2}]
  if {$x<0} {set x 0}
  if {$y<0} {set y 0}
  wm geometry $w +$x+$y
  safeFocus $w
}


# proc:  ::main::focus WINDOW
# title: Bring WINDOW into focus
#
# Deiconify WINDOW, raise it to the top in stacking order and give
# it keyboard focus.
#
proc safeFocus {w} {
  if {![winfo exists $w]} {set w .f.c}
  set top [winfo toplevel $w]
  if {$top!=$w || [set target [::focus -lastfor $top]]==""} {
    set target $w
  }
  catch {::focus $target}
  wm deiconify $top
  # ::update
  raise $top
  ::focus $target
  after idle [subst -nocommands {catch {
    raise $top
    after idle {catch {::focus $target}}
  }}]
}

proc getAusearchByTimeGUI {} {

  catch {destroy .getTime}
  set t [toplevel  .getTime]
  wm title $t "Select Time Range"

  set f [labelframe $t.f1 -text "Time Start"]
  grid $f -row 0 -column 0 -columnspan 2
  set e [entry $f.e -width 20 -textvariable ts]
  pack $e

  set f [labelframe $t.f2 -text "Time End"]
  grid $f -row 1 -column 0 -columnspan 2
  set e [entry $f.e -width 20 -textvariable te]
  pack $e
  
  button $t.b1 -text "Go" -command {destroy .getTime; getAusearchByTime $ts $te}
  button $t.b2 -text "Cancel" -command {destroy .getTime}
  grid $t.b1 -row 2 -column 0
  grid $t.b2 -row 2 -column 1
}

proc cvtToSecs {str} {
  
  # Add a second field, default to today or now
  # depending on whether the day or time is missing

  if {[llength $str] == 0} {
    return [clock seconds]
  } elseif {[llength $str] == 1} {
    set secs [clock seconds]
    if {[string first : $str] < 0} {
      append str " [clock format $secs -format %H:%M]"
    } else {
      set str "[clock format $secs -format %m/%d/%y] $str"
    }
  }
  return [clock scan $str]
}

proc getAusearchByTime {ts {te {}} } {
  global auState
  global data 
  
  foreach t $auState(tables) {
    db eval "DELETE  FROM $t"
  }
puts "How Many: [llength [glob /var/log/audit/log*gz]] "  
  if {[llength [glob /var/log/audit/log*gz]] > 0} {
    set data {}
    set auState(usingAusearch) 0
    set startSecs [cvtToSecs $ts]
    set endSecs [cvtToSecs $te]
puts "STARTS: $startSecs END: $endSecs : NOW [clock seconds]"

    foreach fileName [glob /var/log/audit/log*gz] {
      foreach {log m d t gz} [split $fileName {- .}] break;
      set secs [clock scan "$m/$d $t"]
      if {($secs >= $startSecs) && ($secs <= $endSecs)} {
        set if [open "|zcat $fileName" r]
        append data [read $if]
        close $if
      }
    }
    if {[string equal {} $te]} {
      set if [open /var/log/audit/audit.log]
      append data [read $if]
      close $if
    }
#puts "D: $data"
    scanData $data
  } else {
    set auState(usingAusearch) 1
    if {![string equal {} $te]} {
      set if [open "|ausearch -ts $ts -te $te" r]
    } else {
      set if [open "|ausearch -ts $ts" r]
    }
    scanData [read $if]
    close $if
  }
}

proc scanData {data} {
  global time auState
  set t [time {
    db transaction {
      foreach l [split $data \n] {
        if {[string first --- $l] != 0} {
	  if {$auState(usingAusearch) == 0} {
	    set p1 [string first "msg=" $l]
	    incr p1 10
	    set p2 [expr $p1 + 9]
	    set t [string range $l $p1 $p2]
	    set time $t
	  }
          if {[string first "type=" $l] == 0} {
            set p1 [string first = $l]
            incr p1
            set p2 [string first " " $l]
            incr p2 -1
            set cmd [string range $l $p1 $p2]
            incr p2
            $cmd [string range $l $p2 end]
          } else {
            set time [clock scan [lindex [split $l >] 1]]
          }
        }
      }
    }
  }]
  puts "TIME: $t for [llength [split $data \n]] Records"
}

proc genReport {tblName} {
  global selectVal tags showField 
  global auState

  set auState(abort) 0
  
  set conj ""

  foreach in [array names selectVal $tblName,*] {
    if {[string first Ignore $selectVal($in)] < 0} {
      foreach {tb fld val} [split $in ,] {break;}
      foreach {a b c} $selectVal($in) {break;}
      if {[string equal {} $c]} {
      append test "$conj $fld = '$b' "
      } else {
      append test "$conj $b $fld = '$c' "
      }
      set conj $a
    }
  }

  set pos 0
  db eval "SELECT * FROM $tblName WHERE $test ORDER BY time" it {

    set dflt tag[unique]

    foreach f [lsort [array names it]] {
      if {[string equal "*" $f]} {continue}
      if {![info exists showField($tblName,$f)] || \
           $showField($tblName,$f) == 0} {continue}
      if {[string match time $f]} {
        set it($f) [clock format $it($f)]
      }
      lappend lst "$f: " 
      lappend lst "LABEL $dflt"
      lappend lst "$it($f)   " 
      if {[info exists tags($it($f))]} {
        lappend lst "$tags($it($f)) $dflt"
      } else {
        lappend lst $dflt
      }
    }
    
    foreach name $auState(tables) {
      if {[string equal $name $tblName]} {continue}
      catch {unset it2}

      db eval "SELECT * FROM $name WHERE msg='$it(msg)'" it2 {
        foreach f [lsort [array names it2]] {
          if {[string equal "*" $f]} {continue}
          if {![info exists showField($name,$f)] || \
             $showField($name,$f) == 0} {continue}
          if {[string match time $f]} {
            set it2($f) [clock format $it2($f)]
          }
          lappend lst "$f: " 
          lappend lst "LABEL $dflt"
          lappend lst "$it2($f)   " 
          if {[info exists tags($it2($f))]} {
            lappend lst "$dflt $tags($it2($f))"
          } else {
            lappend lst $dflt
          }
        }
      }
    }
    
    eval .t insert end $lst
    .t insert end \n
    set lst ""
    .t tag bind $dflt <Button-1> "showDetails $it(msg)"
    if {[expr {[incr pos] %20}] == 0} {
      update idle
      update 
      if {$auState(abort)} {return}
      puts "POS: $pos"
    }
  }
}


proc showDetails {msg} {
  global auState
  if {[winfo exists .details]} {
    raise .details
    set t .details
  } else {
    set t [toplevel .details]
  }
  wm title .details "Details on audited items"

  set t2 [text $t.t]
  grid $t2 -row 0 -column 0 -sticky news
  grid rowconfigure $t 0 -weight 1
  grid columnconfigure $t 0 -weight 1
  
  
  $t2 tag configure FAIL -foreground red
  $t2 tag configure OK -foreground blue
  $t2 tag configure LABEL -font {arial 8 bold}
  
  set dflt $msg
  set lst {}
  foreach t $auState(tables) {
    catch {unset it}
    db eval "SELECT * FROM $t WHERE msg='$msg'" it {}

    if {[info exists it]} {
      foreach f [lsort [array names it]] {
        if {[string equal "*" $f]} {continue}
        if {[string match time $f]} {
          set it($f) [clock format $it($f)]
        }
        lappend lst "$f: " 
        lappend lst "LABEL $dflt"
        lappend lst "$it($f)   " 
        if {[info exists tags($it($f))]} {
          lappend lst "$dflt $tags($it($f))"
        } else {
          lappend lst $dflt
        }
      }
    }
  $t2 insert end "$t: "
  if {[llength $lst] > 0} {
    eval $t2 insert end $lst
  }
  $t2 insert end "\n"
  set lst {}
  }
}

proc getSchema {tblName} {
    set db [db onecolumn "SELECT sql FROM sqlite_master WHERE name='$tblName'"]
    set p1 [string first "(" $db]
    set p2 [string last ")" $db ]
    incr p1; incr p2 -1
    return [split [string trim [string range $db $p1 $p2]] \n]
}


proc unique {{val 0}} {
  incr val
  proc unique "{val $val}" [info body unique]
  return $val
}

proc buildFieldSelector {f1} {
  global showField auState
  
  set tr 0; set tc 0

  foreach name [lsort -dict $auState(tables)] {
    set r 0; set c 0; set w 0

    set f [labelframe $f1.l[unique] -text "Fields in $name" -bg white]
    grid $f -row $tr -column $tc -sticky news 
    incr tc; 
    if {$tc > 1} {
      set tc 0; incr tr
    }
    set tblName $name
    foreach set [lsort -dict [getSchema $tblName]] {
      set nm [string trim [lindex $set 0]]
      set b [checkbutton $f.b[unique] -text $nm -bg white\
          -variable showField($tblName,$nm)]
      grid $b -row $r -column $c -sticky w
      incr c
      incr w [string length $nm]
      if {$w > 40} {set c 0; incr r; set w 0}
    }
  }
}

proc customReport {tblName} {
global distincts
global auState
  set auState(curTbl) $tblName
  
  catch {destroy .top}
  catch {unset distincts}
  
  set t [toplevel .top]
  wm title $t "Selection based on $tblName fields"
  set tr 0
  set tc 0
  
  set nt [notebook::makeNotebook $t.nt]

  grid $nt -row $tr -column $tc -columnspan 2
  set noshow {time msg a0 a1 a2 a3}
  
  foreach n $noshow {
    append tst " \[string match \$nm $n\] ||"
  }

  set tst [string trim $tst |]
  
  set f [notebook::insertTab $nt "Show Selected Fields"]

  buildFieldSelector $f

  set r 0; set c 0
  foreach set [getSchema $tblName] {
    set nm [string trim [lindex $set 0]]
    incr c
    if {$c > 3} {
      incr r; set c 0
    }
    if "$tst" {continue}
    set distincts($nm) [db eval "SELECT distinct $nm FROM $tblName"]
  }

  foreach in [lsort -dict [array names distincts]] {
    set f [notebook::insertTab $nt "$in"]
    if {[string match msg $in] || [string match time $in]} {continue}

    if {[llength $distincts($in)] > 60} {
      makeSelFrame $tblName $in $f
    } else {
      fillSelFrame $tblName $f $in
    }
  }

  incr tr
  button $t.go -text "Generate Report" \
    -command "destroy .top; genReport $tblName"
  button $t.cancel  -text "Cancel" -command "destroy .top"
  
  grid $t.go -row $tr -column 0
  grid $t.cancel -row $tr -column 1
}

proc fillSelFrame {tblName f in} {
  global distincts
  
  fillSelFrameFromList $tblName $f $in [lsort -dict $distincts($in)]
}

# lst is expected to be sorted

proc fillSelFrameFromList {tblName f in lst {maxWid 120}} {
  global distincts
  
    set r 0
    set c 0
    set w 0
    foreach dist $lst {
      set b [toggleButton $f.b_[unique] \
[list "Ignore $dist" "AND $dist"  "OR $dist" "AND NOT $dist"  "OR NOT $dist"] \
          selectVal($tblName,$in,$dist) ]
      grid $b -row $r -column $c -sticky w
      incr c
      if {$c >= 4} {
        incr r;
	set c 0
      }
    }
}

proc makeSelTopLevel {tblName in} {
  global distincts
  if {[winfo exists .select]} {
    eval destroy [winfo children .select]
    raise .select
    set t .select
  } else {
    set t [toplevel .select]
  }
  wm title $t "Select from $in in $tblName"

  set f [labelframe $t.f_[unique] -text "Display when $in is:"]
  grid $f -row 0 -column 1 -columnspan 2 -sticky news
  
  set lst [lsort -dict $distincts($in)]
  set ysb [scrollbar $t.ysb -orient vertical \
      -command [list yview $t.ysb $lst $tblName $f $in]]
  
  grid $ysb -row 0 -column 0 -sticky ns
  grid rowconfigure $t 0 -weight 1
  grid columnconfigure $t 1 -weight 1
  grid columnconfigure $t 2 -weight 1

  set b [button $t.b -text "Dismiss" -command "destroy $t"]
  grid $b -row 1 -column 1

  yview $ysb $lst $tblName $f $in moveto 0.0
}

proc makeSelFrame {tblName in t} {
  global distincts
  
  set f [labelframe $t.f_[unique] -text "Display when $in is:"]
  grid $f -row 0 -column 1 -columnspan 2 -sticky news
  
  set lst [lsort -dict $distincts($in)]
  set ysb [scrollbar $t.ysb -orient vertical \
      -command [list yview $t.ysb $lst $tblName $f $in]]
  
  grid $ysb -row 0 -column 0 -sticky ns
  grid rowconfigure $t 0 -weight 1
  grid columnconfigure $t 1 -weight 1
  grid columnconfigure $t 2 -weight 1

  yview $ysb $lst $tblName $f $in moveto 0.0
}

proc yview {sb lst tblName frm in args} {

  global distincts
  global selState

  eval destroy [winfo children $frm]
  
  set len [llength $lst]
  
  set cmd [lindex $args 0]
  switch -- $cmd {
    moveto {
        set fract [lindex $args 1]
        set selState(start) [expr {int($fract * $len)}]
    }
    scroll {
      foreach {cmd size element} $args {break;}
      switch $element {
        units {
	  set selState(start) [expr {$selState(start) + ($size * 4)}]
	}
	pages {
	  set selState(start) [expr {$selState(start) + ($size * 60)}]
	}
      }
    }
  }
  set l2 [expr {$len - 60}]
  if {$selState(start) > $l2} {
    set selState(start) $l2
  }
  if {$selState(start) < 0} {
    set selState(start) 0
  }
  set end [expr {$selState(start) + 59}]
  fillSelFrameFromList $tblName $frm $in [lrange $lst $selState(start) $end] 80
  $sb set [expr {double($selState(start)) / $len}] [expr {double($end) / $len}]
}

set auState(MessageWatch) {Pam passwd ve/pam}

proc pamScanVarLogMessages {} {
  global auState
  set if [open /var/log/messages r]
  set d [read $if]
  close $if
  foreach l [split $d \n] {
    foreach w $auState(MessageWatch) {
      if {[string first $w $l] > 0} {
        .t insert end "$l\n"
      }
    }
  }
}

proc saveRpt {} {
  set fname [tk_getSaveFile]
  if {[string equal {} [string trim $fname]]} {return}
  set of [open $fname w]
  puts $of [.t get 0.0 end]
  close $of
}

proc makeGUI {} {
  global auState env
  global showField selectVal

  set bframe [frame .bf]
  grid .bf -row 1 -column 1 -columnspan 3 -sticky ew
  
  set b [button $bframe.b[unique] -image icon:clear -command {.t delete 0.0 end}]
  pack $b -side left
  set_balloon $b "Clear report frame"

  set b [button $bframe.b[unique] -image icon:stop -command {set auState(abort) 1}]
  pack $b -side left
  set_balloon $b "Abort Report being generated"

#  set b [button $bframe.b[unique] -text "TEST1" -command {
#    set selectVal(SYSCALL,comm,dhcpd) "AND dhcpd"
#    foreach in {PATH,item SYSCALL,time SYSCALL,success PATH,name PATH,parent} {
#      set showField($in) 1
#    }
#    genReport SYSCALL
#  }]
#  pack $b -side left
  
  menu .m -type menubar
  . configure -menu .m
  
  .m add cascade -label File -menu .m.f
  menu .m.f
  .m.f add command -label ReScan -command "getAusearchByTimeGUI"
  .m.f add command -label Save -command "saveRpt"
  .m.f add command -label Exit -command exit

  .m add cascade -label Tools -menu .m.t
  menu .m.t
  .m.t add command -label "Scan for Logins and Password changes" -command "pamScanVarLogMessages"
  .m.t add command -label "Save Custom Report" -command "saveCmdGUI $bframe"
  foreach t $auState(tables) {
    .m.t add command -label "Custom Report on $t" -command "customReport $t"
  }
  
  .m add cascade -label Help -menu .m.help
  menu .m.help


  .m.help add command -label {About} -command help::about
  .m.help add command -label {Version} -underline 0 -command ::help::versions
  .m.help add cascade -label Topics -menu .m.help.top
  .m.help add cascade -label Windows -menu .m.help.win
  .m.help add cascade -label Menu -menu .m.help.men
  menu .m.help.top
  menu .m.help.men
  menu .m.help.win

  foreach in [lsort -dict [array names help::helps]] {
    if {[string first / $in] > 0} {
      set base [string tolower [lindex [split $in /] 0]]
      set len [string length $base]
      incr len 
      set rest [string range $in $len end]

      if {![winfo exists .m.help.men.$base]} {
        .m.help.men add cascade -label [string totitle $base] \
  	    -menu .m.help.men.$base
	menu .m.help.men.$base
      } 
      .m.help.men.$base add command -label $rest -command "help::help $in"
    } elseif {[string first . $in] >= 0} {
      .m.help.win add command -label [string map {. { }} $in] \
          -command "help::help $in"
    } else {
      .m.help.top add command -label [string totitle [string map {_ { }} $in]]\
       -command "help::help $in"
    }
  }

  text .t -yscrollcommand ".ysb set" -xscrollcommand ".xsb set" -wrap none
  .t tag configure FAIL -foreground red
  .t tag configure OK -foreground blue
  .t tag configure LABEL -font {arial 8 bold}

  scrollbar .ysb -orient vertical -command ".t yview"
  scrollbar .xsb -orient horizontal -command ".t xview"
  
  grid .t -row 2 -column 1 -sticky news
  grid .ysb -row 2 -column 2 -sticky ns
  grid .xsb -row 3 -column 1 -sticky ew
  
  grid rowconfigure . 2 -weight 1
  grid columnconfigure . 1 -weight 1

  # Get the user defined buttons
  catch {source $env(HOME)/.aureportrc}
}

proc saveCmd {saveNm bframe} {
  global selectVal showField auState
  global env
  set of [open $env(HOME)/.aureportrc a]
  puts $of "set b \[button $bframe.b\[unique\] -text {$saveNm} -command {"
  puts $of "  array set selectVal [list [array get selectVal]]"
  puts $of "  array set showField [list [array get showField]]"
  puts $of "  genReport $auState(curTbl)}\]"
  puts $of {pack $b -side left}
  close $of
  eval destroy [winfo children .]
  makeGUI
}

proc saveCmdGUI {bframe} {
  catch {destroy .saveName}
  set t [toplevel  .saveName]
  wm title $t "Customize"

  set f [labelframe $t.f1 -text "Title For New Item"]
  grid $f -row 0 -column 0 -columnspan 2
  set e [entry $f.e -width 20 -textvariable saveNm]
  pack $e

  button $t.b1 -text "Go" -command "destroy .saveName; saveCmd \$saveNm $bframe"
  button $t.b2 -text "Cancel" -command {destroy .saveName}
  grid $t.b1 -row 2 -column 0
  grid $t.b2 -row 2 -column 1
  
}

proc OLDsplitLine {line} {
#  regsub -all {\"} $line {} line
  set line [string map { {"} {}} $line]

  foreach p [split $line] {
    foreach {k v} [split $p =] {
      lappend flds "$k,"
      lappend vals "'[string map {{'} {''}} [string trim $v ,]]',"
    }
  }
  set flds [string trim $flds ,]
  set vals [string trim $vals ,]
  return [list $flds $vals]
}

# Cuts time by about 10 seconds on a large (220K lines) dataset
# over the previous version.

proc splitLine {line} {
  set line [string map { {[} {(} {]} {)} {'} {''} {"} {} {,} {} \
      {=} { } {  } { }} $line]

  foreach {k v} [split [string trim $line]] {
    append flds "$k,"
    append vals "'$v',"
  }
  return [list $flds $vals]
}

proc CWD {line} {
  global time
  foreach {flds vals} [splitLine $line] {break;}
  append flds " time"
  append vals " $time"
  db eval "INSERT INTO CWD ($flds) VALUES ($vals)"
}

proc PATH {line} {
  global time
  foreach {flds vals} [splitLine $line] {break;}
  append flds " time"
  append vals " $time"
  db eval "INSERT INTO PATH ($flds) VALUES ($vals)"
}

proc SYSCALL {line} {
  global time
  foreach {flds vals} [splitLine $line] {break;}
  append flds " time"
  append vals " $time"
  db eval "INSERT INTO SYSCALL ($flds) VALUES ($vals)"
}

proc CONFIG_CHANGE {line} {
  global time
  foreach i [split $line] {
    if {[string first = $i] > 0} {
      append pairs "$i "
    } else {
      append desc "$i "
    }
  }
  foreach {flds vals} [splitLine $pairs] {}
  append flds " desc, time"
  append vals " '$desc', $time"
  db eval "INSERT INTO CONFIG_CHANGE ($flds) VALUES ($vals)"
}

proc DAEMON_ABORT {line} {
  global time 
  foreach i [split $line] {
    if {[string first = $i] > 0} {
      append pairs "$i "
    } else {
      append desc "$i "
    }
  }
  foreach {flds vals} [splitLine $pairs] {}
  append flds " desc, time"
  append vals " '$desc', $time"
  db eval "INSERT INTO DAEMON_ABORT ($flds) VALUES ($vals)"
}

proc DAEMON_START {line} {
  global time
  foreach i [split $line] {
    if {[string first = $i] > 0} {
      append pairs "$i "
    } else {
      append desc "$i "
    }
  }
  foreach {flds vals} [splitLine $pairs] {}
  append flds " desc, time"
  append vals " '$desc', $time"
  db eval "INSERT INTO DAEMON_START ($flds) VALUES ($vals)"
}


proc DAEMON_END {line} {
  global time
  foreach i [split $line] {
    if {[string first = $i] > 0} {
      append pairs "$i "
    } else {
      append desc "$i "
    }
  }
  foreach {flds vals} [splitLine $pairs] {}
  append flds " desc, time"
  append vals " '$desc', $time"
  db eval "INSERT INTO DAEMON_END ($flds) VALUES ($vals)"
}


package require sqlite3

sqlite3 db :memory:

db eval {CREATE TABLE CWD (
  msg text,
  time integer,
  cwd text)}

db eval {CREATE TABLE PATH (
  msg text,
  time integer,
  item text,
  parent text,
  name text,
  inode text,
  dev text,
  mode text,
  ouid text,
  ogid text,
  rdev text
)} 

db eval {CREATE TABLE SYSCALL (
  msg text,
  time integer,
  arch text,
  syscall text,
  per  text,
  success text,
  exit text,
  a0 text,
  a1 text,
  a2 text,
  a3 text,
  items text,
  pid text,
  auid text,
  uid text,
  gid text,
  euid text,
  suid text,
  fsuid text,
  egid text,
  sgid text,
  fsgid text,
  tty text,
  comm text,
  exe text
)} 

db eval {CREATE TABLE CONFIG_CHANGE (
  msg text,
  time integer,
  auid text,
  list text,
  res text,
  audit_enabled text,
  audit_backlog_limit text,
  old text,
  desc text
)}


db eval {CREATE TABLE DAEMON_ABORT (
  msg text,
  time integer,
  ver text,
  auid  text,
  res  text,
  pid text,
  desc text
  )}

db eval {CREATE TABLE DAEMON_START (
  msg text,
  time integer,
  ver text,
  format  text,
  auid  text,
  res  text,
  pid text,
  desc text
  )}

db eval {CREATE TABLE DAEMON_END (
  msg text,
  time integer,
  auid  text,
  res  text,
  pid text,
  ver text,
  format text,
  subj text,
  desc text
  )}

set auState(tables) [db eval {SELECT DISTINCT name FROM sqlite_master}]
puts "TABLES: $auState(tables)"
set t [toplevel .splash]
canvas $t.c -bg red -width 400 -height 300
$t.c create text 200 150 -text "Starting" -font {arial 24 bold}
pack $t.c
wm withdraw .
update idle

makeGUI

set tstFl /tmp/auditd.out
set tstFl /tmp/auditd.long.out
if {[file exists $tstFl]} {
  set if [open $tstFl r]
  set data [read $if]
  close $if
  set auState(usingAusearch) 0
  scanData $data
  unset data
} else {
  set ts [clock format [expr {[clock seconds] - 3600}] -format "%H:%M:%S"]
  getAusearchByTime $ts
}

destroy $t
wm deiconify .


