//#define G95 1
/* DOC
 *
 *  ftcl.h  - header file for FTCL (interface between Fortran and Tcl/Tk)
 *
 *  Copyright (C) 1999 Arjen Markus
 *
 *  Arjen Markus
 *
 *
 *  General information:
 *  This file contains the prototypes and such for FTCL
 *
 *  Note:
 *  The code uses the following macros:
 *  IN_BETWEEN - if defined, specifies that the length of character
 *               strings should follow the argument directly
 *  FOR_CALL   - macro for specifying the calling convention
 *  FOR_RETURN - macro for specifying the return type
 *  RETURN     - macro for specifying the return statement
 *  FTNLEN     - type for implicit string length
 *
 *  FortProc   - the type for a Fortran routine that implements
 *               a Tcl command
 *
 *  It uses the following Fortran-like types:
 *  integer    - Fortran INTEGER
 *  real       - Fortran REAL
 *  doublereal - Fortran DOUBLE PRECISION REAL
 *  logical    - Fortran LOGICAL
 *
 *  The following macros are used for recognising the platforms:
 *  G77:    GNU g77 FORTRAN compiler
 *  G95:    GNU g95 Fortran 90 compiler
 *  __sun:  SUN Solaris, native C and Fortran compilers
 *  __hpux: HPUX, native C and Fortran compilers
 *  WIN32:  Windows, MSVC as the C compiler
 *
 * ENDDOC
 */

/*  $Author: clif $
 *  $Date: 2006/07/20 17:21:52 $
 *  $Source: /home/cvs/FORTRAN_Tclsh/ftcl.h,v $
 *  $Log: ftcl.h,v $
 *  Revision 1.5  2006/07/20 17:21:52  clif
 *  Cleanup.  Evolution from working with fssimix and DCM.
 *
 *  Revision 1.1.1.1  2006/07/19 20:54:20  clif
 *  A Tclsh library designed to be linked with FORTRAN programs.  Using Arjen
 *  Markus's Ftcl extension and the memTclsh library.
 *
 *  Revision 1.4  2006/07/12 23:13:49  clif
 *  Added AbSoft support.
 *
 *  Revision 1.3  2006/07/06 22:21:15  clif
 *  Commented out hardcode to define G95 (fixed Makefile to get rid of
 *  bad behavior that was a workaround for.)  Added lf95 #define for Lahey
 *  Fortran under RH 7.3
 *
 *  Revision 1.2  2006/07/06 17:51:17  clif
 *  Modifications to be happy with Lahey Fortran under RH 7.3 and GCC 2.96.
 *
 *  Revision 1.1  2006/06/12 23:20:53  clif
 *  Added support for ftcl.
 *
 */

#define VERSION "0.9"

/* Include files
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <float.h>

#include "tcl.h"

/* Local macro definitions
*/
/* Default values */
#define EXPORT_FUNC
#define IN_BETWEEN
#define FOR_CALL
#define FOR_RETURN void
#define RETURN     return
#define FTNLEN     int
#define integer    long int
#define real       float
#define doublereal double
#define logical    long int

#undef  FORTRAN_START_NAME
#define FORTRAN_START_NAME FORTRAN_START

#ifdef lf95
#undef IN_BETWEEN
#define ftcl_get_int            ftcl_get_int_
#define ftcl_get_string         ftcl_get_string_
#define ftcl_get_arg_int        ftcl_get_arg_int_
#define ftcl_get_real           ftcl_get_real_
#define ftcl_get_arg_real       ftcl_get_arg_real_
#define ftcl_get_double         ftcl_get_double_
#define ftcl_get_arg_double     ftcl_get_arg_double_
#define ftcl_put_int            ftcl_put_int_
#define ftcl_put_real           ftcl_put_real_
#define ftcl_put_double         ftcl_put_double_
#define ftcl_put_string         ftcl_put_string_
#define ftcl_set_result_real    ftcl_set_result_real_
#define ftcl_exec               ftcl_exec_
#define ftcl_script             ftcl_script_
#define ftcl_start              ftcl_start_
#define ftcl_init_log           ftcl_init_log_
#define ftcl_main_loop          ftcl_main_loop_
#define ftcl_make_command       ftcl_make_command_

#undef  FORTRAN_START_NAME
#define FORTRAN_START_NAME  FORTRAN_START_UNDERSCORE
#endif

/* Gnu Fortran 95 - g95 */
#ifdef G95
#undef IN_BETWEEN
#define ftcl_get_int            ftcl_get_int__
#define ftcl_get_string         ftcl_get_string__
#define ftcl_get_arg_int        ftcl_get_arg_int__
#define ftcl_get_real           ftcl_get_real__
#define ftcl_get_arg_real       ftcl_get_arg_real__
#define ftcl_get_double         ftcl_get_double__
#define ftcl_get_arg_double     ftcl_get_arg_double__
#define ftcl_put_int            ftcl_put_int__
#define ftcl_put_real           ftcl_put_real__
#define ftcl_put_double         ftcl_put_double__
#define ftcl_put_string         ftcl_put_string__
#define ftcl_set_result_real    ftcl_set_result_real__
#define ftcl_exec               ftcl_exec__
#define ftcl_script             ftcl_script__
#define ftcl_start              ftcl_start__
#define ftcl_init_log           ftcl_init_log__
#define ftcl_main_loop          ftcl_main_loop__
#define ftcl_make_command       ftcl_make_command__

#undef  FORTRAN_START_NAME
#define FORTRAN_START_NAME  FORTRAN_START_UNDERSCORE
#endif

/* Gnu FORTRAN 77 - g77 */
#ifdef G77

#undef IN_BETWEEN
#undef FOR_RETURN
#undef RETURN
#undef FTNLEN
#undef integer
#undef real
#undef doublereal
#undef logical

#define FOR_RETURN int
#define RETURN     return 0
#define FTNLEN     ftnlen
#include "f2c.h"

#define ftcl_get_int            ftcl_get_int__
#define ftcl_get_arg_int        ftcl_get_arg_int__
#define ftcl_get_real           ftcl_get_real__
#define ftcl_get_arg_real       ftcl_get_arg_real__
#define ftcl_get_double         ftcl_get_double__
#define ftcl_get_arg_double     ftcl_get_arg_double__
#define ftcl_get_string         ftcl_get_string__
#define ftcl_put_int            ftcl_put_int__
#define ftcl_put_real           ftcl_put_real__
#define ftcl_put_double         ftcl_put_double__
#define ftcl_put_string         ftcl_put_string__
#define ftcl_set_result_real    ftcl_set_result_real__
#define ftcl_exec               ftcl_exec__
#define ftcl_script             ftcl_script__
#define ftcl_start              ftcl_start__
#define ftcl_init_log           ftcl_init_log__
#define ftcl_main_loop          ftcl_main_loop__
#define ftcl_make_command       ftcl_make_command__

#undef  FORTRAN_START_NAME
#define FORTRAN_START_NAME  FORTRAN_START_DBL_UNDER

#endif /* G77 */

/* HPUX - HP workstations */
#ifdef __hpux

#undef IN_BETWEEN

#endif /* HPUX */

/* SUN - workstations */
#ifdef __sun
#include <macros.h>

#undef IN_BETWEEN
#define ftcl_get_int            ftcl_get_int_
#define ftcl_get_arg_int        ftcl_get_arg_int_
#define ftcl_put_int            ftcl_put_int_
#define ftcl_get_real           ftcl_get_real_
#define ftcl_get_string         ftcl_get_string_
#define ftcl_get_arg_real       ftcl_get_arg_real_
#define ftcl_put_real           ftcl_put_real_
#define ftcl_get_double         ftcl_get_double_
#define ftcl_get_arg_double     ftcl_get_arg_double_
#define ftcl_put_double         ftcl_put_double_
#define ftcl_put_string         ftcl_put_string_
#define ftcl_set_result_real    ftcl_set_result_real_
#define ftcl_exec               ftcl_exec_
#define ftcl_script             ftcl_script_
#define ftcl_start              ftcl_start_
#define ftcl_init_log           ftcl_init_log_
#define ftcl_main_loop          ftcl_main_loop_
#define ftcl_make_command       ftcl_make_command_

#undef  FORTRAN_START_NAME
#define FORTRAN_START_NAME  FORTRAN_START_UNDERSCORE

#endif /* SUN */

/* Compaq Visual Fortran (under MS Windows) */
#ifdef WIN32

#undef EXPORT_FUNC
#undef IN_BETWEEN
#undef FOR_CALL
#undef FOR_RETURN
#undef RETURN
#undef FTNLEN
#undef integer
#undef real
#undef doublereal
#undef logical

#define EXPORT_FUNC __declspec(dllexport)
#define IN_BETWEEN
#define FOR_CALL   _stdcall
#define FOR_RETURN void
#define RETURN     return
#define FTNLEN     int
#define integer    long int
#define real       float
#define doublereal double
#define logical    long int

#define ftcl_get_int            FTCL_GET_INT
#define ftcl_get_arg_int        FTCL_GET_ARG_INT
#define ftcl_put_int            FTCL_PUT_INT
#define ftcl_get_real           FTCL_GET_REAL
#define ftcl_get_arg_real       FTCL_GET_ARG_REAL
#define ftcl_put_real           FTCL_PUT_REAL
#define ftcl_get_double         FTCL_GET_DOUBLE
#define ftcl_get_string         FTCL_GET_STRING
#define ftcl_put_string         FTCL_PUT_STRING
#define ftcl_get_arg_double     FTCL_GET_ARG_DOUBLE
#define ftcl_put_double         FTCL_PUT_DOUBLE
#define ftcl_set_result_real    FTCL_SET_RESULT_REAL
#define ftcl_exec               FTCL_EXEC
#define ftcl_script             FTCL_SCRIPT
#define ftcl_start              FTCL_START
#define ftcl_init_log           FTCL_INIT_LOG
#define ftcl_main_loop          FTCL_MAIN_LOOP
#define ftcl_make_command       FTCL_MAKE_COMMAND

#undef  FORTRAN_START_NAME
#define FORTRAN_START_NAME  FORTRAN_START_ALLCAPS

#endif

#ifdef Absoft
#define ftcl_get_int            FTCL_GET_INT
#define ftcl_get_arg_int        FTCL_GET_ARG_INT
#define ftcl_put_int            FTCL_PUT_INT
#define ftcl_get_real           FTCL_GET_REAL
#define ftcl_get_arg_real       FTCL_GET_ARG_REAL
#define ftcl_put_real           FTCL_PUT_REAL
#define ftcl_get_double         FTCL_GET_DOUBLE
#define ftcl_get_string         FTCL_GET_STRING
#define ftcl_put_string         FTCL_PUT_STRING
#define ftcl_get_arg_double     FTCL_GET_ARG_DOUBLE
#define ftcl_put_double         FTCL_PUT_DOUBLE
#define ftcl_set_result_real    FTCL_SET_RESULT_REAL
#define ftcl_exec               FTCL_EXEC
#define ftcl_script             FTCL_SCRIPT
#define ftcl_start              FTCL_START
#define ftcl_init_log           FTCL_INIT_LOG
#define ftcl_main_loop          FTCL_MAIN_LOOP
#define ftcl_make_command       FTCL_MAKE_COMMAND
#endif

/* Prototypes
*/
EXPORT_FUNC int Ftcl_Init(
   Tcl_Interp *interp ) ;

FOR_RETURN FOR_CALL ftcl_get_arg_int (
   integer *iarg    ,
   integer *intval  ) ;

FOR_RETURN FOR_CALL ftcl_get_int (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   integer *intval
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_put_int (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   integer *intval
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_get_arg_real (
   integer *iarg    ,
   real    *value   ) ;

FOR_RETURN FOR_CALL ftcl_get_real (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   real    *realval
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_put_real (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   real    *realval
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_set_result_real (
   real    *realval
                    ) ;

FOR_RETURN FOR_CALL ftcl_get_arg_double (
   integer     *iarg    ,
   doublereal  *value   ) ;

FOR_RETURN FOR_CALL ftcl_get_double (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   doublereal *doubleval
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_put_double (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   doublereal *doubleval
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_get_arg_log (
   integer     *iarg    ,
   logical     *value   ) ;

FOR_RETURN FOR_CALL ftcl_get_log (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   logical *logval
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_put_log (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   logical *logval
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_get_arg_string (
   integer     *iarg    ,
   char        *value
  ,FTNLEN   length      ) ;

FOR_RETURN FOR_CALL ftcl_get_string (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   char    *value
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
  ,FTNLEN   lenval
                    ) ;

FOR_RETURN FOR_CALL ftcl_put_string (
   char    *varname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   char    *value
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
  ,FTNLEN   lenval
                    ) ;


FOR_RETURN FOR_CALL ftcl_exec (
   char    *service ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   integer *no_args ,
   integer *ierror
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_script (
   char    *script
  ,FTNLEN   length
                    ) ;

FOR_RETURN FOR_CALL ftcl_start (
   char    *script
  ,FTNLEN   length
                    ) ;

FOR_RETURN FOR_CALL ftcl_main_loop (
   void
                    ) ;

typedef FOR_RETURN (FOR_CALL *FortProc)(
   char    *cmdname ,
#ifdef IN_BETWEEN
   FTNLEN   length  ,
#endif
   integer *no_args ,
   integer *ierror
#ifndef IN_BETWEEN
  ,FTNLEN   length
#endif
                    ) ;

FOR_RETURN FOR_CALL ftcl_make_command (
   FortProc  procedure,
   char     *cmdname
  ,FTNLEN    length
                    ) ;

/* End of file ftcl.h */
