#include <bzlib.h>
#include <tcl.h>

// CONSIDER bzUnZip infile outfile - copy to new file with no
//  need for huge buffer.

char *bzLiteReadfilecmd (int *status, char* fileName ) {

    FILE*   f;
    BZFILE* b;

    char *outbuf;
    int byteCount, out, bzerror, nBuf, chunkSize, bufSize;
    char *returnCharPtr;
    
    byteCount = 0;
    *status=TCL_OK;

    outbuf = (char *)malloc(20000);
    returnCharPtr = (char *)ckalloc(20000);
    bufSize = chunkSize = 20000;

    f = fopen ( fileName, "rb");
    if (!f) {
       /* handle error */
        sprintf(returnCharPtr, "Failed to open file ''%s''", fileName);
	*status = TCL_ERROR;
	goto done;
    }

    b = BZ2_bzReadOpen ( &bzerror, f, 0, 0, NULL, 0 );

    if (bzerror != BZ_OK) {
       BZ2_bzReadClose ( &bzerror, b );
       /* handle error */
        sprintf(returnCharPtr, "BZOpen Failed to open file ''%s'' (%d)", \
	    fileName, bzerror);
	*status = TCL_ERROR;
	goto done;
    }
    
    bzerror = BZ_OK;

    while (bzerror == BZ_OK ) {
      while (((byteCount +20000) < bufSize) && (bzerror == BZ_OK)) {
         nBuf = BZ2_bzRead (&bzerror, b, outbuf, 20000);
         if (bzerror == BZ_OK) {
           memcpy(&returnCharPtr[byteCount], outbuf, nBuf);
           byteCount += nBuf;
         }
       }
          // printf("to realloc: %d - chunk: %d\n", bufSize+chunkSize, chunkSize); fflush(stdout);
          returnCharPtr = (char *)ckrealloc(returnCharPtr, byteCount + chunkSize);
          // printf("post realloc: %xx\n", returnCharPtr); fflush(stdout);
         bufSize = chunkSize = bufSize + chunkSize;
 	 if (chunkSize > 5000000) {chunkSize = 5000000;}
 	 if (returnCharPtr == NULL) {
	   returnCharPtr = "Failed to realloc!"; 
           goto done;
         }
    }


    if ((bzerror != BZ_STREAM_END) && (bzerror != BZ_OK)) {
       BZ2_bzReadClose ( &bzerror, b );
       /* handle error */
        sprintf(returnCharPtr, "BZRead Failed during processing, errno: (%d)", \
	    bzerror);
	*status = TCL_ERROR;
	goto done;
    } else {
       memcpy(&returnCharPtr[byteCount], outbuf, nBuf);
       byteCount += nBuf;
       BZ2_bzReadClose ( &bzerror, b );
    }
done:
    free (outbuf);
    return (returnCharPtr);
}

