/*
 * bztclLiteInit.c --
 * Copyright (c) 1997 Clif Flynt
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL Clif Flynt BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Clif Flynt SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND Clif Flynt HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*/
// Include the usual suspects.

#include "stdlib.h"
#include "ctype.h"
#include "bztclLiteInt.h"

#define TRUE 1
#define FALSE 0
#define streq(x,y)   (0 == strcmp((x),(y)))
int exp_tcl_debugger_available;

#ifdef INCLUDE_DEBUG
static int Exp_DebugCmd(ClientData, Tcl_Interp *, int, char **);
#endif

#define BZTCLLITE_INIT_REVISION "$Revision: 1.1.1.1 $"

/* If bztclLiteDebugPrint != 0, then debugprt will print debugging info */
/*   This value is set with the default subcommand function debug   */
extern int bztclLiteDebugPrint;

/*
// These are the segments that need to be declared in the "C" namespace
// These function names and data will be accessed by programs in the
// Tcl "C" language library.
//   To compile with a C++ compiler, remove the comments around 
//   the 'extern "C"', and the associated {}
*/

/*
extern "C" {
*/

/*
 *----------------------------------------------------------------------   
 *
 * DllEntryPoint --
 *
 *      This wrapper function is used by Windows to invoke the
 *      initialization code for the DLL.  If we are compiling
 *      with Visual C++, this routine will be renamed to DllMain.
 *      routine.
 *
 * Results:
 *      Returns TRUE;
 * 
 * Side effects:
 *      None.
 * 
 *----------------------------------------------------------------------
 */
 
#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst;            /* Library instance handle. */
    DWORD reason;               /* Reason this function is being called. */
    LPVOID reserved;            /* Not used. */
{
    return TRUE;
}
#endif

/*
 *----------------------------------------------------------------------
 *
 * bztclLite_Init
 *
 *      Called from bztclLite_AppInit() if this is a standalone shell, 
 *      or when the package is loaded if compiled into a binary package.
 *   
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      Creates a hash table.
 *      Adds new commands
 *      Creates new Tcl global variables for bztclLite_version and 
 *          bztclLiteInit_revision.
 * 	
 *----------------------------------------------------------------------
  */

  int Bztcllite_Init(Tcl_Interp *interp) {
    /*  interp        Current interpreter. */

    /* Check for stubs, if supported. */

    if (Tcl_InitStubs(interp, "8.1", 0) == NULL) {
        printf("INIT STUB FAILED\n");
        return TCL_ERROR;
    }    

    /*
     * Call Tcl_CreateCommand for commands defined by this extension
     */

    Tcl_CreateObjCommand(interp, "bzLite", bztclLite_Cmd, (ClientData) NULL, NULL);

    /*
     * Define the package for pkg_mkIndex to index 
     */
     
    Tcl_PkgProvide(interp, "bztclLite", BZTCLLITE_VERSION);
    
    /*
     * Define the version for this package
     */

    Tcl_SetVar((Tcl_Interp *) interp, "bztclLite_version", BZTCLLITE_VERSION,
            TCL_GLOBAL_ONLY);
    
    /*
     * Not a requirement.  I like to include the source code revision.
     * It can make it easier to track bugs when you can track all the
     * revisions of all the files in a release.
     */

    Tcl_SetVar((Tcl_Interp *) interp, "bztclLiteInit_revision", BZTCLLITE_INIT_REVISION,
            TCL_GLOBAL_ONLY);

    return TCL_OK;
  }

#ifdef INCLUDE_DEBUG
static int
Exp_DebugCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
	int now = FALSE;	/* soon if FALSE, now if TRUE */
	int exp_tcl_debugger_was_available = exp_tcl_debugger_available;

	if (argc > 3) goto usage;

	if (argc == 1) {
		sprintf(interp->result,"%d",exp_tcl_debugger_available);
		return TCL_OK;
	}

	argv++;

	while (*argv) {
		if (streq(*argv,"-now")) {
			now = TRUE;
			argv++;
		}
		else break;
	}

	if (!*argv) {
		if (now) {
			Dbg_On(interp,1);
			exp_tcl_debugger_available = 1;
		} else {
			goto usage;
		}
	} else if (streq(*argv,"0")) {
		Dbg_Off(interp);
		exp_tcl_debugger_available = 0;
	} else {
		Dbg_On(interp,now);
		exp_tcl_debugger_available = 1;
	}
	sprintf(interp->result,"%d",exp_tcl_debugger_was_available);
	return(TCL_OK);
 usage:
	printf("usage: [[-now] 1|0]");
	return TCL_ERROR;
}
#endif

/*
}
*/


