/*
 * bztclLiteInt.h --
 *
 *      Declarations used by the bztclLitetcl extension
 *
 * Copyright (c) 1997 Clif Flynt
 *
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a 
 * DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: $Log:
 */

#ifndef _bztclLiteINT
#define _bztclLiteINT

/* 
 * Declare the #includes that will be used by this extension
 */

/* Uncomment this if compiling with C++ compiler */
/***
extern "C" {
***/
#include "tcl.h"
#include "bzlib.h"

/***
}
***/

// #include <tcl.h>
#include <string.h>
/* #include <sys/utsname.h> */
/* #include <iostream.h> */

  
/*
 * Define the major and minor version numbers.
 * Note: VERSION is defined as a string, not integers.
 *       MAJOR and MINOR are defined as integers.
 */

#define BZTCLLITE_VERSION	"1.1"
#define BZTCLLITE_MAJOR_VERSION	1
#define BZTCLLITE_MINOR_VERSION	1

/*   
 * VC++ has an alternate entry point called DllMain, so we 
 * need to rename our entry point.
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN
#   if defined(_MSC_VER)
#       define EXPORT(a,b) __declspec(dllexport) a b
#       define DllEntryPoint DllMain
#   else
#       if defined(__BORLANDC__)
#           define EXPORT(a,b) a _export b
#       else
#           define EXPORT(a,b) a b
#       endif
#   endif
#else
#   define EXPORT(a,b) a b
#endif


/*
 *  The CmdReturn structure is used by the subroutines to 
 *   pass back a success/failure code and a Tcl_Obj result.
 *      
 *  This is not an official Tcl standard return type. I 
 *  find this works well with commands that accept subcommands.
 */

typedef struct cmd_return {
  int	status;
  Tcl_Obj *object;
} CmdReturn;

/*
 * A structure to use as ClientData to pass special information
 *  to the functions that will implement Tcl commands.
 * This should be stuffed in the primary command entry point 
 *  function.
*/ 

typedef struct program_info {
    /* Data to be passed to sub-programs */
    int 	dummyInt;
    char	*dummyString;
} programInfo;


/*
 * Function Prototypes for the commands that actually do the 
 *   processing.
 * Two macros are used in these prototypes:
 *
 * EXTERN EXPORT is for functions that must interact with the
 *     Microsoft or Borland C++ DLL loader.
 * ANSI_ARGS is defined in tcl.h
 *     ANSI_ARGS returns an empty string for non-ANSI C 
 *     compilers, and returns it's arguments for ANSI C 
 *     compilers.
 */


/***
extern "C" {
***/

EXTERN EXPORT(int,bztclLite_AppInit) _ANSI_ARGS_ ((Tcl_Interp *));
EXTERN EXPORT(int,bztclLite_Init) _ANSI_ARGS_ ((Tcl_Interp *));
EXTERN EXPORT(int,bztclLite_Cmd) _ANSI_ARGS_ 
        ((ClientData, Tcl_Interp *, int, Tcl_Obj * CONST *));

/***
  }
***/

CmdReturn *bztclLite_CompressCmd _ANSI_ARGS_ ((ClientData, 
        Tcl_Interp *, int, Tcl_Obj * CONST *));
CmdReturn *bztclLite_UncompressCmd _ANSI_ARGS_ ((ClientData, 
        Tcl_Interp *, int, Tcl_Obj * CONST *));

unsigned char *bztclLite_DecompressBuffer _ANSI_ARGS_ ((
      unsigned char *, int , int *));

/* 
 * For debuging printf's.
 */

#define debugprt	if (bztclLiteDebugPrint>0) printf

#endif
/* End _bztclLiteINT */

