#define MEMFILE_REVISION "$Revision: 1.1.1.1 $"
#define DBGPRINT printf

#if defined (_WIN32)
#include <windows.h>
#endif

#include "stdlib.h"
#include <stdio.h>
#include "ctype.h"
#include <stdio.h>
#include "memFile.h"
#include "bzlib.h"
#include <errno.h>

#if defined (_WIN32)^M
#include "tkWin.h"
#else
#include <dlfcn.h>
#include "tk.h"
#endif

#if defined (_WIN32)
#else
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#endif


Tcl_ChannelType *makeChannelTypeStructure();

Tcl_HashTable *memFile_hashtablePtr;

extern Tcl_Filesystem memFileSystem;

 /*----------------------------------------------------------------------
 *
 * memFile_Init
 *
 *      Called from memFile_AppInit() if this is a standalone shell, 
 *      or when the package is loaded if compiled into a binary package.
 *   
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      Creates a hash table.
 *      Adds new commands
 *      Creates new Tcl global variables for memFile_version and 
 *          memFileInit_revision.
 * 	
 *----------------------------------------------------------------------
  */

int Memfile_Init (Tcl_Interp *interp) {
    /*  interp        Current interpreter. */
    
    /*
     * Call Tcl_CreateCommand for commands defined by this extension
     */

    Tcl_CreateObjCommand(interp, "memFile::open", 
        (Tcl_ObjCmdProc *) memFile_openCmd, (ClientData) NULL, NULL);
    Tcl_CreateObjCommand(interp, "memFile::listFiles", 
        (Tcl_ObjCmdProc *) memFile_listFilesCmd, (ClientData) NULL, NULL);
    Tcl_CreateObjCommand(interp, "memFile::globFiles", 
        (Tcl_ObjCmdProc *) memFile_MatchCmd, (ClientData) NULL, NULL);
    Tcl_CreateObjCommand(interp, "memFile::mount", 
        (Tcl_ObjCmdProc *) memFile_MountCmd, (ClientData) NULL, NULL);
    
    /*
     * Define the package for pkg_mkIndex to index 
     */
     
    Tcl_PkgProvide(interp, "memfile", MEMFILE_VERSION);
    
    /*
     * Define the version for this package
     */

    Tcl_SetVar((Tcl_Interp *) interp, "memfile_version", MEMFILE_VERSION,
            TCL_GLOBAL_ONLY);

    Tcl_SetVar((Tcl_Interp *) interp, "memfile_InitRevision", MEMFILE_REVISION,
            TCL_GLOBAL_ONLY);

    memFile_hashtablePtr = (Tcl_HashTable *) ckalloc(sizeof(Tcl_HashTable));
    Tcl_InitHashTable(memFile_hashtablePtr, TCL_STRING_KEYS);
    
    Tcl_FSRegister((ClientData) NULL, &memFileSystem);
//    Tcl_FSMountsChanged(&memFileSystem);
    return TCL_OK;
  }
