#define MEMFILE_REVISION "$Revision: 1.5 $"

#define DBGPRINT //
//#define DBGPRINT printf

#if defined (_WIN32)
#include <windows.h>
#endif

#include "stdlib.h"
#include <stdio.h>
#include "ctype.h"
#include <stdio.h>
#include "memFile.h"
#include "bzlib.h"
#include <errno.h>

#if defined (_WIN32)^M
#include "tkWin.h"
#else
#include <dlfcn.h>
#include "tk.h"
#endif

#if defined (_WIN32)
#else
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#endif

Tcl_ChannelType *makeChannelTypeStructure();

int memFileID = 0;
// Holds instance data for open files - keys like memFile0, memFile1
//  and mounted file systems - keys like /mem - note first character is slash.

extern Tcl_HashTable *memFile_hashtablePtr;

/*------------------------------------------------------------------------
* int memFile_PathInFilesystem (Tcl_Obj *pathPtr, ClientData *clientDataPtr)--
*   Checks if a path is within a memory file system
* Arguments:
*   pathPtr	Pointer to Tcl_Obj with path to check
*   clientDataPtr	Not Used
* 
* Results:
*    Returns TCL_OK if path is within a memFile file system.
*    else returns -1
* 
* Side Effects:
*   NONE
------------------------------------------------------------------------*/
int memFile_PathInFilesystem (Tcl_Obj *pathPtr, ClientData *clientDataPtr) {
    char *path;
    char cwd[80];
    Tcl_HashEntry *hashEntry;

    
    DBGPRINT("LOCAL: %s\n", Tcl_GetString(pathPtr));
    path = Tcl_GetString(pathPtr);

    hashEntry = MemFile_getMemFileData(path, cwd);
    if (hashEntry == NULL) {
      // No match, we're happy
      DBGPRINT("RETURN NOT OK\n");
      return -1;
    } else {
      // Match, we're happy
      DBGPRINT("RETURN OK\n");
      return TCL_OK;
    }
};

/*------------------------------------------------------------------------
* ClientData memFile_DupInternalRep ()--
*    Dummy Function.  Functionality not Implemented
* Arguments:
*   Undefined
* 
* Results:
*   Returns nothing
* 
* Side Effects:
*   NONE
------------------------------------------------------------------------*/
ClientData memFile_DupInternalRep () {
  DBGPRINT("memFile_DupInternalRep \n");
};

/*------------------------------------------------------------------------
* void memFile_FreeInternalRep ()--
*    Dummy Function.  Functionality not Implemented
* Arguments:
*   Undefined
* 
* Results:
*   Returns nothing
* 
* Side Effects:
*   NONE
------------------------------------------------------------------------*/
void memFile_FreeInternalRep () {
  DBGPRINT("memFile_FreeInternalRep \n");
};

/*------------------------------------------------------------------------
* int memFile_Utime ()--
*    Dummy Function.  Functionality not Implemented
* Arguments:
*   Undefined
* 
* Results:
*   Returns nothing
* 
* Side Effects:
*   NONE
------------------------------------------------------------------------*/
int memFile_Utime () {
  DBGPRINT("memFile_Utime \n");
};

/*------------------------------------------------------------------------
* const char **memFile_FileAttrStrings ()--
*    Dummy Function.  Functionality not Implemented
* Arguments:
*   Undefined
* 
* Results:
*   Returns nothing
* 
* Side Effects:
*   NONE
------------------------------------------------------------------------*/
const char **memFile_FileAttrStrings () {
   DBGPRINT("memFile_FileAttrStrings\n");
};

/*------------------------------------------------------------------------
* int memFile_FileAttrGet ()--
*    Dummy Function.  Functionality not Implemented
* Arguments:
*   Undefined
* 
* Results:
*   Returns nothing
* 
* Side Effects:
*   NONE
------------------------------------------------------------------------*/
int memFile_FileAttrGet () {
  DBGPRINT("memFile_FileAttrGet \n");
};

/*------------------------------------------------------------------------
* int memFile_FileAttrSet ()--
*    Dummy Function.  Functionality not Implemented
* Arguments:
*   Undefined
* 
* Results:
*   Returns nothing
* 
* Side Effects:
*   NONE
------------------------------------------------------------------------*/
int memFile_FileAttrSet () {
  DBGPRINT("memFile_FileAttrSet \n");
};



/*------------------------------------------------------------------------
* Tcl_Obj *memFile_FilesystemPathType ()--
*    Report the type of filesystem
* Arguments:
*   NONE
* 
* Results:
*   Returns a Tcl_Obj with a pointer to the string "memFile"
* 
* Side Effects:
*   New Tcl_Obj is created with 0 references.
------------------------------------------------------------------------*/
Tcl_Obj *memFile_FilesystemPathType () {
  Tcl_Obj *retObj;
  DBGPRINT("*memFile_FilesystemPathType \n");
  retObj = Tcl_NewStringObj("memFile", -1);
  Tcl_IncrRefCount(retObj);
  return retObj;
};


/*------------------------------------------------------------------------
* Tcl_Obj *memFile_FileSystemSeparator ()--
*    Report the separator directories in this filesystem
* Arguments:
*   NONE
* 
* Results:
*   Returns a Tcl_Obj with a pointer to the string "memFile"
* 
* Side Effects:
*   New Tcl_Obj is created with 0 references.
------------------------------------------------------------------------*/
Tcl_Obj *memFile_FileSystemSeparator () {
  Tcl_Obj *retObj;
  DBGPRINT("*memFile_FileSystemSeparator \n");
  retObj = Tcl_NewStringObj("/", -1);
  Tcl_IncrRefCount(retObj);
  return retObj;
};

/*------------------------------------------------------------------------
* int memFile_Stat (Tcl_Obj *pathPtr, Tcl_StatBuf *statPtr)--
*   INCOMPLETE
*    Return file stat info
* Arguments:
*   pathPtr	Tcl_Obj with pointer to path to report
*   statPtr	Tcl_Obj with pointer to status buffer
* 
* Results:
*   Returns TCL_OK, ?TCL_ERROR if path not exist?
* 
* Side Effects:
*   INCOMPLETE
------------------------------------------------------------------------*/
int memFile_Stat (Tcl_Obj *pathPtr, Tcl_StatBuf *statPtr) {
    char *path;
    // Return OK as long as it's in our path
    path = Tcl_GetString(pathPtr);
    DBGPRINT("memFile_Stat%s\n", path);
  // Not implemented yet, add info to stuff struct, and return 0
  return TCL_OK;
};

/*------------------------------------------------------------------------
* int memFile_Access (Tcl_Obj *pathPtr, int mode)--
*    Can this file be accessed by this user
* Arguments:
*   pathPtr	Tcl_Obj with pointer to path to report
*   mode	The desired mode of access
* 
* Results:
*   Returns TLC_OK if path is within memory file system.
* 
* Side Effects:
*   NONE
------------------------------------------------------------------------*/
int memFile_Access (Tcl_Obj *pathPtr, int mode) {
    char *path;
    char cwd[80];
    memFileData **memStruct;
    Tcl_HashEntry *hashEntryPtr;

    // Return OK as long as it's in our path

    path = Tcl_GetString(pathPtr);

  hashEntryPtr = MemFile_getMemFileData(path, cwd);

    DBGPRINT("memFile_Access %s (%xx)\n", path, hashEntryPtr);

  if (hashEntryPtr == NULL) {
    return -1;
  }

  memStruct = (memFileData **) Tcl_GetHashValue(hashEntryPtr);

  path+=strlen(cwd);

  if (memFile_getPathIndex(memStruct, path) >= 0) {
      // Match, we're happy
      return TCL_OK;
    } else {
      // No match, we're happy enough
      return -1;
    }
};

/*------------------------------------------------------------------------
* tcl_hashEntry *MemFile_getMemFileData(char *path, char *cwd)--
*    Returns a pointer to the memory data structure that matches the
*    mount point (first directory) in path.
*
* Arguments:
*   path	Pointer to the file path string "/foo/bar" or maybe "/foo"
*   cwd		Pointer to an empty string to hold/return the current working dir.
* 
* Results:
*   Returns NULL or a pointer to a Tcl_hashEntry
* 
* Side Effects:
*   
------------------------------------------------------------------------*/
Tcl_HashEntry *MemFile_getMemFileData(char *path, char *cwd) {
  memFileData **memStruct;  
  char *tmpStr;

  strcpy(cwd, path);
  tmpStr = index(&cwd[1], '/');
  if (tmpStr != NULL) {
    *tmpStr = 0;
  }
  DBGPRINT("MemFile_getMemFileData %s (%xx) %s (%xx) \n", path, path, cwd, cwd);

  // cwd is now the first part of the path - which should be the key for
  //  this mounted filesystem.
  
  return Tcl_FindHashEntry(memFile_hashtablePtr, cwd);

}


/*------------------------------------------------------------------------
* int memFile_getPathIndex(  memFileData **memStruct, char *path)--
*    Returns the index into the memStruct for path
* Arguments:
*   memStruct	Pointer to array of memory file structures 
*   path	pointer to path in memory file - just path, no mount info
* Results:
*   Returns value >=0 if found, -1 if not found
* 
* Side Effects:
*   None
*
------------------------------------------------------------------------*/
int memFile_getPathIndex(  memFileData **memStruct, char *path) {
  int i, len;
  char *cwd[80];
  Tcl_HashEntry *hashEntryPtr;

  i=0;
  len = strlen(path);
  
  while (memStruct[i] != 0) {
    if (strncmp(path, memStruct[i]->name, len) == 0) {
      DBGPRINT("HIT at %d\n", i);
      break;
    }
    i++;
  }
  
  if (memStruct[i] == 0) {
    return -1;
  }
  return i;
}

/*------------------------------------------------------------------------
* Tcl_Channel memFile_OpenFileChannel (Tcl_Interp *interp, Tcl_Obj *pathPtr, int mode, int perms)--
*    Open a channel to a file in the memFile system
* Arguments:
*   interp	Tcl_Interp pointer, for use in returning errors, 
*   pathPtr	Tcl_Obj with pointer to path to report
*   mode	Read/write, etc: Only read access allowd, but not tested
*   perms	Permissions for file to be created - not used.
* 
* Results:
*   Returns new channel structure for an open channel to this file.
* 
* Side Effects:
*   New instance structure also created - destroyed in close.
------------------------------------------------------------------------*/
Tcl_Channel memFile_OpenFileChannel (Tcl_Interp *interp, Tcl_Obj *pathPtr, 
      int mode, int perms) {
  InstanceData *instanceData;

  Tcl_Channel newChannel;
  char channelName[30];
  char *hashName;
  Tcl_ChannelType *channelType;
  Tcl_HashEntry *hashEntryPtr, *tmpEntryPtr;
  int isNew, i;
  char *path, cwd[80];
  unsigned char *decompressedData;
  int byteCount;
  memFileData **memStruct;  

DBGPRINT("memFile_OpenFileChannel \n");

   path = Tcl_GetStringFromObj(pathPtr, NULL);

DBGPRINT("To open: %s\n", path);
//  if (strncmp("/mem", path, 4) == 0) {
//    path += 4;
//    DBGPRINT("RESET PATH TO: ..%s..\n", path);
//  }
  
  hashEntryPtr = MemFile_getMemFileData(path, cwd);
  if (hashEntryPtr == NULL) {
    char msg[80];
    // SET Errnumber
    Tcl_SetErrno(ENOENT);
    sprintf(msg, "%s does not exist", path);
    Tcl_AddErrorInfo(interp, msg);
    return NULL;
  }

  memStruct = (memFileData **) Tcl_GetHashValue(hashEntryPtr);

  path+=strlen(cwd);

  i = memFile_getPathIndex(memStruct, path);

  if (i < 0) {
    char errString[80];
    sprintf(errString, "couldn't open \"%s\" no such element in memlist\n", path);
    Tcl_AddErrorInfo(interp, errString);
    Tcl_AppendResult(interp, "couldn't open \"", path, "\" no such element in memlist\n", (char *) NULL);
    printf("couldn't open \"%s\" no such element in memlist\n", path);

    return NULL;
  }
  
  channelType = (Tcl_ChannelType *)makeChannelTypeStructure();
  sprintf(channelName, "%s%d", "memFile", memFileID++);
  DBGPRINT("PATH: %s CHAN: %s\n", Tcl_GetStringFromObj(pathPtr, NULL), channelName);
  tmpEntryPtr = Tcl_FindHashEntry(memFile_hashtablePtr, channelName);

  if (tmpEntryPtr == (Tcl_HashEntry *) NULL) {
    instanceData = (InstanceData *)ckalloc(sizeof(InstanceData));
  } else {
    Tcl_AddErrorInfo(interp, "Already exists");
    return NULL;
  }
  
  hashEntryPtr = Tcl_CreateHashEntry(memFile_hashtablePtr, channelName, &isNew);
  Tcl_SetHashValue(hashEntryPtr, instanceData);
  
  DBGPRINT("CREATING: %s \n", channelName);

  newChannel = Tcl_CreateChannel(channelType, channelName, 
				 (ClientData) instanceData, TCL_READABLE);
  
  //  Tcl_RegisterChannel(interp, newChannel);

  decompressedData = memFile_DecompressBuffer(memStruct[i]->data, memStruct[i]->dataLen, &byteCount);

  DBGPRINT("BYTES: %d\n", byteCount);

  instanceData->id=12345;
  instanceData->tclReadChannel=newChannel;
  instanceData->readBuffer=decompressedData;
  instanceData->readLen = byteCount;
  instanceData->readOffset = 0;
//  Tcl_AppendResult(interp, channelName, (char *) NULL);
		
  return newChannel;
};



/*------------------------------------------------------------------------
* int MemFile_PathIsInList (Tcl_Obj *listObj, char *path)--
*   Test if a path is a member of a list of paths.  Used to prevent
*     multiple entries in globbing (MatchInDirectory) code return
* Arguments:
*   listObj	A Tcl list of file paths.
*   path	The path to search for
* Results:
*    Returns 1 if path is within a list of paths, else 0
* 
* Side Effects:
*   
------------------------------------------------------------------------*/
int MemFile_PathIsInList (Tcl_Obj *listObj, char *path) {
  int k, listLen, strLen;
  Tcl_Obj *tmpObj;
  char *tmpPtr, tmpStr[200], pathStr[200];
  
    strcpy(pathStr, path);
    strLen = strlen(pathStr);
    strLen --;
    if (pathStr[strLen] == '/') {
      pathStr[strLen] = 0;
    }


    Tcl_ListObjLength(NULL, listObj, &listLen);

    for (k=0; k < listLen; k++) {
      Tcl_ListObjIndex(NULL, listObj, k, &tmpObj);
      tmpPtr = Tcl_GetStringFromObj(tmpObj, &strLen);
      strcpy(tmpStr, tmpPtr);
      strLen --;
      if (tmpStr[strLen] == '/') {
	  tmpStr[strLen] = 0;
      }

      if (!strcmp(pathStr, tmpStr)) {
        DBGPRINT("SET MATCHED\n");
        return 1;
      }
    }
    return 0;
}

/*------------------------------------------------------------------------
* int memFile_MatchInDirectory (Tcl_Interp *interp, Tcl_Obj *resultObj--
*    Implements the globbing function
* Arguments:
* interp	Pointer to Tcl_Interp
* resultObj	Pointer to Tcl_Obj to hold results
* pathPtr  	base path to find patterns in
* pattern	pattern
* types		Types of file items to search for 
*                  Dir and File are only valid types for memFiles
* 
* Results:
*   Returns TCL_OK if any matches found, else TCL_ERROR
*   Fills a list object for the return
* 
* Side Effects:
*   New Tcl_List Object and Tcl_Objects for strings created.
------------------------------------------------------------------------*/
int memFile_MatchInDirectory (Tcl_Interp *interp, Tcl_Obj *resultObj, 
    Tcl_Obj *pathPtr,  char *pattern, Tcl_GlobTypeData *types) {
  char *path;
  char pathPtn[300], name[300], cwdName[300];
  int i, j, pathPtnLen, pathSlashCount, pos, slashCount;
  char *tmpStr;
  int k, newKey, listLen, *tmpObj, matched;
  Tcl_Obj *listobj, *strObj, *args[3], *tclRslt;
  Tcl_GlobTypeData myTypes;
  int terminalSlash = 0;
  memFileData **memStruct;  
  char cwd[80];
  Tcl_HashEntry *hashEntryPtr;
  
  // Types can be == NULL if there is no -types in the glob command.
  // In that case, match to any valid type - file and dir for this
  if (types == NULL) {
    types = &myTypes;
    myTypes.type = TCL_GLOB_TYPE_FILE | TCL_GLOB_TYPE_DIR;
  }

  path = Tcl_GetStringFromObj(pathPtr, NULL);
  DBGPRINT("memFile_MatchInDirectory PATH: %s INT: %xx %xx RES: %xx \n", path, interp, types, resultObj);

  hashEntryPtr = MemFile_getMemFileData(path, cwd);

  // cwd is now the first part of the path - which should be the key for
  //  this mounted filesystem.

  if (hashEntryPtr == (Tcl_HashEntry *) NULL) {
        char errString[80];
	Tcl_Obj *errCodePtr;

	/* 
	 * Define an error code from an integer, and set errorCode.
	 */
	if (interp != NULL) {
  	  errCodePtr = Tcl_NewIntObj(554);
	  Tcl_SetObjErrorCode(interp, errCodePtr);
	
	/* 
	 * This string will be placed in the global variable errorInfo
	 */
	
	  sprintf(errString, "Mount Point \"%s\" does not exist.", cwd);
          Tcl_AddErrorInfo(interp, errString);
	}
DBGPRINT("NOT FIND %s (%s) in mem filesystem\n", cwd, path);	
	return  TCL_ERROR;
    }

  memStruct = (memFileData **) Tcl_GetHashValue(hashEntryPtr);

  DBGPRINT("To search: %s for %s of type %d\n", path, pattern, types->type);
  
  if (types->type == TCL_GLOB_TYPE_MOUNT) {
//    strObj = Tcl_NewStringObj("/mem", -1);
//    Tcl_ListObjAppendElement(interp, resultObj, strObj);
//    DBGPRINT("APPENDING: %s\n", "/mem");
    return TCL_OK;
  }

  // Return files and directories - we don't have anything else in
  // a mem file.

  if ((types->type & 0x0c) == 0) {
    DBGPRINT("RETURNING EARLY - %d\n", types->type);
    return TCL_OK;
  }

  if (pattern == NULL) {
    sprintf(pathPtn, "%s", &path[strlen(cwd)], pattern);
  } else{
    if (0 == strncmp(cwd, path, 4)) {
      sprintf(pathPtn, "%s/%s", &path[strlen(cwd)], pattern);
    } else {
      sprintf(pathPtn, "%s/%s", path, pattern);
    }
  }
  
  pathSlashCount = 1;
  tmpStr = pathPtn;
  while (*tmpStr++) {
    if (*tmpStr == '/') {pathSlashCount++;}
  }

  i = strlen(pathPtn);
  i--;
  if (pathPtn[i] == '/') {
//     types->type &= TCL_GLOB_TYPE_DIR;
     pathSlashCount --;
  }

DBGPRINT("pathSlashCount: %d\n", pathSlashCount );

  pathPtnLen = strlen(pathPtn);
DBGPRINT("PTN: %s LEN: %d\n", pathPtn, pathPtnLen);
  i=0;
  
  while (memStruct[i] != 0) {
    strncpy(name, memStruct[i]->name, 299);
    tmpStr = name;
    slashCount = 0;
    while (*tmpStr++) {
      if (*tmpStr == '/') {slashCount++;}
      if (slashCount >= pathSlashCount) {*++tmpStr = 0; break;}
    }
DBGPRINT("NAME1: %s\n", name);

  if (types->type & TCL_GLOB_TYPE_FILE) {

  DBGPRINT("FILE: TSL: %d: %s - %s -> %s : %d\n", terminalSlash, pathPtn, memStruct[i]->name, name,
    Tcl_StringCaseMatch(name,pathPtn, 0));

    if (Tcl_StringCaseMatch(name,pathPtn, 0)) {
      DBGPRINT("HIT at %d: %s -> %s\n", i, memStruct[i]->name, name);

      *cwdName = 0;
      strcpy(cwdName, cwd);
      strcat(cwdName, name);

DBGPRINT("CWDNAME: %s KEY: %d\n", cwdName, newKey);

      matched = MemFile_PathIsInList(resultObj, cwdName);

      if (matched == 0) {
        strObj = Tcl_NewStringObj(cwdName, -1);
        Tcl_ListObjAppendElement(interp, resultObj, strObj);
	DBGPRINT("FIL APPENDING: %s\n", cwdName);
      }
    }
  }

  if (types->type & TCL_GLOB_TYPE_DIR) {

    for (j=strlen(name); (j > 0) && (name[j] != '/'); j--) {    }
    name[j] = 0;


    DBGPRINT("FILE: TSL: %d: %s - %s -> %s : %d\n", terminalSlash, pathPtn, memStruct[i]->name, name,
      Tcl_StringCaseMatch(name,pathPtn, 0));

    if (Tcl_StringCaseMatch(name,pathPtn, 0)) {
      DBGPRINT("HIT at %d: %s -> %s\n", i, memStruct[i]->name, name);

      *cwdName = 0;
      strcpy(cwdName, cwd);
      strcat(cwdName, name);

DBGPRINT("CWDNAME: %s KEY: %d\n", cwdName, newKey);

      matched = MemFile_PathIsInList(resultObj, cwdName);

      if (matched == 0) {
        strObj = Tcl_NewStringObj(cwdName, -1);
        Tcl_ListObjAppendElement(interp, resultObj, strObj);
	DBGPRINT("DIR APPENDING: %s\n", cwdName);
      }
    }
  }
  i++;
  }
  
  

fflush(stdout);
    return TCL_OK;
};

/*------------------------------------------------------------------------
* Tcl_Obj *memFile_ListVolumes ()--
*    Return a list of mounted memory filesystems
* Arguments:
*   NONE
* 
* Results:
*    Return a list of mounted memory filesystems
* 
* Side Effects:
*   New List object and Tcl_Obj structures returned.
------------------------------------------------------------------------*/
Tcl_Obj *memFile_ListVolumes () {
  Tcl_Obj *resultObj, *strObj;
  Tcl_HashSearch  searchPtr;
  Tcl_HashEntry *hashEntryPtr;
  char *key;
  
  hashEntryPtr = Tcl_FirstHashEntry(memFile_hashtablePtr, &searchPtr);
  resultObj = Tcl_NewListObj(0, NULL);     

  while (NULL != hashEntryPtr) {
    key = Tcl_GetHashKey(memFile_hashtablePtr, hashEntryPtr);
    DBGPRINT("KEY: %s\n", key);
    if (*key == '/') {
      strObj = Tcl_NewStringObj(key, -1);
      Tcl_ListObjAppendElement(NULL, resultObj, strObj);
    }
    hashEntryPtr = Tcl_NextHashEntry(&searchPtr);
  }

// Hardcoded for single /mem file system used in testing.
//  DBGPRINT("memFile_ListVolumes \n");
//  resultObj = Tcl_NewListObj(0, NULL);     
//  strObj = Tcl_NewStringObj("/mem", -1);
//  Tcl_ListObjAppendElement(NULL, resultObj, strObj);

  return resultObj;
};

// Fill the filesystem structure with the appropriate pointers to functions.
Tcl_Filesystem memFileSystem = {
    "memFile", 
    sizeof(Tcl_Filesystem),
    TCL_FILESYSTEM_VERSION_1,
    &memFile_PathInFilesystem,
    &memFile_DupInternalRep,
    &memFile_FreeInternalRep,
    NULL,
    NULL,
    NULL,
    &memFile_FilesystemPathType,
    &memFile_FileSystemSeparator,
    &memFile_Stat,
    &memFile_Access,
    &memFile_OpenFileChannel,
    &memFile_MatchInDirectory,
    &memFile_Utime,
    NULL,
    &memFile_ListVolumes,
    &memFile_FileAttrStrings,
    &memFile_FileAttrGet,
    &memFile_FileAttrSet,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL};
    



static unsigned int genHash(
    VOID *keyPtr)		/* Key from which to compute hash value. */
{
    register CONST char *string = (CONST char *) keyPtr;
    register unsigned int result;
    register int c;

    // Stolen from HashStringKey in tclHash.c

    /*
     * I tried a zillion different hash functions and asked many other people
     * for advice. Many people had their own favorite functions, all
     * different, but no-one had much idea why they were good ones. I chose
     * the one below (multiply by 9 and add new character) because of the
     * following reasons:
     *
     * 1. Multiplying by 10 is perfect for keys that are decimal strings, and
     *	  multiplying by 9 is just about as good.
     * 2. Times-9 is (shift-left-3) plus (old). This means that each
     *	  character's bits hang around in the low-order bits of the hash value
     *	  for ever, plus they spread fairly rapidly up to the high-order bits
     *	  to fill out the hash value. This seems works well both for decimal
     *	  and non-decimal strings, but isn't strong against maliciously-chosen
     *	  keys.
     */

    result = 0;

    for (c=*string++ ; c ; c=*string++) {
	result += (result<<3) + c;
    }
    return result;
}

void *getHashData (Tcl_Interp *interp, 
		   char *hashName, 
		   Tcl_HashTable *hashtablePtr) {
   Tcl_HashEntry *hashEntryPtr;

    hashEntryPtr = Tcl_FindHashEntry(hashtablePtr, hashName);
    
    if (hashEntryPtr == (Tcl_HashEntry *) NULL) {
        char errString[80];
	Tcl_Obj *errCodePtr;

	/* 
	 * Define an error code from an integer, and set errorCode.
	 */
	errCodePtr = Tcl_NewIntObj(554);
	Tcl_SetObjErrorCode(interp, errCodePtr);
	
	/* 
	 * This string will be placed in the global variable errorInfo
	 */
	
	sprintf(errString, "Hash object \"%s\" does not exist.", hashName);
        Tcl_AddErrorInfo(interp, errString);
	
	return (void *) NULL;
    }
    
    /* 
     * If we got here, then the search was successful and we can extract
     *  the data value from the hash entry and return it.
     */

   return (void *)Tcl_GetHashValue(hashEntryPtr);
}




Tcl_DriverOutputProc * memFile_outputCmd () {DBGPRINT(" memFile_outputCmd \n"); return TCL_OK;};
Tcl_DriverSeekProc * memFile_seekCmd () {DBGPRINT(" memFile_seekCmd \n"); return TCL_OK;};
Tcl_DriverSetOptionProc * memFile_setOptionCmd () {DBGPRINT(" memFile_setOptionCmd \n"); return TCL_OK;};
Tcl_DriverGetOptionProc * memFile_getOptionCmd () {DBGPRINT(" memFile_getOptionCmd \n"); return TCL_OK;};
Tcl_DriverGetHandleProc * memFile_getHandleCmd () {DBGPRINT(" memFile_getHandleCmd \n"); return TCL_OK;};
int memFile_close2Cmd (ClientData instanceData,
                    Tcl_Interp *interp, int flags) {
		    DBGPRINT(" memFile_close2Cmd \n"); return TCL_OK;
		    };
Tcl_DriverFlushProc * memFile_FlushCmd () {DBGPRINT(" memFile_FlushCmd \n"); return TCL_OK;};
Tcl_DriverHandlerProc * memFile_HandlerCmd () {DBGPRINT(" memFile_HandlerCmd \n"); return TCL_OK;};

Tcl_DriverBlockModeProc * memFile_blockModeCmd () {
    //DBGPRINT(" memFile_blockModeCmd \n"); 
     return TCL_OK;
     // EINVAL isn't defined anywhere I can find it.
//    return EINVAL;
};

Tcl_DriverWatchProc * memFile_watchCmd (Tcl_ChannelType *typePtr) {
    // There are not interesting events on this type of channel.
    return TCL_OK;
};

int memFile_closeCmd (ClientData clientInstanceData,
                      Tcl_Interp *interp)
{
    InstanceData *instanceData = (InstanceData *) clientInstanceData;
DBGPRINT("FREE: DECOMPRESSED: %xx %xx\n", instanceData, instanceData->readBuffer);
    if (instanceData->id != 12345) {
      return TCL_OK;
    }
    ckfree((char*) instanceData->readBuffer);
    ckfree((char*) instanceData);
    DBGPRINT("CLOSE AT %d\n", instanceData->readOffset);
    return TCL_OK;
}

int memFile_inputCmd (ClientData clientInstanceData,
		      char *buf, int toRead, int *errorCodePtr)
{
    InstanceData *instanceData = (InstanceData *) clientInstanceData;
    int copied;

  if (instanceData->readBuffer == NULL) {
      return 0;
  }
    if ((instanceData->readLen - instanceData->readOffset) >= toRead) {
        memcpy(buf, 
		instanceData->readBuffer + instanceData->readOffset, toRead);
	copied = toRead;
    } else {
        memcpy(buf,
	      	instanceData->readBuffer + instanceData->readOffset,
		instanceData->readLen - instanceData->readOffset);
	copied = instanceData->readLen - instanceData->readOffset;
    }
    instanceData->readOffset += copied;

    if (instanceData->readOffset == instanceData->readLen) {
        instanceData->readOffset = instanceData->readLen = 0;
    }
    return copied;
}


/*------------------------------------------------------------------------
* unsigned char *memFile_DecompressBuffer-- 
*   Decompress compressed data into an undefined buffer, return the buffer
*    which will need to be ckfreed later.
*
* NOTE: This code is copied from bzTclLite with name change.
*
* Arguments:
*   compressed		Compressed Data
*   comprLen		Number of bytes to decompress
*   decomprCount	Pointer to int to receive length of returned data
* Results:
*   Returns a pointer to a buffer containing N returned bytes.
* 
* Side Effects:
*   ckallocs a buffer.
*
------------------------------------------------------------------------*/
unsigned char *memFile_DecompressBuffer (
      unsigned char *compressed, int comprLen, int *decomprCount) {
    char *outbuf;
    unsigned char *returnCharPtr;
    bz_stream *bz1;
    int byteCount, out;
    int charCount;
    
    charCount = comprLen;
    outbuf = (char *)ckalloc(10000);
    returnCharPtr = (unsigned char *)ckalloc(10000);

    byteCount = 0;

    bz1 = (bz_stream *) malloc(sizeof(bz_stream));
    bz1->bzalloc = NULL;
    bz1->bzfree  = NULL;
    bz1->opaque  = NULL;
    bz1->next_in = (char *) compressed;
    bz1->next_out = outbuf;
    bz1->avail_out = 10000;
    bz1->avail_in = charCount;
    bz1->total_out_lo32 = 0;
    bz1->total_out_hi32 = 0;
    bz1->total_in_lo32 = 0;
    bz1->total_in_hi32 = 0;

  out = BZ2_bzDecompressInit (bz1, 0, 0);
  DBGPRINT("outU0: %d nextin: %xx, AVAILin: %d TOTIN: %d NextOut: %xx AVOUT %d TOTOUT: %d  byteCount: %d\n", 
        out, bz1->next_in, bz1->avail_in, bz1->total_in_lo32, 
	bz1->next_out, bz1->avail_out, bz1->total_out_lo32,
	byteCount);

  while ((out == BZ_OK)) {
    out = BZ2_bzDecompress(bz1);
    DBGPRINT("outU2: %d nextin: %xx, AVAILin: %d TOTIN: %d NextOut: %xx AVOUT %d TOTOUT: %d  byteCount: %d\n", 
        out, bz1->next_in, bz1->avail_in, bz1->total_in_lo32, 
	bz1->next_out, bz1->avail_out, bz1->total_out_lo32,
	byteCount);
    
    if (out < 0) {
      ckfree((char *)returnCharPtr);
      returnCharPtr= NULL;
      byteCount = 0;
      goto fail;
    }

    memcpy(&returnCharPtr[byteCount], outbuf, 10000-bz1->avail_out);
    byteCount = bz1->total_out_lo32;

    if (out != BZ_STREAM_END) {
      returnCharPtr = (unsigned char *)ckrealloc((char *)returnCharPtr, byteCount + 10000);
      bz1->next_out = outbuf;
      bz1->avail_out = 10000;
    }
  }
  
    out = BZ2_bzDecompressEnd(bz1);
    DBGPRINT("outU3: %d IN: %d, %d OUT: %d\n", out, bz1->avail_in, bz1->total_in_lo32, bz1->total_out_lo32);

done:

fail:    
    free(bz1);
    free (outbuf);
    *decomprCount = byteCount;
    return (returnCharPtr);
}


int memFile_openCmd (ClientData info, 
			     Tcl_Interp *interp, 
			     int objc, 
			     Tcl_Obj *objv[]) {
  
  InstanceData *instanceData;

  Tcl_Channel newChannel;
  char *channelName;
  char *hashName;
  unsigned char *decompressedData;
  int byteCount;
  Tcl_ChannelType *channelType;
  Tcl_HashEntry *hashEntryPtr;
  int isNew, i;
  char *path, cwd[80];
  memFileData **memStruct;

  /*
   *  Check that we have a string argument
   *   else return an Error and the usage message
   */
    
  if (objc != 2) {
      Tcl_WrongNumArgs(interp, 1, objv, "path");
      return TCL_ERROR;
  }

  /*
   * The subcommand is recognized, and has a valid number of arguments
   * Process the command.
   */   
     
   path = Tcl_GetStringFromObj(objv[1], NULL);

DBGPRINT("To open: %s\n", path);

  hashEntryPtr = MemFile_getMemFileData(path, cwd);
  if (hashEntryPtr == NULL) {
    return -1;
  }

  memStruct = (memFileData **) Tcl_GetHashValue(hashEntryPtr);
  
  path+=strlen(cwd);
  i = memFile_getPathIndex(memStruct, path);


  if (i < 0) {
    char errString[80];
    sprintf(errString, "couldn't open \"%s\" no such element in memlist", path);
    Tcl_AddErrorInfo(interp, errString);
    Tcl_AppendResult(interp, "couldn't open \"", path, "\" no such element in memlist", (char *) NULL);

    return TCL_ERROR;
  }

  
  channelType = makeChannelTypeStructure();
  channelName = (char *)ckalloc(20);
  sprintf(channelName, "%s%d", "memFile", memFileID++);
  
  instanceData = (InstanceData *) getHashData(interp, channelName, 
    memFile_hashtablePtr);
  
  if (instanceData == NULL) {
    instanceData = (InstanceData *)ckalloc(sizeof(InstanceData));
  } else {
    Tcl_AddErrorInfo(interp, "Already exists");
    return TCL_ERROR;
  }

  hashEntryPtr = Tcl_CreateHashEntry(memFile_hashtablePtr, channelName, &isNew);
  Tcl_SetHashValue(hashEntryPtr, instanceData);
  
  DBGPRINT("CREATING: %s \n", channelName);

  newChannel = Tcl_CreateChannel(channelType, channelName, 
				 (ClientData) instanceData, TCL_READABLE);
  Tcl_RegisterChannel(interp, newChannel);
  
  
  decompressedData = memFile_DecompressBuffer(memStruct[i]->data, memStruct[i]->dataLen, &byteCount);

  instanceData->id=12345;
  instanceData->tclReadChannel=newChannel;
  instanceData->readBuffer=decompressedData;
  instanceData->readLen = byteCount;
  instanceData->readOffset = 0;
  Tcl_AppendResult(interp, channelName, (char *) NULL);
		
  return TCL_OK;
}


/*------------------------------------------------------------------------
* int memFile_listFilesCmd (ClientData info--
*    Return a list of paths that exist under a mount point
* Arguments:
*   path	/foo - The mountpoint for the memory file structure.
* 
* Results:
*   Returns TCL_OK if mount point exists, else TCL_ERROR
* 
* Side Effects:
*   Creates list object and appends new tcl_string objects to it.
*
------------------------------------------------------------------------*/
int memFile_listFilesCmd (ClientData info, 
			     Tcl_Interp *interp, 
			     int objc, 
			     Tcl_Obj *objv[]) {
  
  InstanceData *instanceData;
  Tcl_HashEntry *hashEntryPtr;
  Tcl_Obj *listobj, *strObj;
  char channelName[20];
  int isNew, i;
  char *path, cwd[80];
  memFileData **memStruct;
  /*
   *  Check that we have a string argument
   *   else return an Error and the usage message
   */
    
  if (objc != 2) {
      Tcl_WrongNumArgs(interp, 1, objv, "path");
      return TCL_ERROR;
  }

  /*
   * The subcommand is recognized, and has a valid number of arguments
   * Process the command.
   */   

   path = Tcl_GetStringFromObj(objv[1], NULL);

DBGPRINT("To open: %s\n", path);

  hashEntryPtr = MemFile_getMemFileData(path, cwd);
  if (hashEntryPtr == NULL) {
    return -1;
  }

  memStruct = (memFileData **) Tcl_GetHashValue(hashEntryPtr);
  
  path+=strlen(cwd);
  listobj = Tcl_NewListObj(0, NULL);     
  Tcl_SetObjResult(interp, listobj);

  i=0;
  while (memStruct[i] != 0) {
    strObj = Tcl_NewStringObj(memStruct[i]->name, -1);
    Tcl_ListObjAppendElement(interp, listobj, strObj);
    i++;
  }
  
  return TCL_OK;
}

Tcl_ChannelType *makeChannelTypeStructure() {
  Tcl_ChannelType *str;
  char *tmp;
  
  str = (Tcl_ChannelType *) ckalloc (sizeof (Tcl_ChannelType));
  
  tmp = (char *)ckalloc(8);
  strcpy(tmp, "memFile");
  
  str->typeName = tmp;
  str->version = TCL_CHANNEL_VERSION_2;
  str->blockModeProc = (Tcl_DriverBlockModeProc *) NULL;
  
  str->closeProc = (Tcl_DriverCloseProc *) memFile_closeCmd ;
  str->inputProc = (Tcl_DriverInputProc *) memFile_inputCmd ;
  str->outputProc = (Tcl_DriverOutputProc *) memFile_outputCmd ;
  str->seekProc = (Tcl_DriverSeekProc *) memFile_seekCmd ;
  str->setOptionProc = (Tcl_DriverSetOptionProc *) memFile_setOptionCmd ;
  str->getOptionProc = (Tcl_DriverGetOptionProc *) memFile_getOptionCmd ;
  str->watchProc = (Tcl_DriverWatchProc *) memFile_watchCmd ;
  str->getHandleProc = (Tcl_DriverGetHandleProc *) memFile_getHandleCmd ;
  str->close2Proc = (Tcl_DriverClose2Proc *) memFile_close2Cmd;
  str->blockModeProc = (Tcl_DriverBlockModeProc *) memFile_blockModeCmd;
  str->flushProc = (Tcl_DriverFlushProc *) memFile_FlushCmd;
  str->handlerProc = (Tcl_DriverHandlerProc *) memFile_HandlerCmd;
  
  return str;
}


int memFile_MatchCmd (ClientData info, Tcl_Interp *interp, int objc, 
    Tcl_Obj *objv[]) {

  Tcl_Obj *listobj, *strObj, *args[3], *tclRslt;
  char *pattern;
  Tcl_GlobTypeData types;
  int i;

  if (objc != 4) {
      Tcl_WrongNumArgs(interp, 2, objv, "path pattern typeNum");
      return TCL_ERROR;
  }

  Tcl_GetIntFromObj(interp, objv[3], &i);
  types.type = i;

  listobj = Tcl_NewListObj(0, NULL);     
  
  pattern = Tcl_GetStringFromObj(objv[2], NULL);
DBGPRINT("PATTERN: %s\n", pattern);
  memFile_MatchInDirectory (interp, listobj, objv[1], 
    pattern, &types) ;

  Tcl_SetObjResult(interp, listobj);
  
  return TCL_OK;
}

int memFile_MountCmd (ClientData info, Tcl_Interp *interp, int objc, 
    Tcl_Obj *objv[]) {

  char *path;
  memFileData *memStruct;
  Tcl_HashEntry *hashEntryPtr;
  int isNew;
  char errString[80];
  Tcl_Obj *errCodePtr;


  if (objc != 4) {
      Tcl_WrongNumArgs(interp, 2, objv, "mountPoint memStruct");
      return TCL_ERROR;
  }

  path = Tcl_GetStringFromObj(objv[2], NULL);
  memStruct = (memFileData*) Tcl_GetByteArrayFromObj(objv[3], NULL);

  return memFile_Mount(NULL, interp, path, memStruct);
}

int memFile_Mount (ClientData info, Tcl_Interp *interp, char *path,
    memFileData *memStruct) {

  Tcl_HashEntry *hashEntryPtr;
  int isNew;
  char errString[80];
  Tcl_Obj *errCodePtr;


  hashEntryPtr = Tcl_CreateHashEntry(memFile_hashtablePtr, path, &isNew);
  if (!isNew) {
    // This mount point is already defined.  Bad Boy!

	/* 
	 * Define an error code from an integer, and set errorCode.
	 */
	errCodePtr = Tcl_NewIntObj(554);
	Tcl_SetObjErrorCode(interp, errCodePtr);
	
	/* 
	 * This string will be placed in the global variable errorInfo
	 */
	
	sprintf(errString, "\"%s\" is already mounted.", path);
        Tcl_AddErrorInfo(interp, errString);
	
	return TCL_ERROR;

  }
  Tcl_SetHashValue(hashEntryPtr, memStruct);

  return TCL_OK;
}

