/*
 * WarpPointer.c --
 *
 *     This file contains a Tcl dynamically loadable extension
 *     that will move the mouse pointer.
 *
 *     It will only work with UNIX/X windows (not Windows or Mac).
 *
 *  $Id: WarpPointer.c,v 1.1.1.1 2004/03/09 15:36:16 clif Exp $
 *  $Log: WarpPointer.c,v $
 *  Revision 1.1.1.1  2004/03/09 15:36:16  clif
 *  The initial TkReplay from Crowley's website.
 *
 * Revision 1.2  1996/07/31  16:24:03  crowley
 * This is the 1.1 revision of TkReplay.  Lots of small changes.
 * Most of them from Dean Brettle.  Connecting and replay are
 * faster.  Socket support has been added.
 *
 * Revision 1.1  1996/07/29  22:48:13  crowley
 * Initial revision
 *
 */
#include <tk.h>

/*
 * Declarations for functions defined in this file.
 */

static int WarpPointer _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));

int Warppointer_Init _ANSI_ARGS_((Tcl_Interp *interp));

/*
 *----------------------------------------------------------------------
 *
 * Warppointer_Init --
 *
 *	This procedure initializes the WarpPointer command.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

int Warppointer_Init(interp)
    Tcl_Interp *interp;
{
    Tcl_CreateCommand(interp, "WarpPointer", WarpPointer, NULL, NULL);
#if (TCL_MAJOR_VERSION>7 || (TCL_MAJOR_VERSION==7) && TCL_MINOR_VERSION>=5)
    return Tcl_PkgProvide(interp, "WarpPointer", "1.0");
#else
    return TCL_OK;
#endif
}

/*
 *----------------------------------------------------------------------
 *
 * WarpPointer --
 *
 *	This function implements the Tcl "WarpPointer" command.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	The mouse pointer is moved ("warped") to a new location.
 *
 *----------------------------------------------------------------------
 */

static int
WarpPointer(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tk_Window main, w;
    Window win;
    int x, y;

    if (argc < 4) {
        Tcl_SetResult(interp,
            "wrong # args: should be WarpPointer x y widgetId", TCL_STATIC);
        return TCL_ERROR;
    }

    if ((Tcl_GetInt(interp, argv[1], &x) == TCL_ERROR) ||
	(Tcl_GetInt(interp, argv[2], &y) == TCL_ERROR))
	return TCL_ERROR;

    main = Tk_MainWindow(interp);
    win = (Window)strtol(argv[3], (char **)NULL, 16);

    XWarpPointer(Tk_Display(main), None, win, 0, 0, 0, 0, x, y);
    return TCL_OK;
}















