#!/bin/sh
# \
    exec wish $0 ${1+"$@"}
#
# tkreplay.tcl
#     This is the main program for TkReplay.
#
set Release(tkreplay.tcl) {$Header: /home/cvs/tktest/tktest.tcl,v 1.15 2005/08/12 01:33:59 clif Exp $}

package require Tk

source introspect.tcl
source wmap.tcl
source control.tcl   
source debugging.tcl 
source images.tcl    
source initialize.tcl
source help.tcl
source mainwin.tcl
source connect.tcl
source edit.tcl   
source comment.tcl
source rr.tcl
source socksend/socksend.tcl
source tildefy.tcl


###################################################################
# Set the directory where TkReplay is installed based on the
# REPLAY_LIBRARY environment variable if it exists.
# Otherwise use the directory where this script resides
if {[info exists env(REPLAY_LIBRARY)]} {
    set ReplayData(HomeDirectory) $env(REPLAY_LIBRARY)
} else {
    set ReplayData(HomeDirectory) [file dirname [info script]]
}
###################################################################
# Set the default wish to use to run applications based on
# the REPLAY_WISH environment variable if it exists.
# Otherwise use wish
if {[info exists env(REPLAY_WISH)]} {
    set ReplayData(DefaultWish) $env(REPLAY_WISH)
} else {
    set ReplayData(DefaultWish) wish
}
#
###################################################################
# Initialization.
###################################################################
global auto_path
global ReplayData
lappend auto_path $ReplayData(HomeDirectory)
wm withdraw .

set ReplayData(scriptFileDir) $ReplayData(HomeDirectory)
source introspect.tcl
source control.tcl
source debugging.tcl
source images.tcl

#
# USER OPTION: you can leave the highlights in
#
# I don't like the highlights so I get rid of them
#
option add {*highlightThickness} 0 widgetDefault
#
Initialize
MakeMessageWindow
MakeReplayWindow
EraseScript
update
#
# read the command line arguments (if any)
#
set len [llength $argv]
set playScript 0

array set ReplayData {
  MyPort 3010
  detailedMessage {}
}

set demoMode 0

for {set i 0} {$i <$len} {incr i} {
    set item [lindex $argv $i]
    switch -glob -- $item \
        {-demo} {
	  set demoMode 1
	} \
        {-app} {
            incr i
            lappend appNames [lindex $argv $i]
        } \
        {-script} {
            incr i
            set scriptName [lindex $argv $i]
        } \
        {-port} {
            incr i
            set ReplayData(MyPort) [lindex $argv $i]
        } \
        {-play} {
            set playScript 1
        } \
        {-play[fF]ast} {
            set playScript 2
        } \
        {-move[mM]ouse} {
            set ReplayData(pointWithMouse) 1
        } \
        {-no[mM]ove[mM]ouse} {
            set ReplayData(pointWithMouse) 0
        } \
        {-move[aA]rrow} {
            set ReplayData(pointWithArrow) 1
        } \
        {-no[mM]ove[aA]rrow} {
            set ReplayData(pointWithArrow) 0
        } \
        {-use[sS]end} {
            set ReplayData(useSend) 1
            set ReplayData(useSockets) 0
        } \
        {-mouse[sS]peed} {
            incr i
            set speed [lindex $argv $i]
            switch -glob -- $speed \
                {[sS]low} { set ReplayData(MouseSpeed) 1 } \
                {[mM]edium} { set ReplayData(MouseSpeed) 3 } \
                {[fF]ast} { set ReplayData(MouseSpeed) 6 } \
                {[vV]ery[fF]ast} { set ReplayData(MouseSpeed) 100 } \
                {[wW]arp} { set ReplayData(MouseSpeed) 999 } \
                {[0-9][0-9]*} { set ReplayData(MouseSpeed) $speed } \
                default {
                    puts "Unknown mouse speed $speed ignored"
                }
        } \
        default {
            set scriptName [lindex $argv $i]
        }
}

    if {$demoMode} {
      catch {wm withdraw .}
      catch {wm withdraw .replay}
      after 2000 {catch {wm withdraw .replaypointer}}
      after 2000 {catch {wm withdraw .messageWindow}}
      set ReplayData(pointWithArrow) 1
    }
    
#
# set up socket communication
#

    source socksend/socksend.tcl
    socksendsetup $ReplayData(MyPort)
    proc tkrsend {args} {
socksendDebug "TKRSENDA: ARGS: $args"
        return [eval socksend $args]
    }



if {[info exists appNames]} {
    foreach appName $appNames {
	LoadAndConnect $appName
    }
}
if {[info exists scriptName]} {
    LoadScript $scriptName
}
#
# play script immediately if it was requested
#
if {$playScript} {
    after 2000 {
      switch $playScript \
        0 { # do not play } \
        1 { Replay } \
        2 { ReplayFast }
      }
   }

