# A simple application with 'stuff' for testing/exercising tktest.

proc GUI {} {
  set f0 [menu .bf -type menubar]
  . configure -menu $f0
  $f0 add cascade -label "File" -menu $f0.file
  set m [menu $f0.file]
  $m add command -label "exit" -command exit
  

  set lmf [labelframe .lfm1 -text "MenuButtonFrame"]
  pack $lmf -side top
  menubutton $lmf.file -text File -menu $lmf.file.m
  set m [menu $lmf.file.m]
  $m add command -label "exit" -command exit

  set lf1 [labelframe .lf1 -text "Top"]
  pack $lf1 -side top
  set lf2 [frame .lf2]
  pack $lf2 -side top
  set lf3 [labelframe .lf3 -text "Bottom"]
  pack $lf3 -side top
  
  set row 0
  foreach {ttl var} {Name name "Favorite Color" color Quest quest} {
    incr row
    foreach fr [list $lf1 $lf2 $lf3] {
      set w [label $fr.l_$var -text $ttl]
      grid $w -row $row -column 1
      set w [entry $fr.e_$var -textvar data($fr,$var)]
      grid $w -row $row -column 2
    }
  }
  set w [canvas $lf1.c -height 60 -width 240 -bg white]
  grid $w -row 4 -column 1 -columnspan 2

  set w [text $lf3.t -height 5 -width 30 -bg white]
  grid $w -row 4 -column 1 -columnspan 2
}

proc modCvs {} {
  .lf1.c create line 0 0 100 30 -width 3 -fill blue
}



# KLUDGE - SRCDIR is used by Tobe.  Default to socksend if no Tobe
#  must have normal Tobe tree with socksend.tcl in SRCDIR for Tobe test.

set SRCDIR socksend
#
# Boiler plate startup code.
#
# If TESTING is set, tkreplay code is loaded and initialized.
set TESTING 0
if {[set p [lsearch $argv -test]] >= 0} {
    set TESTING 1
    set p2 $p
    incr p2
    set TkTestAddress [lindex $argv $p2]
    if {[string first "." $TkTestAddress] < 0} {
      puts "-test IP.Address"   
      exit
    }
    set argv [lreplace $argv $p $p2]
#    unset p p2
} else {
    puts "INVOKE As wish testApp.tcl -test 127.0.0.1"
#    exit
}
        

if {$TESTING} {
  source $SRCDIR/socksend.tcl
  sockappsetup tktest.tcl 3010  $TkTestAddress

  # INVOKE tktest as:
  # wish tktest.tcl   

    proc ::tk_getOpenFile {args} {
        if {$::tk_strictMotif} {
            return [eval tk::MotifFDialog open $args]
        } else {
            return [eval ::tk::dialog::file:: open $args]
        }
    }
    
    proc ::tk_getSaveFile {args} {
        if {$::tk_strictMotif} {
            return [eval tk::MotifFDialog save $args]
        } else {
            return [eval ::tk::dialog::file:: save $args]
        }                                                                       
    }
}

#
# End boiler plate startup code.
#

GUI
