proc getElementAtLoc {list loc} {
  set len 0
  foreach el $list {
     incr len [string length $el]
     incr len 1

     if {$len > $loc} {
       return $el
     }
  }
  return $el
}

proc makeGrabGUI {txt lbl command} {
  catch {destroy .replay.grabFrame}

  set w [frame .replay.grabFrame -relief raised -borderwidth 5]
  set w [labelframe .replay.grabFrame.lf -text "$txt" ]

  label $w.l1 -text $lbl

  entry $w.e1  -width 50

  button $w.b1 -text "Cancel" -command {
      destroy .replay.grabFrame;
      set ReplayData(Timer) 1
      }

  button $w.b2 -text "Go" -command "\
      $command \[.replay.grabFrame.lf.e1 get\];  \
      destroy .replay.grabFrame; \
      "
  grid $w.l1 -row 1 -column 0
  grid $w.e1 -row 1 -column 1
  grid $w.b1 -row 2 -column 0
  grid $w.b2 -row 2 -column 1
  pack .replay.grabFrame.lf
  place .replay.grabFrame -relx .5 -rely .5 -anchor center
}

proc grabArrayGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Get Array Snapshot" "Array Name" grabArray
}

proc grabSQLGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Get SQL Snapshot" "SQL CMD" grabSQL
}

proc grabTCLGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Check Return of Tcl command" "TCL CMD" grabTCL
}

proc grabWindowContentsGUI {} {
  global ReplayData
  set ReplayData(Timer) 0
  showClientWindows AddWinCheck
}

proc AddWinCheck {node} {
  global Windows
  
  set win $Windows($node)
  grabWindowContents $win
}

proc grabWindowContents {win} {
  global ReplayData

  set contents [getContents $win]

  InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckWinReturn $win $contents] 1]
    set ReplayData(Timer) 1
}

proc getReply {cmd} {
  global ReplayData
  tkrsend $ReplayData(ConnectedApps) \
    "catch {$cmd} rpl; socksend  tktest.tcl \"set ReplayData(Reply) \[list \$rpl]\""
  vwait ReplayData(Reply)
  return $ReplayData(Reply)
}

proc getContents {win} {
  global ReplayData
  
  set type [getReply "winfo class $win"]

  MsgToUser "Retrieving info for $win of type $type" info

  set rtn "$win $type"
  switch $type {
     Tobe -
     Labelframe -
     Toplevel -
     Panedwindow -
     Frame {
        set children [getReply "winfo children $win"]
	foreach ch $children {
	  lappend rtn [getContents $ch]
	}
     }
     Button -
     Listbox -
     Label {
        lappend rtn [getReply "$win configure"]
     }
     Entry {
        lappend rtn [getReply "$win get"]
     }
     Text {
       lappend rtn [getReply "$win get 0.0 end"]
       lappend rtn [getReply "$win dump -image 0.0 end"]
       lappend rtn [getReply "$win dump -tag 0.0 end"]
       lappend rtn [getReply "$win dump -window 0.0 end"]
     }
     Canvas {
       lappend rtn [list Elements [lsort [getReply "$win find all"]] ]
       foreach i [getReply "$win find all"] {
         lappend rtn \
	   [list $i [getReply "$win type $i"] [getReply "$win itemconfigure $i"] [getReply "$win coords $i"]]
       }
     }

     Scrollbar {
       lappend rtn [getReply "$win configure"]
     }

     Table {
       for {set r 0} {$r < [getReply "$win cget -rows"]} {incr r} {
         for {set c 0} {$c < [getReply "$win cget -cols"]} {incr c} {
	   lappend rtn [getReply "$win get $r,$c"]
	 }
       }

       foreach t [getReply "$win tag names"] {
	 lappend rtn [getReply "$win tag cell $t"]
       }
     }

     default {
       tk_messageBox -type ok -message "Can't track $type (yet)"
     }
  }
  MsgToUser "Finished retrieving info for $win of type $type" info
  return $rtn
}

proc grabArray {arrayName} {
    global ReplayData
    set xx [getReply "array get $arrayName"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckArrayReturn [list array get $arrayName] $xx] 1]
    set ReplayData(Timer) 1
}


proc grabSQL {cmd} {
    global ReplayData
    set xx [getReply "db eval {$cmd}"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckReturn [list db eval $cmd] $xx] 1]
    set ReplayData(Timer) 1
}

proc grabTCL {cmd} {
    global ReplayData
    set xx [getReply "eval $cmd"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckReturn [list eval $cmd] $xx] 1]
    set ReplayData(Timer) 1
}


proc CheckWinReturn {win expect} {
  global  ReplayData
  set contents [getContents $win]

  if {![string equal $contents $expect]} {
      set misMatchLoc [strDiff $contents $expect]
      set expEl [getElementAtLoc $expect $misMatchLoc]
      set contEl [getElementAtLoc $contents $misMatchLoc]
      set msg "Window Compare Fail ($ReplayData(ScriptFileName)): $win Near $misMatchLoc"
      append msg "\n   XPCT: $expEl"
      append msg "\n   SEEN: $contEl"
    } else {
       set msg "Window Check OK ($ReplayData(ScriptFileName)): $win"
    }

    MsgToUser $msg high
}

proc CheckReturn {cmd expect} {
    global ReplayData
    set xx [getReply "$cmd"]
    if {[string equal $expect $xx]} {
      set msg "Cmd Check OK ($ReplayData(ScriptFileName)): $cmd"
    } else {
      set misMatchLoc [strDiff $xx $expect]
      set msg "Cmd Fail ($ReplayData(ScriptFileName)): [string range $cmd 0 60]"
      append msg "\nEXP:   [string range $expect [expr {$misMatchLoc-40}] [expr {$misMatchLoc+40}]]"
      append msg "\nSAW:   [string range $xx [expr {$misMatchLoc-40}] [expr {$misMatchLoc+40}]]"
    }
    MsgToUser "$msg" high
}

proc CheckArrayReturn {cmd expect} {
    global ReplayData
    set xx [getReply "$cmd"]
    if {[string equal $expect $xx]} {
      set msg "Cmd Check OK ($ReplayData(ScriptFileName)): $cmd"
    } else {
      set notsaw {}
      set notexp {}
      set mismatch {}
      set misMatchLoc [strDiff $xx $expect]
      set msg "Cmd Fail ($ReplayData(ScriptFileName)): [string range $cmd 0 60]"
      append msg "\n   Saw: [expr {[llength $xx]/2}] indices, Expect: [expr {[llength $expect]/2}] indices"
      append msg "\n   [string range $expect [expr {$misMatchLoc-40}] [expr {$misMatchLoc+40}]]"
      append msg "\n   [string range $xx [expr {$misMatchLoc-40}] [expr {$misMatchLoc+40}]]"

      set ReplayData(detailedMessage) $msg
      
      array set saw $xx
      array set exp $expect
      foreach in [array names saw] {
        if {![info exists exp($in)]} {
	  lappend notexp $in
	} else {
	  if {![string match $exp($in) $saw($in)]} {
	    lappend mismatch [list $in $exp $saw]
	  }
	}
      }
      foreach in [array names exp] {
        if {![info exists saw($in)]} {
	  lappend notsaw $in
	} else {
	  if {![string match $exp($in) $saw($in)] &&
	       ([lsearch $mismatch "$in *"] < 0) } {
	    lappend mismatch [list $in $exp $saw]
	  }
	}
      }
      
      append ReplayData(detailedMessage) "\n Indices in new data, not in expected data\n"

      foreach in $notexp {
              append ReplayData(detailedMessage) "$in\n"
      }
      

      append ReplayData(detailedMessage) "\n Indices in expected data, not in new data\n"

      foreach in $notsaw {
              append ReplayData(detailedMessage) "$in\n"
      }

      append ReplayData(detailedMessage) "\n Mismatched values\n"

      foreach in $mismatch {
              append ReplayData(detailedMessage) "$in\n"
      }
    }
    MsgToUser "$msg" high
}

proc strDiff {str1 str2} {
    set len1 [string length $str1]
    set len2 [string length $str2]
    set halfLen [expr {$len2/2}]
    set off 0
    
    while {$len1 > 2} {
      set stf1 [string range $str1 0 $halfLen]
      set stf2 [string range $str2 0 $halfLen]
      if {[string equal $stf1 $stf2]} {
        set str1 [string range $str1 $halfLen end]
        set str2 [string range $str2 $halfLen end]
	incr off $halfLen
      } else {
        set str1 [string range $str1 0 $halfLen ]
        set str2 [string range $str2 0 $halfLen ]
      }
      set len1 [string length $str1]
      set len2 [string length $str2]
      set halfLen [expr {$len2/2}]
    }

    if {$off != 0} {
      for {set i [expr {$off-10}]} {$i < [expr {$off + 20}]} {incr i} {
        if {![string equal [string range $str1 $i $i] \
	    [string range $str2 $i $i]]} {
	    return $i
	}
      }
    }
    return $off
}

proc UNUSED_stringDiff {A B} {
    if {[string equal $A $B]} {
        return "Strings Match"
    }
    set lenA [string length $A]
    set lenB [string length $B]
    set len $lenA
    if {$lenA > $lenB} {set len $lenB}
    
    set part [expr $len / 2]
    set start 0
    
    for {set i 0} {$i < $len} {incr i} {
      if {![string equal [string range $A $i $i] [string range $B $i $i]]} {
        break;
      }
    }
    
    set A [string range $A $i end]
    set B [string range $B $i end]
    
    return "Differ ($lenA/$lenB) starting at $i:\n  $A\n  $B"
}
