set Release(mainwin.tcl) {$Header: /home/cvs/tktest/mainwin.tcl,v 1.30 2014/07/22 00:23:49 clif Exp $}

###################################################################
# MakeReplayWindow: creates the replay control window.
###################################################################
package require BWidget

proc MakeReplayWindow {} {
    global ReplayData
    global GUI 
    
    set GUI(noAfterEvents) 1

    DynamicHelp::configure  -font {arial 12}
    
    # Construct and place the primary GUI widgets
    # Holders, Frames, etc.

    set mainframe [toplevel .replay -menu .replay.mm]
    wm title .replay "TkTest: Beta 0.7"
    
    set row 0

    set GUI(editFrame) [frame $mainframe.ef]
    grid $GUI(editFrame) -row $row -column 0 -sticky news
    incr row

    frame $mainframe.div1 -height 5 -relief flat -borderwidth 1
    grid $mainframe.div1 -row $row -column 0 -sticky ew
    incr row

    set fr [frame $mainframe.status -relief sunken]
    grid $fr -row $row -column 0 -sticky ewns -columnspan 2
    incr row
     
    set f [label $fr.l1 -text "Status:" -relief groove -anchor w]
    label $fr.l2 -textvar ReplayData(Status) -relief groove -borderwidth 1  -width 14
    grid $f  -row $row -column 0 -sticky ew
    grid $fr.l2  -row $row -column 1 -sticky we

    set f [label $fr.l3 -text "Event Script:" -relief groove -anchor w]
    label $fr.l4 -textvar ReplayData(ScriptFileName) -relief groove -borderwidth 1  -width 24
    grid $f  -row $row -column 2 -sticky we  -padx {4 0}
    grid $fr.l4  -row $row -column 3 -sticky we
    
    incr row

    set f [label $fr.l5 -text "Connected To:" -relief groove -anchor w]
    label $fr.l6 -textvar ReplayData(ConnectedApps) -relief groove -borderwidth 1  -width 14
    grid $f  -row $row -column 0 -sticky we
    grid $fr.l6  -row $row -column 1 -sticky we

    set f [label $fr.l7 -text "Control Script:" -relief groove -anchor w]
    label $fr.l8 -textvar ReplayData(ControlNameOnly) -relief groove -borderwidth 1  -width 24
    grid $f  -row $row -column 2 -sticky w  -padx {4 0}
    grid $fr.l8  -row $row -column 3 -sticky w
    
    incr row
    frame $mainframe.div2 -height 5 -relief flat -borderwidth 1
    grid $mainframe.div2 -row $row -column 0 -sticky ew

    incr row
    set GUI(nb) [NoteBook $mainframe.nb -height 400 -width 350]
    grid $GUI(nb) -row $row -column 0 -sticky news
    # Configure the windows to expand when main window resizes

    grid columnconfigure .replay 0 -weight 1
    grid rowconfigure .replay $row  -weight 1
    
    incr row
    
    label $mainframe.statusmessage -textvar ReplayData(StatusMessage)
    grid $mainframe.statusmessage -row $row -column 0 -sticky w
    incr row

    # Start filling the primary widgets

    #             Create the replay menus
    # File menu
    
    set menu [menu $mainframe.mm]

    $menu add cascade -label "File" -menu $menu.file 
    menu $menu.file
    $menu.file add command -label "Open..." -command "Load"
    $menu.file add command -label "Save" -command "Save"
    $menu.file add command -label "Save As..." -command "SaveAs"

    MonitorApps
    $menu.file add separator
    $menu.file add command -label "Quit TkTest" -command "QuitReplay"
    #
    # Edit menu
    #
    $menu add cascade -label "Edit" -menu $menu.edit 
    menu $menu.edit
    $menu.edit add command -label "Clear Event and Control scripts" -command "EraseScript; EraseControl"
    $menu.edit add separator

    #     No useful options in tktest
    #    $menu.edit add command -label "Preferences..." -command "OptionBox"

    #
    # Settings menu
    #
    $menu add cascade -label "Settings" -menu $menu.settings
    menu $menu.settings
    $menu.settings add radiobutton -label "Filter Out After Events" \
        -variable GUI(noAfterEvents) -value 1


    #
    # Help menu
    #

    $menu add cascade -label "Help" -menu $menu.help
    menu $menu.help
    $menu.help add command -label "Show help file" \
        -command "ShowHelp"
    $menu.help add command -label "About" -command "ShowAbout"
     
    

    # Fill the initial notebook page
    
    set row 0
    set col 0

    set GUI(events) [$GUI(nb) insert end events -text "Event Script"]
    $GUI(nb) raise events
    
#    set menu [menu $GUI(events).mm -type menubar -relief groove ]
    set menu [frame $GUI(events).mm -relief groove ]
    grid $menu -row 0 -column 0 -columnspan 3 -sticky ew
    incr row

    #             Create the replay menus
    # File menu
    
    #$menu add cascade -label "File" -menu $menu.file 
    menubutton $menu.f  -text "File" -menu $menu.f.file 
    grid $menu.f -row 0 -column 1
    set mf [menu $menu.f.file -tearoff 0]
    $mf add command -label "Open..." -command "puts LOAD; Load"
    $mf add command -label "Save" -command "Save"
    $mf add command -label "Save As..." -command "SaveAs"

    #
    # Edit menu
    #
    #$menu add cascade -label "Edit" -menu $menu.edit 
    #menu $menu.edit

    menubutton $menu.e -text "Edit" -menu $menu.e.edit 
    grid $menu.e -row 0 -column 2
    set mf [menu $menu.e.edit ]

    $mf add command -label "Erase script" -command "EraseScript"
    $mf add separator
    $mf add command -label "Change delay..." -command "EditEvent"
    $mf add separator

    $mf add command -label "Delete event" -command "DeleteEvent"
    $mf add separator
    $mf add command -label "Compress motion events" \
        -command "CompressMotionEvents"

    $mf add command -label "Regenerate Current Script" \
        -command "RebuildScript"

    $mf add command -label "Reset Current Script App Target" \
        -command "ResetTargetForScript"

    
    set GUI(bbox) [ButtonBox $GUI(events).box1 -spacing 0 -padx 1 -pady 1]
    grid $GUI(bbox) -row $row -column 0 -sticky w

    #
    # Fill the button bar
    #

    set cmds {
	      record    Record      StartRecording
              play      Play        Replay
	      fforward  "Play Fast" ReplayFast
	      rewind    Rewind      Rewind
	      stop      Stop        StopRecording
              pause     Pause       AddPause
	      }
    
    foreach {img help cmd} $cmds {
      set GUI(button.$img) [$GUI(bbox) add -image $img \
        -helptext $help \
	-height 20 -width 20 \
        -command $cmd ]
    }
    
    set GUI(bbox2) [ButtonBox $GUI(events).box2 -spacing 0 -padx 1 -pady 1]
    grid $GUI(bbox2) -row $row -column 1 -sticky w

    incr row
     
    set cmds {
	      arraymagnify "Check an Array" grabArrayGUI
	      sqlmagnify "Check a SQL " grabSQLGUI
	      winmagnify "Check a Window" grabWindowContentsGUI
	      feathermagnify "Check Script return" grabTCLGUI
              pause     Pause       AddPause
	      wait	Wait	    AddWait
              tinytcl "Add Tcl Script" AddTcl
              comment "Add A Comment" AddComment
              erase16T  "Erase Script"       EraseScript
	      }
    
    foreach {img help cmd} $cmds {
      set GUI(button.$img) [$GUI(bbox2) add -image $img \
	-height 20 -width 20 \
        -helptext $help \
        -command $cmd ]
    }

    set GUI(eventlistbox) [ listbox $GUI(events).list -height 12 -width 35 \
        -relief sunken  -borderwidth 2 \
	-yscroll "$GUI(events).yscroll set" \
	-xscroll "$GUI(events).xscroll set" \
        -exportselection false ]
    
    scrollbar $GUI(events).yscroll -orient vertical -relief sunken \
        -bd 2 -command "$GUI(events).list yview"

    scrollbar $GUI(events).xscroll -orient horizontal -relief sunken \
        -bd 2 -command "$GUI(events).list xview"
     
    grid $GUI(events).list -row $row -column 0 -sticky news -columnspan 2
    grid $GUI(events).yscroll -row $row -column 2 -sticky ns
    grid columnconfigure $GUI(events) 0 -weight 1
    grid columnconfigure $GUI(events) 1 -weight 1
    grid rowconfigure $GUI(events) $row -weight 1
    incr row
    grid $GUI(events).xscroll -row $row -column 0 -sticky ew -columnspan 2
    
    # Define control notebook page

    set GUI(control) [$GUI(nb) insert end control -text "Control Script"]
    
#    set menu [menu $GUI(control).mm -type menubar -relief groove ]
    set menu [frame $GUI(control).mm -relief groove]
    grid $menu -row 0 -column 0 -columnspan 3 -sticky ew

    #             Create the replay menus
    # File menu
    
#    $menu add cascade -label "File" -menu $menu.file 
    menubutton $menu.f -text "File" -menu  $menu.f.file 
    grid $menu.f -row 0 -column 1

    set mf [menu $menu.f.file -tearoff 0]
    $mf add command -label "Open..." -command "LoadControlBox"
    $mf add command -label "Save" -command "SaveControlBox"
    $mf add command -label "Save As..." -command "SaveAsControlBox"

    #
    # Edit menu
    #
    #$menu add cascade -label "Edit" -menu $menu.edit 
    menubutton $menu.e -text "Edit" -menu $menu.e.edit 
    grid $menu.e -row 0 -column 2

    set mf [menu $menu.e.edit -tearoff 0]
    $mf add command -label "Erase script" -command "EraseControl"
    $mf add separator
    
    set GUI(bbox) [ButtonBox $GUI(control).box1 -spacing 0 -padx 1 -pady 1]
    grid $GUI(bbox) -row $row -column 0 -sticky w

    # Fill the button bar

    set cmds {
              play      "Play Control Script"      "PlayControlGUI Normal"
	      fforward  "Play Control Script Fast" "PlayControlGUI Fast"
	      rewind    Rewind      Rewind
	      stop      Stop        {set ReplayData(ControlRun) 0}
              pause     Pause       AddPause
	      }
    
    foreach {img help cmd} $cmds {
      set GUI(button.$img) [$GUI(bbox) add -image $img \
        -helptext $help \
	-height 20 -width 20 \
        -command $cmd ]
    }

    set GUI(bbox2) [ButtonBox $GUI(control).box2 -spacing 0 -padx 1 -pady 1]
    grid $GUI(bbox2) -row $row -column 1 -sticky w
    incr row


    set cmds {
	      edit16T "Insert a Script" InsertControl
              erase16T  "Erase Script"       EraseControl
	      }
    
    foreach {img help cmd} $cmds {
      set GUI(button.$img) [$GUI(bbox2) add -image $img \
	-height 20 -width 20 \
        -helptext $help \
        -command $cmd ]
    }
    
    set ReplayData(controlText) [text $GUI(control).txt -width 40 \
        -xscroll "$GUI(control).xsb set" -yscroll "$GUI(control).ysb set" \
	-wrap none \
        -height 20 -background white]
    scrollbar $GUI(control).xsb -orient horizontal -command "$GUI(control).txt xview"
    scrollbar $GUI(control).ysb -orient vertical -command "$GUI(control).txt yview"

    grid $GUI(control).txt -row $row -column 0 -columnspan 2 -sticky news
    grid $GUI(control).ysb -row $row -column 2 -sticky ns
    grid columnconfigure $GUI(control) 0 -weight 1
    grid columnconfigure $GUI(control) 1 -weight 1
    grid rowconfigure $GUI(control) $row -weight 1

    incr row
    grid $GUI(control).xsb -row $row -column 0 -sticky ew -columnspan 2
    
    set ReplayData(Status) Disconnected
    
  wm withdraw .replay
  update idle;
  wm geometry .replay -5-70
  wm deiconify .replay
  return
}

proc SetScriptFileName {} {
    global ReplayData
    set ReplayData(ScriptFileName) \
        [file tail $ReplayData($ReplayData(Level),ScriptFileName)]
}



