# source /tmp/invoke.tcl

set Release(rebind.tcl) {$Header: /home/cvs/tktest/rebind.tcl,v 1.21 2014/07/21 23:13:20 clif Exp $}

################# DEBUGGING STUFF ###################
################# For use at client end #############
proc whereAmI-Client {} {
    set lvup [info level]
    for {set i $lvup} {$i > 0} {incr i -1}  {
        if {[string first Debug [info level $i] ] >= 1} {
	  continue
	}
#        RemoteMsgToUser "LVLC: --$i-- [info level $i] ---"
    }
}

proc rebindDebug {str} {
# return
  global SockData
  set SockData(debug) 1
  socksendDebug $str
  set SockData(debug) 0
}

############ REAL STUFF ###########################################

###################################################################
# This file is sourced by the application we are recording.
# It makes all the changes necessary to set up record and replay.
###################################################################
#
# if we are already connected then skip everything
#
global db__rd
if {[info exists db__rd(RebindingComplete)]} {
   RemoteMsgToUser "Already bound to $db__rd(ThisApp)" low
} else {
###################################################################
# Set up some variables we will need.
###################################################################
set db__rd(ThisApp)       [winfo name .]
set db__rd(UIDCounter)    0
set db__rd(ActionTimeOut) 8000
# This needs and inital value in some cases.
set db__rd(timeout)       8000
set db__rd(WaitingFor)    -1
###################################################################
# Define tkrsend if it is not already defined.
###################################################################
if {[string compare [info commands tkrsend] ""] == 0} {
#    proc tkrsend {args} {
# socksendDebug "TKRSENDB: ARGS: $args"
#        return [eval send $args]
#    }
  error "Missing tkrsend command"
}
###################################################################
# RemoteMsgToUser: send comments to TkReplay to display.
###################################################################
proc RemoteMsgToUser {msg {level info}} {
    global db__rd
    # Don't bother with all the failures on winfo root[xy]
    #  messages caused when a popup was deleted.
    #
    # There may be a better way to catch the <Delete> 
    #  messages, but I'm not sure how to distinguish between
    #  ones that may be required and ones that aren't.
    
    if {[string first "winfo root" $msg] >= 0} {
      return
    }
    set cmd [format {MsgToUser {%s} {%s}} $msg $level]
    # use catch in case TkReplay is exited
    catch [list tkrsend $db__rd(ReplayApp) $cmd]
}
###################################################################
# FixEventName: put an event name into a standard form.  We let Tk 
#    do the conversion to its standard form by binding a dummy widget.
#
#   We need to do this because some events can be specified in several
#   different ways.  For example <1>, <Button-1> and <ButtonPress-1>
#   are all ways to specify the same events.  The standard form
#   (that Tk returns) is <Button-1>.  Since we store event bindings
#   by the name of the event we have to use the same event name all
#   the time.
###################################################################
proc FixEventName {event_in} {
    label .dummy__rd
    bind__rd .dummy__rd $event_in {#}
    set event_out [bind__rd .dummy__rd]
    if {[catch "destroy .dummy__rd" ret]} {
        # puts "destroy .dummy__rd failed: $ret"
    }
    return $event_out
}
###################################################################
# RebindWidgetAndChildren: rebind one widget and then all its children.
#   This proc is called with "." when we connect (the call is at the end
#   of this file) to rebind all the existing widgets.  Our control
#   of the bind command and the widget creation command ensures that
#   we redefine all new bindings that are created after the call
#   to "RebindWidgetAndChildren ."
###################################################################
proc RebindWidgetAndChildren {w} {
    global db__rd
    RebindOneWidget $w
    foreach child [winfo children $w] {
        RebindWidgetAndChildren $child
    }
}
###################################################################
# RebindOneWidget: we want to redefine all new bindings.  Bindings are
#   not attached directly to widgets but to tags which are then attached
#   to widgets.  So we go through all the tags associated with this widget.
#   For each event bound to that tag we define the binding with
#   RebindOneEvent.
#
#   We check for tags we have already redefined and do
#   not do them over.  This will mainly be class tags (Button, Text, etc.)
#
#   We also add a CatchClicks tag to the bindtag list for each widget.
#   This allows us to get control back during replay.
###################################################################
proc RebindOneWidget {w} {
    global db__rd

    set lvup [set lv [info level]]
    
    # Don't bother reporting the .dummy rebinds.
    if {[string first .dummy__rd $w] < 0} {
      RemoteMsgToUser "Rebinding [winfo class $w] $w"
    }

    # Handle the special cases first

    RebindSpecialCases $w

    # A kludgy way to get the events I need to simulate the
    #  menu actions on windows where the events don't match
    #  X-11.

    if {[string equal "Menubutton" [winfo class $w]]} {
      
    }

    if {[string equal Menu [winfo class $w]] &&
        ([string first # $w] < 1)} {
        bind $w <Motion> "WinMenuMotion $w %W %x %y"
        bind $w <ButtonRelease-1> "WinMenuRelease $w %W %x %y"
        bind $w <ButtonRelease-2> "WinMenuRelease $w %W %x %y"
        bind $w <ButtonRelease-3> "WinMenuRelease $w %W %x %y"
#        bind $w <ButtonRelease> "WinMenuRelease $w %W %x %y"
        bind $w <ButtonPress-1> "WinMenuPress $w %W %x %y"
        bind $w <ButtonPress-2> "WinMenuPress $w %W %x %y"
        bind $w <ButtonPress-3> "WinMenuPress $w %W %x %y"
        bind $w <Enter> "WinMenuEnter $w %W %x %y %s %m"
        bind $w <Leave> "WinMenuLeave $w %W %x %y %s"
        bind $w <ButtonRelease> "WinMenuRelease $w %W %x %y"
        bind $w <ButtonPress> "WinMenuPress $w %W %x %y"
        set db__rd($w.active) none
#        bind Menu <ButtonPress> "WinMenuPress Menu %W %x %y"
#  The next binding breaks getting the <Button-1> event from popup menus
#        bind Menu <ButtonRelease> "tk::MenuEscape %W"

    } else {
      #
      # find all tags that must be rebound for this widget
      #
      set bt [bindtags__rd $w]
      foreach tag $bt {
          #
          # rebind each event defined for this class or widget
          #
          foreach event [bind__rd $tag] {
              set binding [bind__rd $tag $event]
# puts "BINDING: $tag -- $event -- $binding"
              RebindOneEvent $tag $event $binding
          }
      }
      # so we can stop replays with a mouse button click
    #  bindtags__rd $w [linsert $bt 0 CatchClicks]
    }

}

proc WinGetApp {} {
    global SockData

    # Note - there was a .channel here, but I can't find anyplace that
    # uses the .channel except this.
    set name [lindex [array names SockData *,channel] 0]
    # foreach {app chn} [split $name .] {break;}
    regsub {,channel} $name {} app
    if {![info exists app]} {
      puts "FAILED: NAME: $name"
      parray SockData
    }
puts "NAME: $name APP: $app "
    return $app
}

proc WinMenuRelease {win W X Y} {
    global db__rd ReplayData
rebindDebug "WINMENURELEASE: $win -- $W -- $X -- $Y"
    set active [$win index active]
    if {[string equal "none" $active]} {return}

    set app [WinGetApp]

    if {[catch {$win entrycget $db__rd($win.active) -command} command]} {
rebindDebug "Early Return WINMENURELEASE: $win -- $W -- $X -- $Y"
        return
    }
# puts "COMMAND: ..$command.." 
# INVOKE ALL MENU RELEASES ?
#    if {![string equal $command ""]} {
      # This is a command button, we should invoke it.
      set cmd [format "%s invoke %d" $win $active]
#      tkrsend $app \
#        [list RecordTcl ThisApp [list "tkrsend \$::db__rd(ThisApp) [list $cmd]" 1]]

# Kludge to get around popups getting invoked twice while recording
# once from here, and once from (I think) the Menu <ButtonRelease> event.
rebindDebug "$db__rd(Replaying) :: WINMENURELEASE EVAL: $win [winfo class $win] -- $W $cmd -- $::tk::Priv(popup)"
if {$db__rd(Replaying) || [string match {} $::tk::Priv(popup)]} {
# rebindDebug "WINMENURELEASE EVAL: $win [winfo class $win] -- $W $cmd -- $::tk::Priv(popup)"
# set out {}
      set fail [catch $cmd out]
# rebindDebug "WINMENURELEASE EVAL RSLT: $fail $out"
}
      # And unpost any posted menus
      foreach win $db__rd(Posted) {
rebindDebug "WINMENURELEASE: Posted: $win"
        if {[string equal . [winfo parent $win]] && [string equal {} $::tk::Priv(popup)]} {
	  continue
	}
        set cmd [format {catch {%s unpost}} $win ]
rebindDebug "unpost: $cmd -- [winfo class $win] -- [winfo parent $win]"
#        tkrsend $app \
#          [list RecordTcl ThisApp [list "tkrsend \$::db__rd(ThisApp) [list $cmd]" 1]]
      eval $cmd
      }	  
#    }
rebindDebug "DONE - WINMENURELEASE: $win -- $W -- $X -- $Y"
}

proc WinMenuPress {win W X Y} {
    global db__rd ReplayData
#  puts "WINMENUPRESS: $win -- $W -- $X -- $Y"
    set active [$win index active]
    if {[string equal "none" $active]} {return}

    set app [WinGetApp]
    if {[catch {$win entrycget $db__rd($win.active) -menu} menu]} {
        return
    }
    
    if {![string equal $menu ""]} {
      # This is a pulldown menu button, we should post it.
# puts "POSTING $menu"
      set cmd [format \
          {%s post [expr [winfo rootx .] + %d]  [expr [winfo rooty .] + %d] } \
	  $menu $db__rd($win.X) $db__rd($win.Y)]
#      tkrsend $app \
#        [list RecordTcl ThisApp [list "tkrsend \$::db__rd(ThisApp) [list $cmd]" 1]]
      eval $cmd
      lappend db__rd(Posted) $menu
    }
}

proc WinMenuEnter {win W x y s m} {
    global db__rd ReplayData
    
# puts "INTO WinMenuEnter win $win W $W x $x y $y s $s m $m "
if {[string first ".#" $W] == 0} {
  return
}
rebindDebug "win $W -- $x -- $y -- $s -- $m"
    set db__rd($win.X) $x
    set db__rd($win.Y) $y

    set tk::Priv(window) $W
    if {[$W cget -type] eq "tearoff"} {
	if {"$m" ne "NotifyUngrab"} {
	    if {[tk windowingsystem] eq "x11"} {
		tk_menuSetFocus $W
	    }
	}
    }
    tk::MenuMotion $W $x $y $s

    # Do It To It

  if {[winfo toplevel $win] ne "$win"} {
    return
  }
  set cmd [format \
      {%s post [expr [winfo rootx .] + %d]  [expr [winfo rooty .] + %d] } \
      $win $db__rd($win.X) $db__rd($win.Y)]
  if {![winfo viewable $win]} {
    rebindDebug  "$cmd"
    set fail [catch {eval $cmd} out]
  }
 rebindDebug  "Done with EnterMenu"
# puts "OUT OF WINMENUENTER"
}

proc WinMenuLeave {menu W rootx rooty state} {
    global db__rd ReplayData
#  puts "WINMENULEAVE: $menu - $W - $rootx -- $rooty -- $state"

    variable ::tk::Priv
    set Priv(window) {}
    if {[string equal [$menu index active] "none"]} {
	return
    }

    set active [$menu index active]
    if {[string equal "none" $active]} {return}

    set app [WinGetApp]
    if {[catch {$menu entrycget $db__rd($menu.active) -menu} menu]} {
        return
    }

    if {[string equal [$menu type active] "cascade"]
          && [string equal [winfo containing $rootx $rooty]  [$menu entrycget active -menu]]} {
	return
    }
    $menu activate none
    ::tk::GenerateMenuSelect $menu



#     if {![string equal $menu ""]} {
#       # This is a pulldown menu button, we should post it.
# # puts "POSTING $menu"
#       set cmd [format \
#           {%s post [expr [winfo rootx .] + %d]  [expr [winfo rooty .] + %d] } \
# 	  $menu $db__rd($win.X) $db__rd($win.Y)]
# #      tkrsend $app \
# #        [list RecordTcl ThisApp [list "tkrsend \$::db__rd(ThisApp) [list $cmd]" 1]]
#       eval $cmd
#       lappend db__rd(Posted) $menu
#     }
}


proc WinMenuMotion {win W X Y} {
    global db__rd ReplayData
    set app [WinGetApp]
# puts "WinMenuMotion: $win $W $X $Y"

    if {[string match $W $win]} {
        set db__rd($win.X) $X
        set db__rd($win.Y) $Y
	set active [$win index active]

        if {[string equal "none" $active]} {return}

	if {$active != $db__rd($win.active)} {
          set cmd [format "%s activate %d" $win $active]
          tkrsend $app [list RecordTcl ThisApp [list "tkrsend \$::ReplayData(ConnectedApps) [list $cmd]" 1]]
	  set db__rd($win.active) $active
	  set db__rd(Posted) $W
	}
    }
}
###################################################################
# RebindOneEvent:  we define one event of one tag.
#   We save the actual tcl script that the event is bound to in th
#   db__rd table (tcl associative array).
#
#   We scan the tcl script to find all the
#   %-field tags it uses.  We do this because our replacement script
#   has to capture all those percent fields so we can insert them
#   into the actual tcl script when we are recording and when we are
#   replaying.  We make sure to always capture the x and y (mouse
#   position) fields so we can move the mouse smoothly during replay.
#
#   The rebinding is done by calling the real Tk bind command, bind__rd.
###################################################################
proc RebindOneEvent {tag event binding} {
    global db__rd
    #
    # do not rebind if it has already been rebound
    #
 # puts "RebindOneEvent $tag $event $binding : [string first cb__rd [string trim $binding ]] "


    if {[string first cb__rd [string trim $binding ]] != 0} {
        #
        # handle the case where we are adding to a binding
        #
        if {[string compare [string index $binding 0] "+"] == 0} {
            # get the old binding (if there is one)
        if {[info exists db__rd(Bind,$tag,$event)]} {
        # append the new binding to the old binding
                set oldBinding $db__rd(Bind,$tag,$event)
        } else {
            set oldBinding {}
        }
        set binding [format {%s%s%s} \
            $oldBinding \
            "\n" \
            [string range $binding 1 end]]
        }
    set db__rd(Bind,$tag,$event) $binding
    #
    # find out what %-fields it requires
    # (GetPercentFields will always include %W because we use it)
    #
    set percentFields [GetPercentFields $binding]
    # make sure we pick up the mouse coordinates
    if {[string first "\{x " $percentFields] < 0} {
        lappend percentFields [list x %x]
    }
    if {[string first "\{y " $percentFields] < 0} {
        lappend percentFields [list y %y]
    }
    # do the rebinding
    bind__rd $tag $event \
            [format {cb__rd {%s} {%s} {%s}} $tag $event $percentFields]
    }
}
###################################################################
# GetPercentFields: this proc scans a tcl script and finds all the
#   strings of the form "%?" where "?" is some letter.  These are
#   the "percent fields" that need to be replaced with fields from
#   the X event structure before the binding is evaluated.
#
#   The return value is a list of pairs where each pair has the form:
#   {W %W}, {$x x}, etc.  This makes an association list that is easy
#   for the code that does the replacements to use.
###################################################################
proc GetPercentFields {action} {
    set exp {[^%]*%(.)[^%]*}
    if {[regsub -all $exp $action "{\\1 \{%\\1\}} " fields]==0} {
        set fields {}
    }
    set result [list [list W %W]]
    foreach item $fields {
        set pcfield [lindex $item 1]
        if {$pcfield == "%%"} continue
        if {[string first $pcfield $result] < 0} {
            lappend result $item
        }
    }
    return $result
}
###################################################################
# RedefineTextCommand: redefine the widget command for an individual
#   text widget.  We must do this so we can detect changes in the
#   internal text widget bindings after the text widget is created.
#
#   We check each subcommand to see if it is the
#   "tag bind $tag $sequence $binding"
#   subcommand.  We handle that one ourselves and all the other subcommands
#   are passed to the real text widget command.
#
#   We create the "proc" command with a format so we can insert the
#   right things but keep everything else from being evaluated too
#   early.  Then we eval the proc command at the global level.
###################################################################
proc RedefineTextCommand {w} {
    global db__rd
    # In Itk, a windows access command can be different from its name
    # This will translate the window name to the access command if we are
    # running Itcl2.  Otherwise it will have no effect
    catch {set w [info commands $w]}
    # rename the widget command
    set neww [format {%s__rd} $w]
    rename $w $neww
    set cmd [format {
        proc %s {subcmd args} {
            if {([string compare $subcmd "tag"]==0)
             && ([string compare [lindex $args 0] "bind"]==0)
             && ([llength $args]==4)} {
                set tag [lindex $args 1]
                set event [FixEventName [lindex $args 2]]
                set binding [lindex $args 3]
                RebindTextBinding %s $tag $event $binding
                return ""
            } else {
                # uplevel is necessary so that the text command gets
                # evaluated in the right context.
                return [uplevel 1 %s $subcmd $args]
            }
        }
    } $w $w $neww]
    uplevel #0 $cmd
}
###################################################################
# RedefineCanvasCommand: redefine the widget command for an individual
#   canvas widget.  We must do this so we can detect changes in the
#   internal canvas widget bindings after the canvas widget is created.
#
#   We check each subcommand to see if it is the
#   "bind $tagOrId $sequence $binding"
#   subcommand.  We handle that one ourselves and all the other subcommands
#   are passed to the real text widget command.
#
#   We create the "proc" command with a format so we can insert the
#   right things but keep everything else from being evaluated too
#   early.  Then we eval the proc command at the global level.
###################################################################
proc RedefineCanvasCommand {w} {
    global db__rd
    # In Itcl2, a windows access command can be different from its name
    # This will translate the window name to the access command if we are
    # running Itcl2.  Otherwise it will have no effect
    catch {set w [info commands $w]}
    # rename the widget command
    set neww [format {%s__rd} $w]
    rename $w $neww
    set cmd [format {
        proc %s {subcmd args} {
            global db__rd
            set current $db__rd(Current)
            if {$db__rd(Replaying) && ($current != "")} {
                set newArgs {}
                foreach arg $args {
                    if {[string compare $arg "current"] == 0} {
                        lappend newArgs $current
                    } else {
                        lappend newArgs $arg
                    }
                }
                set args $newArgs
            }
            if {([string compare $subcmd "bind"]==0)
             && ([llength $args]==3)} {
                set tag [lindex $args 0]
                set event [FixEventName [lindex $args 1]]
                set binding [lindex $args 2]
                RebindCanvasBinding %s $tag $event $binding
                return ""
            } else {
                # uplevel is necessary so that the text command gets
                # evaluated in the right context.
                return [uplevel 1 %s $subcmd $args]
            }
        }
    } $w $w $neww]
    uplevel #0 $cmd
}
###################################################################
# RedefinePadCommand: redefine the widget command for an individual
#   pad widget.  We must do this so we can detect changes in the
#   internal canvas widget bindings after the canvas widget is created.
#
#   We check each subcommand to see if it is the
#   "bind $tagOrId $sequence $binding"
#   subcommand.  We handle that one ourselves and all the other subcommands
#   are passed to the real text widget command.
#
#   We create the "proc" command with a format so we can insert the
#   right things but keep everything else from being evaluated too
#   early.  Then we eval the proc command at the global level.
###################################################################
proc RedefinePadCommand {w} {
    global db__rd
    # In Itcl2, a windows access command can be different from its name
    # This will translate the window name to the access command if we are
    # running Itcl2.  Otherwise it will have no effect
    catch {set w [info commands $w]}
    # rename the widget command
    set neww [format {%s__rd} $w]
    rename $w $neww
    set cmd [format {
        proc %s {subcmd args} {
            global db__rd
            set current $db__rd(Current)
            if {$db__rd(Replaying) && ($current != "")} {
                set newArgs {}
                foreach arg $args {
                    if {[string compare $arg "current"] == 0} {
                        lappend newArgs $current
                    } else {
                        lappend newArgs $arg
                    }
                }
                set args $newArgs
            }
            if {([string compare $subcmd "bind"]==0)
             && ([llength $args]>=3)} {
                set tag [lindex $args 0]
                set event [FixEventName [lindex $args 1]]
                set binding [lindex $args 2]
                set mode [lindex $args 3]
                if {[string length $mode] == 0} {
                    set mode all
                }
                RebindPadBinding %s $tag $event $mode $binding
                return ""
            } else {
                # uplevel is necessary so that the text command gets
                # evaluated in the right context.
                return [uplevel 1 %s $subcmd $args]
            }
        }
    } $w $w $neww]
    uplevel #0 $cmd
}
###################################################################
# RebindSpecialCases: handle the widgets that need special processing.
#   These are widgets that have their own internal binding system.
#   
#   For Text widgets, we redefine the command itself and then go through
#   all the tags and all events bound to that tag and redefine the
#   binding.
#
#   For Canvas widgets we have to do a ltitle more work.  There is no
#   easy way to get all the existing tags but we can go through each
#   item on the canvas.  So, first, we go through each item and do two
#   things with each item.  First we find its tags and, if we haven't
#   seen the tag before we add it to our list of all tags on the canvas.
#   Second we rebind the bindings associated with that item.
#
#   Now we have a list of all the tags of the canvas.
#   For each tag we redefine its bindings.
###################################################################
proc RebindSpecialCases {w} {
    global db__rd
    set class [winfo class $w]
    switch -- $class {
        "Text" {
            RedefineTextCommand $w
            foreach tag [$w tag names] {
                foreach event [$w tag bind $tag] {
                    set binding [$w tag bind $tag $event]
                    RebindTextBinding $w $tag $event $binding
                }
            }
        } 
        "Canvas" {
            RedefineCanvasCommand $w
            # go through each item on the canvas
            set tags {}
            foreach item [$w find all] {
                foreach tag [$w gettags $item] {
                    if {[lsearch $tags $tag] < 0} {
                        lappend tags $tag
                    }
                }
                # go through each event bound for that item
                foreach event [$w bind $item] {
                    set binding [$w bind $item $event]
                    RebindCanvasBinding $w $item $event $binding
                }
            }
            foreach tag $tags {
                foreach event [$w bind $tag] {
                    set binding [$w bind $tag $event]
                    RebindCanvasBinding $w $tag $event $binding
                }
            }
        } 
        "Pad" {
            RedefinePadCommand $w
            # go through each item on the pad
            set tags {}
            set items [$w find all]
            # find all does not find item 1, the pad itself
            lappend items 1
            foreach item $items {
                foreach tag [$w gettags $item] {
                    if {[lsearch $tags $tag] < 0} {
                        lappend tags $tag
                    }
                }
                # go through each event bound for that item
                foreach pair [$w bind $item] {
                    regexp -- {([^>]*>)(.*)} $pair junk event mode
                    set binding [$w getbind $item $event $mode]
                    RebindPadBinding $w $item $event $mode $binding
                }
            }
            foreach tag $tags {
                foreach pair [$w bind $tag] {
                    set binding [$w getbind $item $event $mode]
                    RebindPadBinding $w $tag $event $mode $binding
                }
            }
	 }
    }
}
###################################################################
# RebindTextBinding: redefine a text tag binding.
#   First we check to see if the binding has already be redefined.
#   If so we do not redefine it again.
#
#   We redefine it in the usual way.  Tag binding also use %-fields
#   so we capture those and make sure that W, x, and y are captured.
#   We also make sure the percent fields identify this as a Text
#   widget binding.
###################################################################
proc RebindTextBinding {w tag event binding} {
    global db__rd
    if {[string compare "cb__rd" [lindex $binding 0]] != 0} {
        set longTag [format {Text,%s,%s} $w $tag]
        set db__rd(Bind,$longTag,$event) $binding
        set alist [GetPercentFields $binding]
        set alist [lreplace $alist 0 0 \
            [list W {%W}] [list Widget Text] \
            [list x {%x}] [list y {%y}]]
        set cb [format {cb__rd {%s} {%s} {%s}} $longTag $event $alist]
        eval [list ${w}__rd tag bind $tag $event $cb]
    }
}
###################################################################
# RebindCanvasBinding: redefine a canvas binding.
#   First we check to see if the binding has already be redefined.
#   If so we do not redefine it again.
#
#   We redefine it in the usual way.  Canvas binding also use %-fields
#   so we capture those and make sure that W, x, and y are captured.
#   We also make sure the percent fields identify this as a Canvas
#   widget binding.
###################################################################
proc RebindCanvasBinding {w tag event binding} {
    global db__rd
    if {[string compare "cb__rd" [lindex $binding 0]] != 0} {
        set longTag [format {Canvas,%s,%s} $w $tag]
        set db__rd(Bind,$longTag,$event) $binding
        set alist [GetPercentFields $binding]
        set alist [lreplace $alist 0 0 \
            [list W {%W}] [list Widget Canvas] \
            [list x {%x}] [list y {%y}]]
        set cb [format {cb__rd {%s} {%s} {%s}} $longTag $event $alist]
        eval [list ${w}__rd bind $tag $event $cb]
    }
}
###################################################################
# RebindPadBinding: redefine a canvas binding.
#   First we check to see if the binding has already be redefined.
#   If so we do not redefine it again.
#
#   We redefine it in the usual way.  Canvas binding also use %-fields
#   so we capture those and make sure that W, x, and y are captured.
#   We also make sure the percent fields identify this as a Canvas
#   widget binding.
###################################################################
proc RebindPadBinding {w tag event mode binding} {
    global db__rd
    if {[string compare "cb__rd" [lindex $binding 0]] != 0} {
        set longTag [format {Pad,%s,%s} $w $tag]
        set modedEvent [format {%s%s} $event $mode]
        set db__rd(Bind,$longTag,$modedEvent) $binding
        set alist [GetPercentFields $binding]
        set alist [lreplace $alist 0 0 \
            [list W {%W}] [list Widget Pad] \
            [list x {%x}] [list y {%y}]]
        set cb [format {cb__rd {%s} {%s} {%s}} $longTag $modedEvent $alist]
        eval [list ${w}__rd bind $tag $event $cb $mode]
    }
}
###################################################################
# cb__rd: general callback for all bindings.
#
#   First it makes some adjustments to the %-field replacement list.
#   Second it sends a message to TkReplay to record the event.
#   Third, it executes the action using DoAction.
###################################################################
proc cb__rd {tag event percentFields args} {
    global db__rd

#  puts "CB__RD: [info level] [info exists db__rd(actionID)] -- $tag -- $event -- $percentFields -- $args --    "

    # only do the callback when we are recording.  Ignore when replaying.
    if {$db__rd(Replaying)} {
        return
    }
    #
    # add some percent fields that will be needed later
    #

    lappend percentFields [list Args "$args"]
    set w [lookup W $percentFields]
    set class_of_w [winfo class $w]
    if {$class_of_w == "Canvas"} {
        lappend percentFields [list Widget Canvas] \
            [list Current [$w find withtag current]]
    }
    #
    # record the event with TkReplay
    #
    # special case for option menus -- kludgey!
    #
    if {$event == "<Button-1>" && $class_of_w == "Menubutton" } {
        if {[$w cget -indicatoron]} {
            #
            # If it is a button 1 press on a menu button and the
            # menu button has the indicator on then we assume this
            # is an option menu.  This is also special cased in
            # the Tk library file menu.tcl.  If there is no Y
            # value then it will put the menu over the menubutton.
            #
            set n [lsearch -glob $percentFields "Y {*}"]
            if {$n >= 0} {
                set percentFields [lreplace $percentFields $n $n]
            }
        }        
    }
    set cmd [format {RecordAction {%s} {%s} {%s} {%s}} \
        $db__rd(ThisApp) $tag $event $percentFields]

    # Don't send Delete dummy commands - they are internal
    #  not of interest to the Replay.

    if {[string equal $tag "."] &&
        [string equal $event "<Destroy>"] &&
	([string first "W .dummy__rd" $percentFields] == 1)} {
	 # Do Nothing.
	 # Logic should be if that's all false, send cmd, but 
	 # I think this is easier to read.
    } else {
         # use catch in case TkReplay has exited
         catch [list tkrsend $db__rd(ReplayApp) $cmd]
    }

    # Execute the real binding.  We have to catch the return code
    # and return it from this binding.

    set code [catch \
          [list DoAction $db__rd(Bind,$tag,$event) $percentFields] errMsg]
    global errorInfo errorCode

    return -code $code -errorinfo $errorInfo -errorcode $errorCode $errMsg 
}
###################################################################
# ReplayAction: this is a little complicated because of the possibility
#   that a bindings might not return for a long time.  For example, the
#   binding code
#   might have a tkwait in it.  So we set a timeout before we execute
#   the binding.  The timeout delay is determined by the replay appplication
#   and sent with the call.  This timeout (ActionEnd) will send a reply
#   message back when the timeout delay is over.  Then we call the
#   action and send a reply when it completes.  This procedures is called
#   with an asynchronous send so we do not need to worry about DoAction
#   not returning and hanging the send.
#   TkReplay will always get two replies but it will act on the one it
#   gets first and ignore the other one.  This requires each action to
#   have a unique id (which is assinged by TkReplay).
###################################################################
proc ReplayAction {actionID timeout subscript replaceList} {
    global db__rd
    # save these values in case a "tkwait" is called
    set db__rd(timeout) $timeout
    set db__rd(actionID) $actionID
    if {[info exists db__rd($subscript)]} {
        set action $db__rd($subscript)
    } else {
        # This may happen if events are unbound
        set action "\#"
    }
    # Remember the return code returned by an error
    set ecode [catch error]
    # Do the action and remember the return code
    set code [catch {DoAction $action $replaceList} ret]
    # Tell tkreplay we finished
    catch [list tkrsend $db__rd(ReplayApp) \
        [list ActionEnd $actionID completion]]
    # If we generated an error, return it
    # otherwise (normal return, break, or continue) just do a normal return
    if {$code == $ecode} {
        global errorCode errorInfo
        return -code $code -errorcode $errorCode -errorinfo $errorInfo $ret
    } else {
        return $ret
    }
}
###################################################################
# DoAction: this procedure executes the original binding for an action.
#    It is used while recording events to execute the action requested and
#        it is used when replaying events to replay the action.
#    Notes:
#    (1) we must do the %-substitutions just like the event binding
#        expects.  This is done by SubInAction.
#    (2) we put in the special case for canvas because we have to handle
#        the "current" tag correctly.  We capture the "current" object
#        when we make the recording and substitute it for the string
#        "current" in the binding.
#    (3) we have to execute the binding at the global scope, that is
#        why we use "uplevel #0"
###################################################################
proc DoAction {action replaceList} {
    global db__rd
    if {$action == {} || \
	([string first "W .dummy__rd" $replaceList] == 1)} {
        return 0
    }

rebindDebug "DoAction: $action .. $replaceList.."

    # This is only important for canvases.
    # For other widgets db__rd(Current) will be set to the empty string.
    set db__rd(Current) [lookup Current $replaceList]
    if {$action == "%Z"} {
        set cmd [lookup Z $replaceList]
        set replaceList {}
    } else {
        if {[lookup q $replaceList] == ""} {
            # if there is no %q in the replace list yet, make it equivalent
            # to %W.  This is done to make Itcl2 work.
            lappend replaceList [list q [lookup W $replaceList]]
        }
        set cmd [SubInAction $action $replaceList]
    }

    if {[info exists db__rd(actionID)]} {
        after__rd $db__rd(timeout) [list catch \
            [list tkrsend $db__rd(ReplayApp) \
                [list ActionEnd $db__rd(actionID) timeout]]]
    }

    #
    # Execute the real binding.  We have to catch the return code
    # and return it from this binding.
    #
rebindDebug "CMD: $cmd"
    set code [catch [list uplevel \#0 $cmd] ret]
    global errorInfo errorCode
    return -code $code -errorinfo $errorInfo -errorcode $errorCode $ret
}
###################################################################
# SubInAction: this procedure takes an action script and does
#     all the %-replacements.  The parameters "replaceList" contains
#     all the necessary replacement strings.
###################################################################
  proc SubInAction {action replaceList} {
    set doublePercent 0; # this is used to keep track of %%s
    # split the list at the % signs
    set parts [split $action %]
    # Copy the first part directly, because it was not preceded by a %.
    # If action starts with a percent, then the first part will
    # be an empty string, so this works.
    append subbedAction [lindex $parts 0]
    foreach part [lrange $parts 1 end] {
        # Copy this part directly if we just detected a double percent
        if { $doublePercent } {
            append subbedAction $part
            set doublePercent 0
            continue
        }
        # If there is a %%, part will be empty, add a %
        # and skip the next part
        if { "$part" == "" } {
            append subbedAction "%"
            set doublePercent 1
            continue
        }
        # Get the character after the % (the first character in the part)
        set ch [string index $part 0]
        # Append its replace value along with the remainder of this part
        append subbedAction [lookup $ch $replaceList] [string range $part 1 end]
      }
      return $subbedAction
  }
###################################################################
# SubForCurrent: this procedure takes an action script and 
#    replaces all instances of "current" as a token with the value
#    passed for current
###################################################################
proc SubForCurrent {action current} {
    regsub -all -- {([^a-zA-Z])current([^a-zA-Z])} \
        $action [format {\1%s\2} $current] subbedAction
    return $subbedAction
}
###################################################################
# lookup: lookup a %-character in the association list.
#     The format of "alist" is:
#         { {A a-string} {B b-string} ...}
###################################################################
proc lookup {item alist} {
    set index [lsearch $alist "$item *"]
    if { $index != -1 } {
	set pair [lindex $alist $index]
	return [lindex $pair 1]
    } else {
	return ""
    }
  }
###################################################################
#                       INITIALIZATION CODE
###################################################################
# This is the database entry for all scrollbar autorepeat events.
# The scrollbar widget path name and the element being autoscrolled
# is recorded in the percent substitution list
#
set db__rd(Bind,Scrollbar,<AutoRepeat>) {tkScrollSelect %W %E again}
set db__rd(Bind,After,<AutoRepeat>) {%Z}
###################################################################
# List of widget commands.  Add your widget to this list if you want to
#    be able to record its events.
###################################################################
# USER OPTION: you can add widget creation commands to this list to get
# TkReplay to record their interactions also.
#
set WidgetCreateCommands {button canvas checkbutton entry frame label 
    listbox menubutton menu message radiobutton scale scrollbar text 
    toplevel labelframe panedwindow }
###################################################################
# Set up some database entries
###################################################################
# Current is used to hold the canvas ID of the "current" object during the
# replay of canvas commands.
#
set db__rd(Current) ""     ;# just so this is always defined
set db__rd(Replaying) 0    ;# we are not replaying a script (yet)

proc bgerror {msg} {
    global errorInfo
    puts "ERROR(replay): $msg ==> $errorInfo"
}
    
###################################################################
# Rename all the commands we need to intercept, that is, after, bind and all
#   of the widget creation commands.  This way we will know when a new
#   widget is created and when a binding is changed in an existing widget.
###################################################################
rename after after__rd
rename bind bind__rd
rename bindtags bindtags__rd
rename tkwait tkwait__rd
rename vwait vwait__rd
#
foreach cmd $WidgetCreateCommands {
    if {[info commands $cmd] != ""} {
        rename $cmd [format {%s__rd} $cmd]
    } else {
        puts "Command $cmd not found so we could not redefine it"
    }
}
###################################################################
# Redefine all the commands we just renamed.
###################################################################
# redefine all the widget creation commands -- each one will create the
#   widget and then call our proc to redefine the bindings of the new
#   widget.
#
foreach cmd $WidgetCreateCommands {
    set cmdrd [format {%s__rd} $cmd]
    if {[info commands $cmdrd] != ""} {
        eval [format {
            proc %s {w args} {
                global db__rd
                # create the object first
                uplevel 1 %s $w $args
                RebindOneWidget $w
                return $w
            }
        } $cmd $cmdrd]
    }
}
###################################################################
# after -- we record the event the after command causes on recording
#   but on replay we do not do actual "after"s but instead just
#   repeat the events that happened.  This should eliminate timing
#   dependencies.
###################################################################
proc after {subcommand args} {
    global db__rd
    if {$db__rd(Replaying)} {
        # do not do "after"s while replaying
	#  -- Except for idle - this is necessary for the 
	#   file dialog that uses the after idle to update the
	#   selection window.
	if {[string equal $subcommand idle]} {
            if {$args != {}} {
                uplevel 1 after__rd $subcommand $args
            }
	}
        return
    }
    # fix args -- if args = "{cmd arg}" then concat will not removes the {}s
    # and so the uplevel done later will fail with a bad command "cmd arg"
    if {[llength $args] == 1} {
        set args [lindex $args 0]
    }
    switch $subcommand {
        cancel -
        idle {
            # these commands we let the "real" after take care of
            if {$args != {}} {
                uplevel 1 after__rd $subcommand $args
            }
        }
        default { ;# after ms ...
            # is this a "delay now" after or a "schedule for later" after?
            if {[llength $args] == 0} {
                # delay right now, do it in the contect of the caller
                uplevel 1 after__rd $subcommand
            } else {
                # schedule the after script for later
                # schedule my own after handler that will then
                # call the script after recording that it happened
                set afterid [after__rd $subcommand [list aftercb__rd $args]]
                return $afterid
            }
        }
    }
}
###################################################################
# aftercb__rd -- the callback called when the after interval has
#     elapsed.  It executes the command and records the auto-repeat
#     event for later replays.  During replays the after events
#     are ignored and only the autorepeat events are replayed.
###################################################################
proc aftercb__rd {cmd} {
    global db__rd
    # record that it happened so we can replay it later
    set remotecmd [format {RecordAction {%s} After <AutoRepeat> {{Z {%s}}}} \
                                        $db__rd(ThisApp) $cmd]
    # use catch in case TkReplay has exited
    catch [list tkrsend $db__rd(ReplayApp) $remotecmd]
    # execute the after command
#    eval uplevel #0 $cmd
# puts "aftercb_rd: $cmd"
    uplevel #0 eval [list $cmd]
}
###################################################################
# tkwait -- normally a tkwait means that we need to send a reply
#     back during replay.
###################################################################
proc tkwait {subcommand w} {
    global db__rd
    if {$db__rd(Replaying)} {
        # After the timeout period, send a reply back
        # to the application then tkwait.
        after__rd $db__rd(timeout) [list catch \
            [list tkrsend $db__rd(ReplayApp) \
                [list ActionEnd $db__rd(actionID) timeout]]]
    }
    switch -glob -- $subcommand {
        vi* {
            # tkwait visibility seems to cause a problem
            # this is a quick fix but later I should figure
            # out a better solution
            update idletasks
            # this did not work.  it was always viewable=0
            ###if {![winfo viewable $w]} {
            ###    uplevel 1 tkwait__rd $subcommand $w
            ###} 
        }
        default {
            uplevel 1 tkwait__rd $subcommand $w
        }
    }
}

proc vwait {varName} {
    global db__rd
    whereAmI-Client

    if {$db__rd(Replaying)} {
        # After the timeout period, send a reply back
        # to the application then vwait.
        after__rd $db__rd(timeout) [list catch \
            [list tkrsend $db__rd(ReplayApp) \
                [list ActionEnd $db__rd(actionID) timeout]]]
    }
    uplevel 1 vwait__rd $varName
}


proc bindtags {win args} {
 # puts "LOCAL BINDTAGS: $win -- $args"
    switch -- [llength $args] {
      0 {
        # Return all the events that are bound.
        # Let the real bind do that.
        return [uplevel 1 bindtags__rd $win]
      }
      default {
        # RebindOneWidget Nogo - didn't bind all things
        # RebindOneWidget $win
	foreach tag [lindex $args 0] {
	  set events [bind__rd $tag]
	  foreach event $events {
	    set old [bind__rd $tag $event]
	    RebindOneEvent $tag $event $old
	  }
	}
      }
    }
    return [uplevel 1 bindtags__rd $win $args]
}

###################################################################
# bind -- when an event is bound to a tcl script we change it to
#   a call to our own callback which then calls the tcl script.
###################################################################
proc bind {tag args} {
    global db__rd
 # puts "LOCAL BIND: $tag -- $args"
    switch -- [llength $args] \
    0 {
        # Return all the events that are bound.
        # Let the real bind do that.
        return [uplevel 1 bind__rd $tag]
    } \
    1 {
        # return the binding for this event ($args = $event)
        set index [format {Bind,%s,%s} $tag $args]
        if {[info exists db__rd($index)]} {
            return $db__rd($index)
        } else {
            return ""
        }
    } \
    2 {
        # bind to an event
        set event [FixEventName [lindex $args 0]]
        set binding [lindex $args 1]
        RebindOneEvent $tag $event $binding
        return ""
    } \
    default {
        puts "TkReplay ERROR (in bind): wrong number of args: bind $tag $args"
        return ""
    }
}
RebindWidgetAndChildren .
set db__rd(RebindingComplete) 1
}

