#!/bin/sh
# \
    exec wish $0 ${1+"$@"}
#
# tktest.tcl
#     This is the main program for tktest.
#
set Release(tktest.tcl) {$Header: /home/cvs/tktest/tktest.tcl,v 1.21 2014/07/21 23:18:55 clif Exp $}

lappend auto_path .

package require Tk

source introspect.tcl
source synchronize.tcl
source wmap.tcl
source control.tcl   
source debugging.tcl 
source images.tcl    
source initialize.tcl
source help.tcl
source mainwin.tcl
source connect.tcl
source edit.tcl   
source comment.tcl
source rr.tcl
source socksend/socksend.tcl
source tildefy.tcl

# No useful options in tktest
# source options.tcl


###################################################################
# Set the directory where tktest is installed based on the
# REPLAY_LIBRARY environment variable if it exists.
# Otherwise use the directory where this script resides
if {[info exists env(REPLAY_LIBRARY)]} {
    set ReplayData(HomeDirectory) $env(REPLAY_LIBRARY)
} else {
    set ReplayData(HomeDirectory) [file dirname [info script]]
}
###################################################################
# Set the default wish to use to run applications based on
# the REPLAY_WISH environment variable if it exists.
# Otherwise use wish
if {[info exists env(REPLAY_WISH)]} {
    set ReplayData(DefaultWish) $env(REPLAY_WISH)
} else {
    set ReplayData(DefaultWish) wish
}
#
###################################################################
# Initialization.
###################################################################
global auto_path
global ReplayData
lappend auto_path $ReplayData(HomeDirectory)
wm withdraw .

set ReplayData(scriptFileDir) $ReplayData(HomeDirectory)
source introspect.tcl
source control.tcl
source debugging.tcl
source images.tcl

#
# USER OPTION: you can leave the highlights in
#
# I don't like the highlights so I get rid of them
#
option add {*highlightThickness} 0 widgetDefault
#
Initialize
MakeMessageWindow
MakeReplayWindow
EraseScript
update
#
# read the command line arguments (if any)
#
set len [llength $argv]
set playScript 0

array set ReplayData {
  MyPort 3010
  detailedMessage {}
  appNames {}
  script {}
  demo 0
  playScript {}
}

# Valid -options:
# -demo
# -app 
# -script once only
# -MyPort
# -playScript [normal fast fastonce]
# -pointWithMouse [1 0]
# -pointWithArrow [01]
# 
foreach {k v} $argv {
    set k [string trimleft $k -]
    set ReplayData($k) $v
}

parray ReplayData

    if {$ReplayData(demo)} {
      catch {wm withdraw .}
      catch {wm withdraw .replay}
      after 2000 {catch {wm withdraw .replaypointer}}
      after 2000 {catch {wm withdraw .messageWindow}}
      set ReplayData(pointWithArrow) 1
    }
    
#
# set up socket communication
#

    source socksend/socksend.tcl
    socksendsetup $ReplayData(MyPort)
    proc tkrsend {args} {
socksendDebug "TKRSENDA: ARGS: $args"
        return [eval socksend $args]
    }

  # If in auto-play mode we need to be connected before
  # loading scripts that may kick off a replay event.

  if {$ReplayData(playScript) ne ""} {
    while {$ReplayData(ConnectedApps) eq ""} {
      vwait ::ReplayData(ConnectedApps)
    }
  }

  foreach appName $ReplayData(appNames) {
    LoadAndConnect $appName
  }

if {$ReplayData(script) ne ""} {
#    LoadScript $ReplayData(script)
    LoadControl $ReplayData(script)
}

#
# play script immediately if it was requested
#
if {$ReplayData(playScript) ne ""} {
  switch $ReplayData(playScript) {
      normal { 
	PlayControlGUI Normal
      }
      fast { 
	PlayControlGUI Fast
      }
      fastonce { 
	PlayControlGUI Fast
        after 1000 {exit 0}
      }
    }
}

