
proc getChildrenType {parent} {
  set rtn ""
  foreach ch [getReply "winfo children {$parent}"] {
      set t [getReply "winfo class {$ch}"]
      lappend rtn [list $ch $t]
  }
  return $rtn
}

proc getWindowsRecurse {p} {
    set rtnList {}
    foreach ct [getChildrenType $p] {
        foreach {child type} $ct {}
        lappend rtnList $child
	set lst2 [getWindowsRecurse $child]
	if {[llength $lst2] > 0} {
	  eval lappend rtnList $lst2
	}
    }
    return $rtnList
}


proc showClientWindows {button1Cmd} {
  global Windows
  
  if {[winfo exists .wmap]} {
    wm deiconify .wmap
    raise .wmap
  } else {
    toplevel .wmap
    lassign [split [winfo geometry .replay] +-x] w h x y
    wm geometry .wmap 400x300+$x+$y
  }

  catch {unset Windows}
  
  catch {destroy .wmap.tree .wmap.xwb .wmap.ysb .wmap.q}

  set tree [Tree .wmap.tree -xscrollcommand {.wmap.xsb set} \
      -yscrollcommand {.wmap.ysb set} ]
  scrollbar .wmap.xsb -orient horizontal -command "$tree xview"
  scrollbar .wmap.ysb -orient vertical -command "$tree yview"

  button .wmap.q -text "Cancel" -command "destroy .wmap"
  
  grid $tree -row 1 -column 1 -sticky news
  grid .wmap.ysb -row 1 -column 2 -sticky ns
  grid .wmap.xsb -row 2 -column 1 -sticky ew
  grid .wmap.q -row 3 -column 1

  grid rowconfigure .wmap 1 -weight 1
  grid columnconfigure .wmap 1 -weight 1
  
  set pnts() root
  
  foreach win [getWindowsRecurse .] {
    set p [string last . $win]
    incr p -1
    set pnt [string range $win 0 $p]
    set node [$tree insert end $pnts($pnt) #auto -text $win]
    set pnts($win) $node
    $tree bindText <ButtonPress-1> $button1Cmd
    $tree bindText <ButtonPress-3> {FlashWin}
    set Windows($node) $win
  }
}


proc FlashWin {node} {
  global Windows
  
  set win $Windows($node)
  set origWd [getReply "$win cget -highlightthickness"]
  set origClr [getReply "$win cget -highlightbackground"]
  for {set i 0} {$i < 5} {incr i} {
    getReply "$win configure -highlightthickness 5 -highlightbackground red"
    after 400
    getReply "$win configure -highlightthickness 5 -highlightbackground green"
    after 400
  }
  getReply "$win configure -highlightthickness $origWd -highlightbackground $origClr"
}

