set Release(comment.tcl) {$Header: /home/cvs/tktest/comment.tcl,v 1.15 2016/05/12 13:17:33 clif Exp $}

# AddTcl: this pops up a dialog box that allows the user to enter Tcl code
#   to be executed at this point in the replay.  This proc is only called
#   during recording.
#
proc AddTcl {} {
    global ReplayData
    if {$ReplayData(RecordingOn) == 0} {
        MsgToUser "Tcl can only be inserted while recording a script" low
        return
    }
    set w .replay.addTcl
    #
    # create the window to input the comment
    #
    toplevel $w
    #
    # USER OPTION: you can change this default location.
    #
    wm geometry $w "+0+0"
    #
    # USER OPTION: you can shorten this comment.
    #
    message $w.label -relief raised -bd 2 -width 550 -text "\
        This Tcl code will be executed at this point in the replay.\
        Replay will not continue until this code completes.\
        The code will be sent to all connected applications and executed\
        there unless you check the checkbutton below.\
        Enter the Tcl code you want execute and press Done."
    pack $w.label -side top -fill x
    text $w.text -width 60 -height 8 -relief sunken -bd 2 -bg snow
    pack $w.text -side top
    checkbutton $w.wait \
        -text "Execute the code in the replay (not the target) application" \
        -variable ReplayData(ExecInReplay)
    $w.wait deselect
    pack $w.wait -side top -fill x
    frame $w.buttons -bd 2 -relief raised
    pack  $w.buttons -side top -fill x -ipadx 5 -ipady 5
    button $w.buttons.done -text "Done" \
        -command "set ReplayData(DoneVar) 1"
    pack $w.buttons.done -side left -fill x
    button $w.buttons.cancel -text "Cancel" \
        -command "set ReplayData(DoneVar) 0"
    pack $w.buttons.cancel -side left -fill x
    focus $w.text
    #
    # wait for the Done button
    #
    set ReplayData(DoneVar) 2
    tkwait variable ReplayData(DoneVar)
    set tclScript [$w.text get 1.0 end]
    InsertAction 0 ThisApp ExecTcl [list $tclScript $ReplayData(ExecInReplay)]
    destroy $w
}
#
# AddComment:  this pops up a dialog box that allows the user to enter
#   a comment to be displayed at this point in the replay.  This proc is only
#   called during recording.
#
proc AddComment {} {
    global ReplayData
    if {$ReplayData(RecordingOn) == 0} {
        MsgToUser "Comments can only be added while recording a script" low
        return
    }
    set commentNumber [info cmdcount]
    set w .replay.addComment
    #
    # create the window for the user to enter the comment into
    #
    toplevel $w
    #
    # USER OPTION: you can change this default location.
    #
    wm geometry $w "+0+0"
    #
    # USER OPTION: you can shorten this comment.
    #
    message $w.label -relief raised -bd 2 -width 550 -text "\
        The comment will appear at this point in the replay.\
        Enter the text you want in the comment now and press Text Done.\
        The comment will stay visible (during replay) until after the
        event where you Dismiss this comment box."
    pack $w.label -side top -fill x
    text $w.text -width 60 -height 8 -relief sunken -bd 2 -bg snow
    pack $w.text -side top
    checkbutton $w.wait -text "Wait for user to check Okay" \
        -variable ReplayData(WaitForOkay)
    $w.wait deselect
    pack $w.wait -side top -fill x
    frame $w.buttons -bd 2 -relief raised
    pack  $w.buttons -side top -fill x -ipadx 5 -ipady 5
    button $w.buttons.done -text "Text Done" \
        -command "set ReplayData(DoneVar) 1"
    pack $w.buttons.done -side left -fill x
    button $w.buttons.dismiss -text "Dismiss Comment" \
        -command "EndComment $w $commentNumber" \
        -state disabled
    pack $w.buttons.dismiss -side left -fill x
    button $w.buttons.cancel -text "Cancel" \
        -command "set ReplayData(DoneVar) 0"
    pack $w.buttons.cancel -side left -fill x
    #
    # turn off recording while writing the comment
    #
    set ReplayData(RecordingOn) 0
    focus $w.text
    #
    # wait for the user to finish entering the text of the comment
    #
    set ReplayData(DoneVar) 2
    tkwait variable ReplayData(DoneVar)
    #
    # reconfigure the box to only accept a Dismiss command
    #
    $w.label configure -text "\
        The comment text is now set.  When you get the the point in\
        the script where you want the comment to go away, press Dismiss."
    set comment [$w.text get 1.0 end]
    $w.text configure -state disabled
    $w.buttons.done configure -state disabled
    $w.buttons.cancel configure -state disabled
    $w.buttons.dismiss configure -state normal
    InsertAction 0 ThisApp BeginComment \
        [list $comment $ReplayData(WaitForOkay) $commentNumber]
    # turn on recording and restart the timer
    set ReplayData(RecordingOn) 1
    ReplayTimerTick
}
proc EndComment {w commentNumber} {
    InsertAction 0 ThisApp EndComment $commentNumber
    destroy $w
}
#
# ExecScript: call another script as a subroutine (sub-script).
#
proc ExecScript {} {
    global ReplayData
    set filename [FSBox \
        "Select a script to call at this point in the replay" "Call script"]
    if {$filename == ""} {
       MsgToUser "Exec script cancelled"
       return
    }
    InsertAction 0 ThisApp ExecScript [MakeFileNameRelative $filename]
}
#
# MakeFileNameRelative: change a file name so that it is a relative
# path name, relative to the directory we started in.  This is useful
# for file names we put into scripts since then the scripts can be
# moved more easily.
#
proc MakeFileNameRelative {filename} {
    global ReplayData
    set startupdir [format {%s/} $ReplayData(StartupDir)]
    #
    # find the common prefix (must be at least "/")
    #
    set len [string length $startupdir]
    set ic 0
    while {$ic < $len} {
        if {[string index $startupdir $ic] != [string index $filename $ic]} {
            break
        }
        incr ic
    }
    set relpathname ""
    set n [CountOccurs "/" [string range $startupdir $ic end]]
    for {set i 0} {$i < $n} {incr i} {
        append relpathname "../"
    }
    append relpathname [string range $filename $ic end]
    return $relpathname
}
#
# CountOccurs: count the number of times a substring occurs in a string
#
proc CountOccurs {item str} {
    set count 0
    while 1 {
        set n [string first $item $str]
        if {$n < 0} { return $count }
        incr count
        set str [string range $str [expr $n+1] end]
    }
}
#
# MakeComment: displays a comment on the screen during replay.
#
proc MakeComment {comment wait {id -1}} {
    global ReplayData
    if {$id == -1} {
        set id [GetUniqueID]
    }
    set w [format {.comment%s} $id]
    toplevel $w
    wm title $w "Comment"
    
    #
    # USER OPTION: you can change this default location.
    #
    wm geometry $w "+0+0"
    message $w.msg -aspect 400 -relief raised -bd 2 -text $comment -bg snow
    pack $w.msg -side top
    if $wait {
        button $w.okay -text "Okay" -command "set ReplayData(DoneVar) 1"
        pack $w.okay -side top
        set ReplayData(DoneVar) 0
        update
        tkwait variable ReplayData(DoneVar)
        destroy $w
    }
    update
}
#
# MsgToUser: displays a message on the screen.
#
proc MsgToUser {comment {level info}} {
    global ReplayData
    RecordMessage $comment


    switch -- $level \
        info {
            #.replay.message configure -text $comment
	    set comment [string range $comment 0 80]
	    set ReplayData(StatusMessage) $comment
        } \
        low - \
        medium - \
        high {
#            set w [format {.msg%s} [GetUniqueID]]

             if {($ReplayData(recordFile) ne "") && 
                 ($ReplayData(recordFileInternal) eq "") } {
               set ReplayData(recordFileInternal)  [open $ReplayData(recordFile) w]
             }
    

            set w .msgToUser
	    if {![winfo exists $w]} {
              toplevel $w
              wm title $w "Message to User"
              wm geometry $w [CenterOfScreenGeometry -100 -100]
              text $w.msg -height 20 -width 60 -wrap none \
	          -xscrollcommand "$w.xsb set" \
	          -yscrollcommand "$w.ysb set"
	      scrollbar $w.ysb -orient vertical -command "$w.msg yview"
	      scrollbar $w.xsb -orient horizontal -command "$w.msg xview"
	      grid rowconfigure $w 0 -weight 1
	      grid columnconfigure $w 0 -weight 1
	      grid $w.msg -row 0 -column 0 -sticky news -columnspan 3
	      grid $w.ysb -row 0 -column 3 -sticky ns
	      grid $w.xsb -row 1 -column 0 -sticky ew -columnspan 3
	      set bf [frame $w.buttons]
	      grid $bf -row 2 -column 0 -sticky ew
	      set col 0
	      foreach txt {Okay Save Detailed "Clear Messages"} \
	              cmd [list "destroy $w" "saveContents $w.msg" "ShowDetails" \
		          "$w.msg delete 0.0 end"] {
                set bb [button $bf.b_[incr col] -text $txt -command $cmd]
		pack $bb -side left
              }
	    } else {
	      catch {wm deiconify $w}
	      raise $w
	    }

	    $w.msg insert end "$comment\n -=-=-=-=-\n"

	    if {$ReplayData(recordFileInternal) ne ""} {
               puts $ReplayData(recordFileInternal) "$comment\n -=-=-=-=-\n"
            }
	    $w.msg see end

        }
    update idle;
}

proc ShowDetails {} {
  set txt [.msgToUser.msg get 0.0 end]
  doDiff $txt
}
proc OLDShowDetails {} {
    global ReplayData
    
            set w .details
	    if {![winfo exists $w]} {
              toplevel $w
              wm title $w "Message Details"
              wm geometry $w [CenterOfScreenGeometry -100 -100]
              text $w.msg -height 40 -width 80 -wrap word \
	          -xscrollcommand "$w.xsb set" \
	          -yscrollcommand "$w.ysb set"
	      scrollbar $w.ysb -orient vertical -command "$w.msg yview"
	      scrollbar $w.xsb -orient horizontal -command "$w.msg xview"
              button $w.okay -text "Okay" -command "destroy $w"
              button $w.save -text "Save" -command "SaveContents $w.msg"
              button $w.detail -text "Last Detailed" -command "ShowDetails"
	      grid rowconfigure $w 0 -weight 1
	      grid columnconfigure $w 0 -weight 1
	      grid $w.msg -row 0 -column 0 -sticky news -columnspan 3
	      grid $w.ysb -row 0 -column 3 -sticky ns
	      grid $w.xsb -row 1 -column 0 -sticky ew -columnspan 3
              grid $w.okay -row 2 -column 0
              grid $w.save -row 2 -column 1
              grid $w.detail -row 2 -column 2
	    } else {
	      raise $w
	    }
	    $w.msg insert end "$ReplayData(detailedMessage)"
	    $w.msg see end
}

proc SaveContents {win} {
    set outputFile [tk_getSaveFile]
    if {[string equal "" $outputFile ]} {
        return
    }
    set of [open $outputFile w]
    puts $of [$win get 0.0 end]
    close $of
}

#
# CenterOfScreenGeometry: returns a geometry specification for the
# center of the screen, plus the x and y arguments
#
proc CenterOfScreenGeometry {{x 0} {y 0}} {
    set cx [expr ([winfo screenwidth  .]/2)+$x]
    set cy [expr ([winfo screenheight .]/2)+$y]
    return [format {+%d+%d} $cx $cy]
}

proc showCoverage {} {
  global GUI
  global ReplayData
  set row 0
  if {![winfo exists .cover]} {
    set top [toplevel .cover]
    wm title .cover "Coverage Reports"
    set GUI(cov,nb) [NoteBook $top.nb -height 400 -width 350]
    grid $GUI(cov,nb) -row $row -column 1 -sticky news
    grid columnconfigure .cover 1 -weight 1
    grid rowconfigure .cover $row -weight 1

    set GUI(cov,events) [$GUI(cov,nb) insert end events -text "Events"]
    set GUI(cov,eventTxt) [text $GUI(cov,events).t -width 40 -height 60 \
      -wrap none -tabs {110 l 200 l} \
      -yscrollcommand "$GUI(cov,events).ysb set" \
      -xscrollcommand "$GUI(cov,events).xsb set"]

    scrollbar $GUI(cov,events).ysb -orient vertical \
        -command "$GUI(cov,eventTxt) yview"

    scrollbar $GUI(cov,events).xsb -orient horizontal \
        -command "$GUI(cov,eventTxt) xview"

    grid $GUI(cov,events).ysb -sticky ns -row 0 -column 1
    grid $GUI(cov,events).xsb -sticky ew -row 1 -column 0
    grid $GUI(cov,eventTxt) -sticky news -row 0 -column 0
    grid rowconfigure $GUI(cov,events) 0 -weight 1
    grid columnconfigure $GUI(cov,events) 0 -weight 1

    set GUI(cov,hits) [$GUI(cov,nb) insert end hits -text "Proc Hits"]
    set GUI(cov,hitTxt) [text $GUI(cov,hits).t -width 40 -height 60 \
      -yscrollcommand "$GUI(cov,hits).ysb set"]
    scrollbar $GUI(cov,hits).ysb -orient vertical \
        -command "$GUI(cov,hitTxt) yview"
    grid $GUI(cov,hits).ysb -sticky ns -row 0 -column 1
    grid $GUI(cov,hitTxt) -sticky news -row 0 -column 0
    grid rowconfigure $GUI(cov,hits) 0 -weight 1
    grid columnconfigure $GUI(cov,hits) 0 -weight 1

    grid $top.nb -row $row -column 1
    incr row
    set bf [frame $top.bf]
    grid $bf -row $row -column 1
    button $bf.cl -text "Close" -command {destroy .cover}
    grid $bf.cl
    $GUI(cov,nb) raise hits
    
  }

  if {($ReplayData(recordFile) ne "")} {
     set of1  [open [file root $ReplayData(recordFile)].evt w]
     set of2  [open [file root $ReplayData(recordFile)].cov w]
  }
  
  $GUI(cov,hitTxt) delete 0.0 end
  $GUI(cov,eventTxt) delete 0.0 end
  after 100

  set rtn1 [getReply TkT_getCoverageEvents]
  foreach el $rtn1 {
    $GUI(cov,eventTxt) insert end "[join $el \t]\n"
    if {[info exists of1]} {
      puts $of1 [join $el \t]
    }
  }
  after 100

  set rtn2 [getReply TkT_getCoverage]
  set l2 [lsort -command TkTcmp $rtn2]
  foreach el $l2 {
    lassign $el in ct
    lassign [split $in ,] cmd nm
    if {[string first . $nm] == 0} {
      continue
    }
    lappend l3 [format "%5d %s" $ct $nm]
  }
  $GUI(cov,hitTxt) insert end [join $l3 \n]
  if {[info exists of2]} {
    puts $of2 [join $l3 \n]
  }
  close $of1
  close $of2
}

proc TkTcmp {l1 l2} {
  set n1 [lindex $l1 1]
  set n2 [lindex $l2 1]
  if {$n1 == $n2} {
    return [string compare $l1 $l2]
  } else {
    return [expr {$n1 < $n2}]
  }
}

