# For loading/saving/running a controller script.
set Release(control.tcl) {$Header: /home/cvs/tktest/control.tcl,v 1.13 2016/07/24 13:56:57 clif Exp $}

###################################################################
#  LoadControlBox: request a script file to load
###################################################################
proc  LoadControlBox {} {
    global ReplayData
    global GUI
    # MsgToUser "Select an application to load"
    set ControlName [tk_getOpenFile -defaultextension .scr \
        -filetypes {{{Control Script} .scr} {tcl {.tcl .tk}}} \
	-initialdir $ReplayData(scriptFileDir)]

    if {$ControlName == ""} {
       MsgToUser "Load app was cancelled"
       return
    }
    
    LoadControl $ControlName
    $GUI(nb) raise control
}

proc LoadControl {ControlName} {
    global ReplayData GUI
    
    set ReplayData(ControlName) $ControlName
    set ReplayData(ControlNameOnly)  [file tail $ControlName]

    set if [open $ControlName r]
    set d [read $if]
    close $if

    $GUI(control).txt insert end $d

}

proc EraseControl {} {
    global ReplayData
    global GUI

    MsgToUser "Erase the entire script"

    $GUI(control).txt delete 0.0 end
    set ReplayData(ControlName) {}
    set ReplayData(ControlNameOnly) {}
}

proc SaveAsControlBox {} {
    global ReplayData GUI
    
    if {![info exists GUI(tkrDir)]} {
      set GUI(tkrDir) $ReplayData(scriptFileDir)
    }

    MsgToUser "Select an filename for saving"
    set ControlName [tk_getSaveFile -defaultextension .scr \
        -filetypes {{{Control Script} .scr} {tcl {.tcl .tk}}} \
	-initialdir $GUI(tkrDir)]

    if {$ControlName == ""} {
       MsgToUser "Load app was cancelled"
       return
    }
    SaveControl $ControlName  
}

proc SaveControlBox {} {
    global ReplayData
    

    if {![info exists ReplayData(ControlName)]} {
       SaveAsControlBox 
       return
    }

    if {![string match $ReplayData(ControlName) ""]} {
       SaveControl $ReplayData(ControlName)
    }
}

proc SaveControl {fileName} {
    global ReplayData
    global GUI
   
    set of [open $fileName w]
    
    set scriptDir [file dirname $fileName]
    
    foreach line [split [$GUI(control).txt get 0.0 end] \n] {
      set out [string map [list $scriptDir \$ReplayData(scriptDir)] $line]
      puts $of $out
    }

    close $of
    MsgToUser "Control script saved: $fileName"
}

proc PlayControlGUI {{speed Normal}} {
    global ReplayData
    global GUI

    set textWin $GUI(control).txt
    
    foreach tag [$textWin tag names] {
      if {([string first running $tag] >= 0) ||
          ([string first failed_ $tag] >= 0)} {
        $textWin tag remove $tag 1.0 end
      }
    }
    
    set last [$textWin index end]
    foreach {lastLine lastchar} [split $last "."] {break;}
    
    $textWin tag configure running -background #ccc
    
    if {$ReplayData(ControlLine) < 0} {
        set line 1
    } else {
        set line $ReplayData(ControlLine)
    }
    set ReplayData(ControlRun) 1
    
    while {$line < $lastLine} {
        set ReplayData(ControlLine) $line
	set line1 $line
	set line2 $line
        if {!$ReplayData(ControlRun)} {return}
        set cmd [$textWin get $line.0 $line.end]
puts "CMPLT: [info complete $cmd] CMD: $cmd"
	$textWin tag add running $line.0 $line.end
	while {![info complete $cmd]} {
	    incr line
	    set line2 $line
            append cmd "\n[$textWin get $line.0 $line.end]"
    	    $textWin tag add running $line.0 $line.end
puts "CMD2: $cmd"
	}
puts "CMD3: $cmd"
	if {![string match "" $cmd]} {
	  puts "EVAL: SPEED: $speed : $cmd "
  	  if {[catch {eval $cmd $speed} output] || 
    	       ($ReplayData(failTest) >= 1)} {
            $textWin tag configure failed_$line1 -background #fbb
  	    $textWin tag add failed_$line1 $line1.0 $line2.end
	    $textWin tag bind failed_$line1 <Button-3> \
	        "tk_messageBox -type ok -message {$output}"
	  } else {
  	    $textWin tag remove running $line1.0 $line2.end
	  }
	}
	update
	incr line
    }
    set ReplayData(ControlLine) -1

    if {$ReplayData(coverage)} {
      showCoverage
    }
}

proc InsertControl {args} {
    global GUI
  puts "InsertControl $args"
  set f [tk_getOpenFile -filetypes {{{Tk Replay Script} .tkr} {{Directive Script} .dir} {{All Files} *}} \
      -title "Select a Replay File to insert"]
  if {[string equal "" $f]} {return}
  if {[string first ".tkr" $f] > 0} {
    $GUI(control).txt insert end "RunScript $f\n"
  } elseif {[string first ".dir" $f] > 0} {
    $GUI(control).txt insert end "RunDir $f\n"
  } else {
    error "Unrecognized type $f"
  }
  set GUI(tkrDir) [file dirname $f]
}

proc GeneralizeControl {} {
  global GUI
  set d [$GUI(control).txt get 0.0 end]
  $GUI(control).txt delete 0.0 end
  foreach l [split $d \n] {
    lassign $l cmd path
    set path [file tail $path]
    $GUI(control).txt insert end "$cmd $path\n"
  }
}

proc RunDir {filename {speed Normal}} {
    global ReplayData
  set ReplayData(failTest) 0
  set if [open $filename r]
  set directives [string trim [read $if]]
  close $if
  set rtn [directive::process $directives]
  puts "RTN: $rtn"
}

proc RunScript {filename {speed Normal}} {
    global ReplayData
    
    set ReplayData(scriptFileDir) [file dirname $filename]
    EraseScript
    LoadScript $filename

    set ReplayData(failTest) 0

    if {$ReplayData(autoRegen)} {
      RebuildScript
    } elseif {[string match $speed Normal]} {
        Replay
    } else {
        ReplayFast
    }

}
