package require struct
set Release(details.tcl) {$Header: /home/cvs/tktest/details.tcl,v 1.13 2016/04/04 13:33:46 clif Exp $}

################################################################
# proc showDiff {txt {dir next} {tag changed} }--
#    Move cursor to next/prev diff
# Arguments
#   txt		The text widget to display in
#   dir		Direction for search (default next/forward)
#   tag 	tag to find (default changed)
# Results
#   scrollbars are updated by text widget
# 
proc showDiff {pnt {dir next} {tag changed}} {
  foreach txt [list $pnt.t1 $pnt.t2] {
    $txt tag remove shown 0.0 end

    if {$dir eq "next"} {
      set loc [lindex [$txt tag nextrange $tag [$txt index checks]] 0]
      set move 1
    } else {
      set loc [lindex [$txt tag prevrange $tag [$txt index checks]] 0]
      set move -1
    }
    if {$loc eq ""} {
      tk_messageBox -type ok -message "No more diffs"
      return
    }

    lassign [split $loc .] line char
    incr char $move
    $txt mark set checks $line.$char

    incr char -30
    if {$char < 0} {set char 0}
    incr line -3
    if {$line < 0} {set line 0}

    $txt xview moveto 0
    $txt yview moveto 0

    $txt see $loc
    
    if {$move > 0} {
      $txt tag add shown {*}[$txt tag prevrange changed [$txt index checks]]
    } else {
      $txt tag add shown {*}[$txt tag nextrange changed [$txt index checks]]
    }
  }
}

proc reworkKernel {lst} {
set rtn ""
  foreach {nm type def mgr} $lst {
update
    set indent [llength [split $nm .]]
    set fail [catch {lindex $def 0} tst]
    set hit [regexp -indices {\.[a-z].*} $tst aa bb]
    if {$hit} {
      set pos [lindex $aa 0]
    } else {
      set pos -1
    }

    if {!$fail && ($pos == 0)} {

      append rtn "[string repeat " " $indent] $nm $type\n[reworkKernel $def ]\n"
    } else {
      append rtn "[string repeat " " $indent] $nm $type\n[string repeat " " $indent] $def\n"
    }
  }
  return $rtn
}
proc rework {txt} {
    set pQ1 [string first \" $txt]
    incr pQ1
    set pQ2 [string last \" $txt]
    incr pQ2 -1

    set new [string range $txt $pQ1 $pQ2]

    set rplc [reworkKernel \n$new]

    set txt [string replace $txt $pQ1 $pQ2 $rplc]

    return $txt
}


proc failsList {txt} {
  set keep 0
  set state none
  set rtn1 {}
  set rtn2 {}
  foreach line [split $txt \n] {

    if {[string first FAIL: $line] >= 0} {
      set state both
    }
    if {[string first EXP: $line] >= 0} {
      set state rtn1
    }
    if {[string first SAW: $line] >= 0} {
      set state rtn2
    }
    if {[string first " ELEM " $line] >= 0} {
      set state none
    }
    if {[string first "-=-=-=-=-" $line] >= 0} {
      set state none
    }

    switch $state {
      both {
        append rtn1 $line\n
        append rtn2 $line\n
      }
      rtn1 {
        append rtn1 $line\n
      }
      rtn2 {
        append rtn2 $line\n
      }
    }
  }
  return [list $rtn1 $rtn2]
}

proc getPair {txt} {
  set p1 [string first "FULL EXP:" $txt]
  set p2 [string first "FULL SAW:" $txt]
  set p3 [string first "ELEM EXP:" $txt]
  if {$p3 < 0} {
    set p3 end
  } else {
    incr p3 -1
  }

  incr p2 -1
  incr p1 10 
  set st1 [string range $txt $p1 $p2] 
  incr p2 11
  set st2 [string range $txt $p2 $p3]
  return [list $st1 $st2]
}


proc bldDiffGUI {} {
  set top [toplevel .txt]
  wm title $top "Text Differences"
  set txt1 [text $top.t1 -width 80 -height 16 -wrap none \
      -xscrollcommand [list $top.xsb1 set] -yscrollcommand [list $top.ysb1 set]]
  set txt2 [text $top.t2 -width 80 -height 16 -wrap none \
      -xscrollcommand [list $top.xsb2 set] -yscrollcommand [list $top.ysb2 set]]

  button $top.b1n -text "Show Next Diff" -command "showDiff $top "
  button $top.b1p -text "Show Prev Diff" -command "showDiff $top prev"

  scrollbar $top.xsb1 -orient horizontal -command "$top.t1 xview"
  scrollbar $top.ysb1 -orient vertical -command "$top.t1 yview"
  scrollbar $top.xsb2 -orient horizontal -command "$top.t2 xview"
  scrollbar $top.ysb2 -orient vertical -command "$top.t2 yview"
  
  label $top.l1 -text "Expected"
  label $top.l2 -text "Saw"
  
  grid columnconfigure $top 0 -weight 1
  grid columnconfigure $top 2 -weight 1

  set row 0
  set col 0
  grid $top.l1 -row $row -column $col
  incr row
  grid $txt1 -row $row -column $col -sticky nsew
  grid rowconfigure $top $row -weight 1
  grid $top.ysb1 -row $row -column [expr $col+1] -sticky ns 
  incr row
  grid $top.xsb1 -sticky ew -row $row -column $col
  incr row
  grid $top.b1n -row $row
  set row 0
  incr col 2
  grid $top.l2 -row $row -column $col
  incr row
  grid $txt2 -row $row -column $col -sticky nsew
  grid $top.ysb2 -row $row -column [expr $col+1] -sticky ns 
  incr row
  grid $top.xsb2 -sticky ew -column $col -row $row
  incr row
  grid $top.b1p -row $row -column $col

  $txt1 tag configure changed -background pink
  $txt2 tag configure changed -background pink

  $txt1 tag configure added -background green
  $txt2 tag configure added -background green

  $txt1 tag configure deleted -background orange
  $txt2 tag configure deleted -background orange

  $txt1 tag configure shown -background #f88
  $txt2 tag configure shown -background #f88
  
  after idle "$txt1 mark set checks 0.0"
  after idle "$txt2 mark set checks 0.0"

  return [list $txt1 $txt2]
}

proc doDiff {txt} {
  lassign [bldDiffGUI] txt1 txt2

  lassign [failsList $txt] st1 st2

  #foreach l $st1 {
  #  puts "    L: $l"
  #}

  set lines1 [split [string map [list "\n" " \n "] $st1] " "]
  set lines2 [split [string map [list "\n" " \n "] $st2] " "]

  ::struct::list assign [::struct::list longestCommonSubsequence $lines1 $lines2] x1 x2

  set chunks 0
#  puts "LOOPDD: [::struct::list lcsInvert2 $x1 $x2 [llength $lines1] [llength $lines2]]"

  set items [::struct::list lcsInvert2 $x1 $x2 [llength $lines1] [llength $lines2]] 
#puts "ITEMS: $items"
  foreach item $items {

    lassign $item type p1 p2
    lassign $p1 i1 i2
    # puts "ITEM: $item $type p1: $p1 p2: $p2 : $i1 $i2"

    for {set i $i1} {$i <= $i2} {incr i} {
      lappend tag1($type) $i
    }

    lassign $p2 i1 i2
    for {set i $i1} {$i <= $i2} {incr i} {
      lappend tag2($type) $i
    }
  }


set noHighlights {SAW: EXP: Cmd}
  set pos 0
  foreach w1 $lines1 {
    set tag {}
    if {[string trim $w1] ni $noHighlights} {
      foreach nm [array names tag1] {
        if {[lsearch $tag1($nm) $pos] >= 0} {
          set tag $nm
        }
      }
    }
    $txt1 insert end "$w1 " $tag
  incr pos
  }

   set pos 0
  foreach w2 $lines2 {
    set tag {}
    if {[string trim $w2] ni $noHighlights} {
      foreach nm [array names tag2] {
        if {[lsearch $tag2($nm) $pos] >= 0} {
          set tag $nm
        }
      }
    }
  $txt2 insert end "$w2 " $tag
  incr pos
  }

#  update idle

  # Cleanup wildcard matches
  
  set index1 0.0
  set index2 0.0
  set loc1 start
  while {$loc1 ne ""} {
    set loc1 [$txt1 tag nextrange changed $index1]
    set loc2 [$txt2 tag nextrange changed $index2]
    if {$loc1 eq ""} {break}
    
    set pat1 [$txt1 get {*}$loc1]
    set pat2 [$txt2 get {*}$loc2]
    
    if {[string match $pat1 $pat2]} {
      $txt1 tag remove changed {*}$loc1
      $txt2 tag remove changed {*}$loc2
    }
    
    set index1 [lindex $loc1 1]
    set index2 [lindex $loc2 1]

  }

}


proc mapWin {mgr win} {
# puts "MapWin $mgr $win"
# puts [info level -1]
    update
    lassign $mgr mg op
    switch $mg {
      grid -
      pack -
      place {
        set p1 [lsearch $op "-in"]
	if {$p1 >= 0} {
	  set p2 $p1
	  incr p2
	  set op [lreplace $op $p1 $p2]
	}
# puts "        $mg $win {*}$op"
        $mg $win {*}$op
      }
      notebook {
        if {[winfo class [winfo parent $win]] eq "Frame"} {
	  grid $win
        } else {
          [winfo parent $win] add $win
	}
      }
    }
}

proc makeWin {win type config mgr} {

  lassign $mgr mg op
  update
  set new frame
  set newWin ""
  foreach winPath [lrange [split $win .] 0 end-1] {
    if {[string trim $winPath] eq ""} {continue}
    append newWin .$winPath
    if {![winfo exists $newWin]} {
      $new $newWin
      set new frame
      if {$mg eq "notebook"} {set mg grid}
      catch {$mg $newWin}
    }
  }
  
  if {[catch {set w [[string tolower $type] $win]}]} {
    if {[string first "T" $type] == 0} {
      set type ttk::[string range $type 1 end]
      set w [[string tolower $type] $win]
    } else {
      puts stderr "NO BUILD: $type for $win"
    }
  }
catch {
  balloon $w $w $w

  mapWin $mgr $win

  foreach cfg $config {
    if {[llength $cfg] < 4} {continue}
    lassign $cfg opt n1 n2 v1 v2 v3
    switch -- $opt {
      -colormap -
      -container -
      -visual -
      -variable -
      -image -
      -class {
        # DO NOTHING - CAN'T BE MODIFIED
      }
      -imageDump -
      -tagDump -
      -winDump {
      }
      
      -textContent {
        $win insert end $v1
      }
      default {
        if {[string first . $v2] == 0} {
	  # This is a window config.
	  set winTop [lindex [split $win .] 1]
	  set v2 .$winTop$v2
	}
        catch {$win configure $opt $v2}
      }
    }
  }
 }
}

proc reflectKernel {top lst} {

set rtn ""
  foreach {nm type def mgr} $lst {
    update
    if {$mgr eq ""} {return}
    set indent [llength [split $nm .]]
    set fail [catch {lindex $def 0} tst]
    set hit [regexp -indices {\.[a-z].*} $tst aa bb]
    if {$hit} {
      set pos [lindex $aa 0]
    } else {
      set pos -1
    }

    if {!$fail && ($pos == 0)} {
       makeWin $top$nm $type $def $mgr
       reflectKernel $top $def
    } else {
       makeWin $top$nm $type $def $mgr
    }
    mapWin $mgr $top$nm

  }
  return $rtn
}

proc reflect {top txt} {
    set pQ1 [string first \" $txt]
    incr pQ1
    set pQ2 [string last \" $txt]
    incr pQ2 -1
    set new [string range $txt $pQ1 $pQ2]
    
    set rplc [reflectKernel $top $new]

    set txt [string replace $txt $pQ1 $pQ2 $rplc]

    return $txt
}

proc visualizeWindow {txt} {
  global SETUP

  set prevFirst 0
  if {[set p1 [string first "Window Compare FAIL:" $txt $prevFirst]] >= 0} {
    set prevFirst $p1
    incr prevFirst
    set p2 [string first "Window Compare FAIL:" $txt $prevFirst]
    if {$p2 < 0} {
      set p2 end
    }
    set reflect [string range $txt $p1 $p2]
    
    toplevel .top1
    toplevel .top2
    
    wm title .top1 Expected
    wm title .top2 Seen
    
    lassign [getPair $reflect] str1 str2
    reflect .top1 $str1

    reflect .top2 $str2

  }
}

proc doWins {txt} {
  visualizeWindow $txt

  lassign [failsList $txt] st1 st2

# puts "ST1: $st1"
# puts "ST2: $st2"

  set lines1 [split $st1 " "]
  set lines2 [split $st2 " "]

#  puts "WIN Sort Time [time {
  ::struct::list assign [::struct::list longestCommonSubsequence $lines1 $lines2] x1 x2
#  }]"

  set chunks 0
#  puts "LOOPWIN: [::struct::list lcsInvert2 $x1 $x2 [llength $lines1] [llength $lines2]]"
# update idle
  foreach set [::struct::list lcsInvert2 $x1 $x2 [llength $lines1] [llength $lines2]] {
    lassign $set type t1 t2
    set pos1 [lindex $t1 0]
    for {set i $pos1} {$i > 0} {incr i -1} {
      set v [lindex $lines1 $i]
      if {([string first "." [string trim $v]] == 0) && [winfo exists .top1$v]} {
# puts "POS1: $pos1 I: $i        .top1$v configure -bg pink -- $set "
# puts "SPAN: [lrange $lines1 $i $pos1]"
         .top1$v configure -bg pink
        break;
      }
    }
    set pos2 [lindex $t2 0]
    for {set i $pos2} {$i > 0} {incr i -1} {
      set v [lindex $lines2 $i]
      if {([string first "." [string trim $v]] == 0) && [winfo exists .top2$v]} {
        .top2$v configure -bg red
        break;
      }
    }
  }
}
