set Release(directive.tcl) {$Header: /home/cvs/tktest/directive.tcl,v 1.9 2016/03/08 18:43:20 clif Exp $}
if {0} {
  invoke ?-pattern *.buttonName? ?-text "Label"? ?-mod Double-? ?-x x? ?-y y?
  insert ?-pattern *.buttonName? ?-text "Label"? -value $text
  checkVar -varName name -value expected
  checkScriptReturn -script {scr} ?-match {matchString}? ?-regexp {regexp}?

  examineArray name
  examineTcl   script
}

namespace eval directive {
  proc process {scr} {
set ::errroInfo NOERR
    set rtn "DEFAULT_RTN"
    foreach line [string trim [split $scr \n]] {
      if {[string first # $line] == 0} {continue}
       # puts "LINE: $line"
      set err [catch {lappend rtn [{*}$line]}]
      # puts "ERR: $::errorInfo"
      # puts "line $line rtn: [string range $rtn end-20 end]"
      if {$err} {
        puts "FAIL: $rtn"
	puts "FAIL: $::errorInfo"
      }
      
    }
    return $rtn
  }

  proc findWidget {triplets defs} {
#    puts "DEFS: $defs"
#    puts "TRIPLETS: $triplets"

    array set tmp $defs
    set findClass $tmp(-class)
    unset tmp(-class)

    if {[info exists tmp(-pattern)]} {
      set pattern $tmp(-pattern)
      # Try to fix what should be a glob pattern that's
      # not obviously a full window name
      if {[string first . $pattern] != 0} {
        if {[string first * $pattern] < 0} {
	  set pattern "*$pattern"
	}
      }
    } else {
      set pattern *
    }
    catch {unset tmp(-pattern)}
    set oldWidget ""


    foreach {nm class config place} $triplets {
      # puts "CHEC: $nm ($findClass $class) :: [string range $config 0 50]"
      if {$class eq "Menu"} {
        set oldWidget $nm
      }

      if {$class ne $findClass} {
        continue
      }
      
      if {![string match $pattern $nm]} {
        continue
      }
      # puts "PATTERN: $pattern NM: $nm $oldWidget"
      set match 1
      foreach in [array names tmp] {

        if {[set p [lsearch $config $in*]] < 0} {
	  set match 0
	  continue
	} else {
	  set l2 [lindex $config $p]
	  set val [lindex $l2 4]
          puts "l2: $l2 VAL: $val"
	  if {![string match $tmp($in) $val]} {
	    set match 0
	    continue
	  }
	}
      }

      if {$match == 1} {

        if {$class eq "MenuEntry"} {
	  return [list $oldWidget $nm]
        } else {
	  return [list $nm]
	}
      }
    }

    return {}
  }
  
  proc checkVar {args} {
    array set tmp $args

    set appName [lindex $::ReplayData(ConnectedApps) 0]
    set uid [GetUniqueID]

    lappend rtn "InsertAction {1} {ThisApp} {ExecTcl} {CheckReturn {eval {set $tmp(-varName)}} {$tmp(-value)}} 0"
    InsertAction {1} $appName {ExecTcl} "{CheckReturn {eval {set $tmp(-varName)}} {$tmp(-value)}} 1"
    CheckReturn [list eval "set $tmp(-varName)"] $tmp(-value)
  }

  proc checkScriptReturn {args} {
    array set tmp $args

    set appName [lindex $::ReplayData(ConnectedApps) 0]
    set uid [GetUniqueID]
    
    set scr [subst $tmp(-script)]

    lappend rtn "InsertAction {1} {ThisApp} {ExecTcl} {CheckReturn {eval $scr} {$tmp(-match)}} 0"
    InsertAction {1} $appName {ExecTcl} "{CheckReturn {eval {$scr}} {$tmp(-match)}} 1"
    CheckReturn "$scr" $tmp(-match)
  }

  proc insert {args} {
    set txt [lindex $args end]
    set cursor [lindex $args end-1]
    set selects [lrange $args 0 end-2]

    if {[set p [lsearch $args -class]] < 0} {
      lappend selects -class Entry
      set class Entry
    } else {
      set class [lindex $args [incr p]]
    }

    set triplets [getContents .]
    set winDef [findWidget $triplets $selects]
    
    if {$winDef eq ""} {
#      tk_messageBox -type yesno -message "Can't find match for $args in $triplets"
      error "Can't find match for $args in $triplets"
    } else {
        set appName [lindex $::ReplayData(ConnectedApps) 0]
        set uid [GetUniqueID]

	lassign $winDef win entry
        lappend rtn "InsertAction {1} {ThisApp} {ExecTcl} {$win insert $cursor $txt} 1"
        InsertAction {1} ThisApp {ExecTcl} "[list [list $win insert $cursor $txt]] 0"
        SendToAppAndWait $appName $uid 1 [list $win insert $cursor $txt]
    }
    
  }

  proc invoke {args} {

    if {[set p [lsearch $args -class]] < 0} {
      lappend args -class Button
      set class Button
    } else {
      set class [lindex $args [incr p]]
    }
    
    set mod ""
    set x 10
    set y 10
    foreach name {mod x y} {
      if {[set p [lsearch $args -$name]] > 0} {
        set p2 [expr {$p+1}]
        set val [lindex $args $p2]
        if {$val > 0} {
          set $name $val
        }
        set args [lreplace $args $p $p2]
        puts "ARGS: $args"
      }
    }
    
    set triplets [getContents .]
    set winDef [findWidget $triplets $args]
    
    if {$winDef eq ""} {
# set of [open /tmp/trip.txt w]
# puts $of $triplets
# close $of

#      error "Can't find match for $args in $triplets"
       foreach {nm class config place} $triplets {
         lappend nms $nm
       }
      toplevel .bad
      text .bad.t -yscrollcommand {.bad.ysb set}
      scrollbar .bad.ysb -orient vertical -command {.bad.t yview}
      .bad.t insert 0.0 "Can't find match for $args in \n[join [lsort $nms] \n]"
      grid .bad.t -row 0 -column 0 -sticky news
      grid .bad.ysb -row 0 -column 1 -sticky ns
      grid rowconfigure .bad 0 -weight 1
      grid columnconfigure .bad 0 -weight 1
      button .bad.go -text "Done" -command "set ::foobar 1"
      grid .bad.go -row 1 -column 0
      set ::foobar 0
      after 5000 {set ::foobar 1}
      vwait ::foobar
      destroy .bad
#       tk_messageBox -type yesno \
#           -message "Can't find match for $args in \n[lsort $nms]"
    } else {
      MsgToUser "Matched $args TO $winDef" high
      set uid [GetUniqueID]
      set appName [lindex $::ReplayData(ConnectedApps) 0]
#  puts "windef: $winDef CLA: $class"      
      switch $class {
        "Radiobutton" -
	"Checkbutton" -
        "Button" {
# puts "DOING BUTTON"
	  lassign $winDef win 

          lappend rtn "InsertAction {1} {$appName} {Bind,Button,<Enter>} {{W $win} {x 10} {y 10} {Args {}}}"
          InsertAction {1} $appName {Bind,Button,<Enter>} "{W $win} {x 10} {y 10} {Args {}}"
          SendToAppReplayAndWait $appName $uid 1001 {Bind,Button,<Enter>} "{W $win} {x 10} {y 10} {Args {}}"

          set uid [GetUniqueID]
          lappend rtn "InsertAction {1} {$appName} {Bind,Button,<Button-1>} {{W $win} {x 10} {y 10} {Args {}}}"
          InsertAction {1} $appName {Bind,Button,<Button-1>} "{W $win} {x 10} {y 10} {Args {}}"
          SendToAppReplayAndWait $appName $uid 1001 {Bind,Button,<Button-1>} "{W $win} {x 10} {y 10} {Args {}}"
	  
          set uid [GetUniqueID]
          lappend rtn "InsertAction {1} {$appName} {Bind,Button,<ButtonRelease-1>} {{W $win} {x 10} {y 10} {Args {}}}"
          InsertAction {1} $appName {Bind,Button,<ButtonRelease-1>} "{W $win} {x 10} {y 10} {Args {}}"
          SendToAppReplayAndWait $appName $uid 1001 {Bind,Button,<ButtonRelease-1>} "{W $win} {x 10} {y 10} {Args {}}"

          set uid [GetUniqueID]
          lappend rtn "InsertAction {1} {$appName} {Bind,Button,<Leave>} {{W $win} {x 10} {y 10} {Args {}}}"
          InsertAction {1} $appName {Bind,Button,<Leave>} "{W $win} {x 10} {y 10} {Args {}}"
          SendToAppReplayAndWait $appName $uid 1001 {Bind,Button,<Leave>} "{W $win} {x 10} {y 10} {Args {}}"

        }
	Treeview {
	  lassign $winDef win 
          set uid [GetUniqueID]
          lappend rtn "InsertAction {1} {$appName} {Bind,Treeview,<${mod}Button-1>} {{W $win} {x $x} {y $y} {Args {}}}"
          InsertAction {1} $appName "Bind,Treeview,<${mod}Button-1>" "{W $win} {x $x} {y $y} {Args {}}"
          SendToAppReplayAndWait $appName $uid 1001 "Bind,Treeview,<${mod}Button-1>" "{W $win} {x $x} {y $y} {Args {}}"

	}
	MenuEntry {
	  lassign $winDef win entry
          lappend rtn "InsertAction {1} {ThisApp} {ExecTcl} {$win invoke $entry} 0"
          InsertAction {1} ThisApp {ExecTcl} "{$win invoke $entry} 0"
          SendToAppAndWait $appName $uid 1001 [list $win invoke $entry]
	}
	default {
	  error "UNKNOWN CLASS $class"
	}
      }
      return $rtn
    }
  }


}

if {[info exists argv] && ([string first -testCMD $argv] >= 0)} {

set testScrB {  invoke -pattern *.msg
  invoke -text OK
  invoke -pattern *.exit
}

set testScrM {
  invoke -label File -class MenuEntry
  invoke -label exit -class MenuEntry
}

set testScrE {
  insert -pattern *2.e_name -class Entry 0 "Galahad"
  insert -pattern *2.e_quest -class Entry 0 "Find Grail"
  insert -pattern *.t -class Text 0.0 "Oh, but you can't expect to wield supreme executive power just because some watery tart threw a sword at you."
}

set testScrCh1 {
  checkVar -varName ::data(.lf2,name) -value Galahad
  checkVar -varName ::data(.lf2,quest) -value "Find Grail"
}
}


proc tk::ButtonDown {w} {
    variable ::tk::Priv

    # Only save the button's relief if it does not yet exist.  If there
    # is an overrelief setting, Priv($w,relief) will already have been set,
    # and the current value of the -relief option will be incorrect.

    if {![info exists Priv($w,relief)]} {
	set Priv($w,relief) [$w cget -relief]
    }

    if {[$w cget -state] ne "disabled"} {
	set Priv(buttonWindow) $w
	$w configure -relief sunken
	set Priv($w,prelief) sunken

	# If this button has a repeatdelay set up, get it going with an after
	catch {
	after cancel $Priv(afterId)
	set delay [$w cget -repeatdelay]
	set Priv(repeated) 0
	if {$delay > 0} {
	    set Priv(afterId) [after $delay [list tk::ButtonAutoInvoke $w]]
	}
	}
    }
}

