# This file contains code used to implement the Help menu
#

set Release(help.tcl) {$Header: /home/cvs/tktest/help.tcl,v 1.7 2015/11/16 18:26:15 clif Exp $}

# - !!!!
# Add wipe16 and back16 to images
#
set Release(images.tcl) {$Header: /home/cvs/tktest/help.tcl,v 1.7 2015/11/16 18:26:15 clif Exp $}


# Everything in its own namespace
#
namespace eval ::help {


# Pop up the "About" dialog box.
#
proc about {} {
  # VERSION is defined in main.tcl
  global VERSION
  catch {destroy .about}
  toplevel .about
  wm title .about About
  wm iconname .about About
  wm withdraw .about
  wm protocol .about WM_DELETE_WINDOW {.about.bb.can invoke}

  frame .about.bb
  pack .about.bb -side bottom -fill x
  button .about.bb.can -text Dismiss -command {destroy .about}
  pack .about.bb.can -side left -expand 1 -padx 10 -pady 5

  label .about.l1 -text "TkTest GUI testing" -font {times 24 bold}
  pack .about.l1 -side top -fill both -expand 1 -padx 10 -pady 10
  label .about.l2 -text "Version: $VERSION" -font {times 12 bold}
  pack .about.l2 -side top -fill both -expand 1 -padx 10 -pady 10
  label .about.l3 -text "Developed by \nNoumena Corporation\n 8888 Black Pine Ln\nWhitmore Lake,MI 48189\nwww.noucorp.com" -font {times 12 bold}
  pack .about.l3 -side top -fill both -expand 1 -padx 10 -pady 10
  ::update idletasks
  ::newwin::center .about .
}

proc versions {} {
  global Release
  global tcl_platform
  catch {destroy .versions}
  toplevel .versions
  wm withdraw .versions

  grid [text .versions.t] -row 0 -column 0
  grid [button .versions.b -text OK -command {destroy .versions}]

  foreach n [lsort [array names Release]] {
    set l "$n: [lindex $Release($n) 2]"
    .versions.t insert end "$l\n"
  }
  ::newwin::center .versions .
}


proc help {{helpType {}}} {
  variable helps
  global tcl_platform
  set helps(_stack) ""

  catch {destroy .help}
  toplevel .help

  wm withdraw .help

  set w [text .help.t -yscrollcommand {.help.sb set}]
  grid $w -row 1 -column 1 -sticky news
  grid columnconfigure .help 1 -weight 1
  grid rowconfigure .help 1 -weight 1
  HMinit_win $w
  
  set w [scrollbar .help.sb -orient vertical -command {.help.t yview}]
  grid $w -row 1 -column 2 -sticky ns
  
  set f [frame .help.f1]
  grid $f -row 0 -column 1 -columnspan 2 -sticky ew
  
  set w [button $f.back -image back16 -command {help::_back} -relief flat]
  pack $w -side left
  
  if {![string equal $tcl_platform(platform) windows]} {
    set w [button $f.q -image wipe16 -command {destroy .help} -relief flat]
    pack $w -side right
  }

  set hit 0
  
  if {[string match $helpType ""]} {
    foreach w [winfo children .bb] {
      if {[string match [$w cget -relief] sunken]} {
        set hit 1
        _insertHelp $w
      }
    }
    if {!$hit} {
      _insertHelp generic
    }
  } else {
      _insertHelp $helpType
  }
  ::newwin::center .help .
  return .help
}

proc _back {} {
  variable helps
  if {[llength $helps(_stack)] == 1} {return}
  # Clear the current page
  set helps(_stack) [lrange $helps(_stack) 0 end-1]
  set bck [lindex $helps(_stack) end]
  set helps(_stack) [lrange $helps(_stack) 0 end-1]
  _insertHelp $bck
}

proc _insertHelp {id} {
  variable helps

  .help.t configure -state normal

  if {[string equal $helps(_stack) ""]} {
    .help.f1.back configure -state disabled
  } else {
    .help.f1.back configure -state normal
  }

  lappend helps(_stack) $id

  .help.t delete 0.0 end

  if {[info exists helps($id)]} {
    # .help.t insert end $helps($id)
    set n [lindex [split [string trim $id .] .] end]
    set n [string map {_ { }} $n]
    wm title .help [lindex [split $n -] end]
    HMparse_html $helps($id) "HMrender .help.t"
  } else {
    .help.t insert end $helps(generic)
  }
    .help.t configure -state disabled
}

proc fillHelpMenu {top} {
  variable helps

  set mbut [menu $top.buttons]
  $top add cascade -label {Help for Taskbuttons} -menu $top.buttons
  
  set mmen [menu $top.menus]
  $top add cascade -label {Help for Menus} -menu $top.menus
  
  set mcat [menu $top.category]
  $top add cascade -label {Help by Category} -menu $top.category
  fillMenu $mmen menu
  fillMenu $mcat category
  fillMenu $mbut button
}

proc insertMenuElement {top help} {
     set l [split $help -]
     set parentMenu $top
     set n $parentMenu
     foreach subMenu [lrange $l 1 end-1] {
       set n $n.m_$subMenu
       if {![winfo exists $n]} {
         $parentMenu add cascade -label [string map {{_} { }} $subMenu] -menu $n
	 menu $n
       }
       set parentMenu $n
     }
     set subMenu [lindex $l end]
     if {[lsearch [image names] $subMenu ] >= 0} {
       $parentMenu add command -image $subMenu \
         -command "::help::help $help"
     } else {
       $parentMenu add command -label [string map {{_} { }} $subMenu] \
         -command "::help::help $help"
     }
}

proc fillMenu {top markerList} {
  variable helps
  if {[llength $markerList] > 1} {
    foreach h $markerList {
      insertMenuElement $top $h
    }
  } else {
  # Fill in menu helps
    foreach h [lsort [array names helps ${markerList}-*]] {
      insertMenuElement $top $h
    }
  }
}

set helps(category-Event_Script:_Record_and_Run) {
  The simplest way to use <b>tktest</b> to improve your 
development task is to use the replay facility to re-run a sequence
of events that need to be repeated while you are developing and
debugging a GUI.
<p>
First, the target application must be instrumented by adding these
lines of code:

<pre><code>
if {[info exists argv] && ([lsearch $argv -tktest] >= 0)} {
  source $sockdir/socksend.tcl
  sockappsetup tktest.tcl 3010  $ipaddr
}
</code></pre>
<p>

<code>$sockdir</code> is the parent folder that contains socksend.tcl.
This might be <code>$HOME/tktest/socksend</code>.
<p>
<code>$ipaddr</code> is the IP address where tktest is running. This
might be 127.0.0.1, or can be a remote system.
<p>
You should start the <b>tktest</b> application before starting the
client. If tktest is not running, the client will hang for a period
of time waiting for tktest to appear and will then timeout and exit.
<p>
After starting tktest, start the target application.
<p>
You can start recording by clicking the red <b>Record</b> button:
<br>
<img src="record">
<br>
All events in the target application will now be recorded in the
tktest event script window.
<p>
After you have done "stuff" in your target application, stop the
recording by clicking the <b>Stop</b> button:
<br>
<img src="stop">
<br>
The events can be rerun by clicking the rewind button:
<br>
<img src="rewind">
<br>
Followed by either the <b>Play</b> or the <b>FastForward</b> button:
<br>
Play: <img src="play">
<br>
Fast Forward: <img src="fforward">
}

set helps(category-Event_Script:_Create_Test) {
The simplest way to create a test is to record a set of events
and add simple introspection tests.
<p>
Record the events by following the <A HREF="category-Record_and_Run">
Record and Run</A> instructions.
<p>
When <b>tktest</b> is recording, you can click one of the introspection
buttons to examine the target application and record selected state
information for future use.
<p>
The introspection buttons are:
<dl>
  <dt><img src="arraymagnify">
  <dd> Prompts the user for the name of an array in the target application
and records the contents of the array.
  <dt><img src="sqlmagnify">
  <dd> Prompts the user for an SQL query, executs the sql command in the
target and records the return value.
  <dt><img src="winmagnify">
  <dd> Presents the user with a tree of windows in the target application. The
window will resemble this:
<br>
<img src="winSel">
<br>
Clicking on the tree control symbols in squares will open or close
that branch of the tree.
<p>
Left clicking on a window name will query that window and its descendants
and will record the window name, class, configuration options and grid options.
  <dt><img src="winmagnifyGray">
  <dd> Performs the same action as the <img src="winmagnify"> button, but
discards background color information.
  <dt><img src="feathermagnify">
  <dd> Prompts the user for a Tcl script which will be evaluated on
the target system. The return value for this script will be recorded for
future use.
  <dt><img src="pause">
  <dd> Pauses the target application.
  <dt><img src="wait">
  <dd> Prompts the user for a condition string and a true/false value.
  The tktest script will pause until this condition is achieved in the
target.  
<p>
This feature allows tktest to wait until a non-deterministic event
occurs - for example, the appearance of a window that may be delayed
until processing is complete.
<p>
This dialog:
<br>
<img src="waitDialog">
<br>
will pause the tktest until the <b>.complete</b> window appears in
the target application.
  <dt><img src="tinytcl">
  <dd>This button opens a dialog box as shown:
<br>
<img src="addTcl">
<br>
  The code in the window will be executed on the target when the
  task is run. It does not execute immediately.
  <p>
  This can be used to vwait on a variable, or to execute a task
  from the <b>tktest</b> application (perhaps modifying the environment
  to confirm that the target task reflects this.)
  <dt><img src="comment">
  <dd> This lets you add comments into a .tkr script.
  <dt><img src="erase16T">
  <dd> Will erase the displayed script.
</dl>
}

set helps(category-Control_Scripts:_Creation) {
  A control script is a list of one or more event (.tkr) or directive
(.dir) scripts.
<p>
New items are added to the control script with the <img src="edit16T">
button. Clicking this button will display a standard file selection widget.
The new item will be added to the end of the list of scripts to evaluate.
<p>
The script window is a standard Tk text widget. You can modify the
script if you desire with standard edit commands.
}

set helps(category-Control_Scripts:_Running) {
 A control script is run by clicking the <b>Rewind</b> (<img src="rewind">) button
followed by the <b>Play</b> (<img src="play">) or <b>Fast Forward</b> 
(<img src="fforward">) buttons.
<p>
The script being run will be highlighted in gray, scripts that fail any
tests will be highlighted in pink.
<p>
You can select the <b>Events Script</b> tab to watch tests as then execute.
}


set helps(menu-File-Save/Save_As) {
  This menu option is available in the main mindow, the <b>Event Script</b>
tab and the <b>Control Script</b> tab.
<p>
  Files saved from the <b>Event Script</b> window default to a
<b>.tkr</b> suffix.
<p>
  Files saved from the <b>Control Script</b> window default to a
<b>.scr</b> suffix.
  
  <DL>
    <DT> Main Window File/Save As
    <DD> Writes the contents of the <b>Event Script</b> window to 
      a file defined by the user.
    <DT> Event Script Tab File/Save As
    <DD> Writes the contents of the <b>Event Script</b> window to 
      a file defined by the user.
    <DT> Control Script Tab File/Save As
    <DD> Writes the contents of the <b>Control Script</b> window to
      a file defined by the user.
  </DL>
  <DL>
    <DT> Main Window File/Save
    <DD> Will save the contents of the <b>Event Script</b> window to 
    the file previously defined by <b>Save As</b> or <b>Open</b> or the default <b>Unnamed</b>.
    <DT> Event Script Tab File/Save
    <DD> Will save the contents of the <b>Event Script</b> window to 
    the file previously defined by <b>Save As</b> or <b>Open</b> or the default <b>Unnamed</b>.
    <DT> Control Script Tab File/Save
    <DD> Will save the contents of the <b>Control Script</b> window to 
    the file previously defined by <b>Save As</b> or <b>Open</b>. If these are undefined,
    it will prompt for a filename.
  </DL>
}

set helps(menu-File-Open) {
  This menu option is available in the main mindow, the <b>Event Script</b>
tab and the <b>Control Script</b> tab.
<p>
  From the main window or the <b>Event Script</b> tab file menu this will load
an event script with a .tkr extension.
<p>
  From the <b>Control Script</b> tab this will load a control script with
a .scr extension
}

set helps(menu-Clear_Event_And_Sontrol_scripts) { 
  Available on the main window <b>Edit</b> menu. Clears both the
<b>Event Script</b> and <b>Control Script</b> scripts.
}

set helps(menu-Edit-Erase_script) {
  Available on the <b>Event Script</b> and <b>Control Script</b>
tabs.
<p>
This will delete the script displayed on the currently selected tab.
}

set helps(menu-Edit-Compress_motion_events) {
  This option only exists on the <b>Event Script</b> tab.<p>
When recording events the windowing system will generate many
mouse motion events.
<P>
This option finds the cursor-motion events and compresses them
to a single motion to the final location.
}

set helps(menu-Edit-Regenerate_Current_Script) {
  This option only exists on the <b>Event Script</b> tab.<p>
Sometimes a target application is modified in a way that breaks the test,
but is actually correct (for instance, changing the label on a button
will break the window introspection test that expects the old label).
<p>
This menu item will regenerate the events from the test and will
replace the expected values from the test with the current values.
}

set helps(menu-Edit-Reset_Current_Script_App_Target) {
  This option only exists on the <b>Event Script</b> tab.<p>
 The tktest event scripts know what application they are to be
attached to.
<p>
Sometimes this application changes. The target application might
be renamed, or a second copy is being tested, thus you would have
<b>testApp.tcl #2</b> instead of <b>testApp.tcl</b>
<p>
This option resets target defined by the current event script 
to be the currently attached application.
<p>
A script can automatically reset the target by adding this string
to the first .tkr file
<p>
<b>
InsertAction {0} {ThisApp} {ExecTcl} {{ResetTargetForScript} 0}
</b>
}

set helps(menu-Edit-Genericize_the_current_script) {
  This option only exists on the <b>Event Script</b> tab.<p>
  The default behavior of the introspection tests is to extract
a string from the target application and test to see that the exact
same string is returned in future tests.
<p>
  This creates problems when non-essential parts of the returned
value change. For example, a time/date string will never be the
same on subsequent tests.
<p>
This menu item will open a window like this:
<p>
<img src="genericize">
<p>
Glob patterns can be added to the text window, one pattern per
line.
<p>
All occurrances of strings that match the pattern will be replaced
by the glob pattern.
<p>
For example, this pattern:  <br>
<b>[0-9][0-9]/[0-9][0-9]/[0-9][0-9]<b>
<br>
will cause all date strings like:
<b>12/25/15</b>
to be replaced by the glob expression.
<p>
This will allow any date to be accepted as a match to the 
expected string.
}

set helps(menu-Edit-Delete_selected_event) {
  This option only exists on the <b>Event Script</b> tab.<p>
  Deletes a highlighted event
}

set helps(menu-Edit-Edit_selected_event) {
  This option only exists on the <b>Event Script</b> tab.<p>
  Opens an edit window to modify the highlighted event.
}


set helps(button-arraymagnify) {
  <IMG src="arraymagnify">
<br>
Prompts the user for the name of an array in the target application
and records the contents of the array.

}
set helps(button-sqlmagnify) {
  <IMG src="sqlmagnify">
<br>
Prompts the user for an SQL query, executs the sql command in the
target and records the return value.
}
set helps(button-winmagnifyGray) {
  <IMG src="winmagnifyGray">
  <br> Performs the same action as the <img src="winmagnify"> button, but
discards background color information.
<a href="button-winmagnify">Window Introspection</a>
}
set helps(button-winmagnify) {
  <IMG src="winmagnify">
  <BR>
Presents the user with a tree of windows in the target application. The
window will resemble this:
<br>
<img src="winSel">
<br>
Clicking on the tree control symbols in squares will open or close
that branch of the tree.
<p>
Left clicking on a window name will query that window and its descendants
and will record the window name, class, configuration options and grid options.

}

set helps(button-pause) {
  <IMG src="pause">
  <BR>
  Pauses the task.
}

set helps(button-wait) {
  <IMG src="pause">
  <BR>
Prompts the user for a condition string and a true/false value.
  The tktest script will pause until this condition is achieved in the
target.  
<p>
This feature allows tktest to wait until a non-deterministic event
occurs - for example, the appearance of a window that may be delayed
until processing is complete.
<p>
This dialog:
<br>
<img src="waitDialog">
<br>
will pause the tktest until the <b>.complete</b> window appears in
the target application.
}

set helps(button-tinytcl) {
  <IMG src="tinytcl">
  <BR>
  This button opens a dialog box as shown:
<br>
<img src="addTcl">
<br>
  The code in the window will be executed on the target when the
  task is run. It does not execute immediately.
  <p>
  This can be used to vwait on a variable, or to execute a task
  from the <b>tktest</b> application (perhaps modifying the environment
  to confirm that the target task reflects this.)
}

set helps(button-comment) {
  <IMG src="comment">
  <BR>
  <dd> This lets you add comments into a .tkr script.

}

set helps(button-feathermagnify) {
  <IMG src="feathermagnify">
<br>
 Prompts the user for a Tcl script which will be evaluated on
the target system. The return value for this script will be recorded for
future use.
}

set helps(button-edit16T) {
  <IMG src="edit16T">
  <BR>
  Inserts an event or directive script into a control script.
}
set helps(button-erase16T) {
  <IMG src="erase16T">
  <BR>
  Erases the script displayed in the script window. Valid on both
  <b>Event Script</b> and <b>Control Script</b> windows.
}
set helps(button-rewind) {
  <IMG src="rewind">
  <BR>
  Rewinds the event or control script to the top to allow it to
  be replayed.
}
set helps(button-record) {
  <IMG src="record">
  <BR>
  Starts a recording session.  This must be pressed before adding any
  introspection tests.
}
set helps(button-stop) {
  <IMG src="stop">
  <BR>
 Stops a recording session.
 <p>
 Should be clicked before saving or rerunning a set of events.
}

set helps(button-fforward) {
  <IMG src="fforward">
  <BR>
  Plays an event script or control script as fast as possible.

}

set helps(button-play) {
  <IMG src="play">
  <BR>
  Plays an event script or control script at normal speed.
}
# End of the ::help namespace
}
