set Bulle(set) -1
set Bulle(first) 0
set Bulle(prevTarget) ""

set release(balloon.tcl) {$Header: /home/cvs/tktest/helpBalloon.tcl,v 1.2 2015/05/04 13:13:18 clif Exp $}

bind Bulle <Enter> {
    set Bulle(set) 0
    set Bulle(first) 1
    set Bulle(id) [after 250 {show_balloon %W $Bulle(%W) %X %Y}]
}

bind Bulle <Button> {
    set Bulle(first) 0
    set Bulle(prevTarget) ""
    kill_balloon
}

bind Bulle <Leave> {
    set Bulle(first) 0
    set Bulle(prevTarget) ""
    kill_balloon
}

bind Bulle <Destroy> {
    if {[info exists Bulle(target)] && "%W"==$Bulle(target)} {
        kill_balloon
        set Bulle(prevTarget) ""
    }
}

bind Bulle <Motion> {
    if {$Bulle(set) == 0} {
        after cancel $Bulle(id)
        set Bulle(id) [after 250 {show_balloon %W $Bulle(%W) %X %Y}]
    }
}

proc balloon {target message { statmsg "" } } {
    global Bulle
    set Bulle($target) [list $message  $statmsg]
    set x [bindtags $target]
    if {[lsearch $x Bulle]<0} {
        lappend x Bulle
        bindtags $target $x
    }
}

proc kill_balloon {} {
    global Bulle
    catch {after cancel $Bulle(id)}
    if {[winfo exists .balloon] == 1} {
        destroy .balloon
    }
    set Bulle(set) 0
}

proc show_balloon {target messageLst {cx 0} {cy 0} } {
    global Bulle
puts "SHOW: $target - $messageLst"
    set message [lindex $messageLst 0]
    if {$message==""} return
    if {$Bulle(first) == 2 } {
      if {[string length $target] > [string length $Bulle(prevTarget)]} {
        set Bulle(prevTarget) $target
	set Bulle(first) 1
      }
    }
    if {$Bulle(first) == 1 } {
        set Bulle(first) 2
	if { $cx == 0 && $cy == 0 } {
	    set x [expr [winfo rootx $target] + ([winfo width $target]/2)]
	    set y [expr [winfo rooty $target] + [winfo height $target] + 4]
	} else {
	    set x [expr $cx + 8]
	    set y [expr $cy + 8]
	}
        catch {destroy .balloon}
        toplevel .balloon -bg  #eeee99
        wm overrideredirect .balloon 1
        set sw [winfo screenwidth .balloon]
        set sh [winfo screenheight .balloon]
        label .balloon.l -justify left \
            -text "$message" -relief flat -borderwidth 0\
            -bg #ffffaa -fg black -padx 2 -pady 2 -anchor w
        pack .balloon.l -side left -padx 1 -pady 1
        wm geometry .balloon +${sw}+${sh}
        update idletasks
        if {![winfo exists .balloon]} return
        set width [winfo reqwidth .balloon]
        set height [winfo reqheight .balloon]
        if {$x+$width>$sw} {set x [expr {$cx - ($width+4)}]}
        if {$y>$sh*0.75} {set y [expr {$cy - ($height+4)}]}
        wm geometry .balloon +${x}+${y}
        set Bulle(set) 1
        set Bulle(target) $target
    }
}
