set Release(introspect.tcl) {$Header: /home/cvs/tktest/introspect.tcl,v 1.46 2016/09/13 16:23:37 clif Exp $}

proc rmItemsWith { pattern lst} {
  while {[set p [lsearch $lst *$pattern*]] >= 0} {
    set lst [lreplace $lst $p $p]
  }
  return $lst
}

proc reduceWindowReturn {patterns contents} {
  foreach pattern $patterns {
    set nc {}
    foreach el $contents {
      lappend nc [rmItemsWith $pattern $el]
    }
    set contents $nc
  }
  return $contents
}

proc FailButton {msg} {
  if {![winfo exists .failButtons]} {
    toplevel .failButtons
  }
  set top .failButtons
  set w [button $top.b[clock seconds] -text [string range $msg 0 60] -width 62\
      -command [list ShowFailWinDetails $msg] ]
  grid $w
}

proc ShowFailWinDetails {msg} {
  doWins $msg
  doDiff $msg
}

proc getElementAtLoc {list loc} {
  set len 0
  if {[llength $list] == 1} {
    set p1 [expr {$loc-10}]
    if {$p1 < 0} {set p1 0}
    set p2 [expr {$loc+20}]
    if {$p2 > [string length $list]} {
      set p2 [string length $list]
    }
    return [string range $list $p1 $p2]
  } else {
    foreach el $list {
      incr len [string length $el]
      incr len 1

      if {$len > $loc} {
        return $el
      }
    }
  }
  return $el
}

proc makeGrabGUI {txt lbl command} {
  catch {destroy .replay.grabFrame}

  set w [frame .replay.grabFrame -relief raised -borderwidth 5]
  set w [labelframe .replay.grabFrame.lf -text "$txt" ]

  label $w.l1 -text $lbl

  entry $w.e1  -width 50

  button $w.b1 -text "Cancel" -command {
      destroy .replay.grabFrame;
      set ReplayData(Timer) 1
      }

  button $w.b2 -text "Go" -command "\
      $command \[.replay.grabFrame.lf.e1 get\];  \
      destroy .replay.grabFrame; \
      "
  grid $w.l1 -row 1 -column 0
  grid $w.e1 -row 1 -column 1
  grid $w.b1 -row 2 -column 0
  grid $w.b2 -row 2 -column 1
  pack .replay.grabFrame.lf
  place .replay.grabFrame -relx .5 -rely .5 -anchor center
}

proc grabArrayGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Get Array Snapshot" "Array Name" grabArray
}

proc grabSQLGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Get SQL Snapshot" "SQL CMD" grabSQL
}

proc grabTCLGUI {} {
  global ReplayData
  set ReplayData(Timer) 0

  makeGrabGUI "Check Return of Tcl command" "TCL CMD" grabTCL
}

proc grabWindowContentsGUI { {useColor yes} } {
  global ReplayData
  set ReplayData(useColor) $useColor
  set ReplayData(Timer) 0
  showClientWindows AddWinCheck
}

proc AddWinCheck {node} {
  global Windows
  
  set win $Windows($node)
  grabWindowContents $win
}

proc grabWindowContents {win} {
  global ReplayData

  set contents [getContents $win]

  if {$ReplayData(useColor) ne "yes"} {
    set contents [reduceWindowReturn #?????? $contents]
  InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckWinReturn $win $contents #?????? ] 1 ]
  } else {
  InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckWinReturn $win $contents] 1]
  }

    set ReplayData(Timer) 1
}

proc getReply {cmd} {
  global ReplayData
  tkrsend $ReplayData(ConnectedApps) \
    "catch {$cmd} rpl; socksend  tktest.tcl \"set ReplayData(Reply) \[list \$rpl]\""
  vwait ReplayData(Reply)
  return $ReplayData(Reply)
}

proc OLDgetPlacementInfo {win} {
  if {[getReply "winfo ismappedr $win"] == 0} {
    return "Unmapped"
  }
  set mgr [getReply "winfo manager $win"]
  if {($mgr eq "") || ($mgr eq "wm")} {
    lappend rtn "Unmanaged"
  } else {
    lappend rtn [list $mgr [getReply "$mgr info $win"]]
  }
  return $rtn
}
proc getPlacementInfo {win} {
  if {[getReply "winfo ismappedr $win"] == 0} {
    return "Unmapped"
  }
  set mgr [getReply "winfo manager $win"]
  switch $mgr {
    "" -
    "wm" {
      lappend rtn "Unmanaged"
     }
     "notebook" {
       set pnt [join [lrange [split $win .] 0 end-1] .]
       set tabNum [getReply "$pnt index $win"]
       set lbl [dict get [getReply "$pnt tab $tabNum"] -text]
       lappend rtn [list $pnt add $win -text $lbl]
     }
     "panedwindow" {
       set pnt [join [lrange [split $win .] 0 end-1] .]
       lappend rtn [list $pnt add $win]
     }
     "pack" -
     "place" -
     "grid" {
        lappend rtn [list $mgr [getReply "$mgr info $win"]]
      }
  }
  return $rtn
}

proc getContents {win} {
  global ReplayData

  if {[string first "#" $win] == 1} {
    return {}
  }

  set type [getReply "winfo class $win"]

  # Html widget creates a child that's not real.
  # has no class and does not configure.
  if {$type eq ""} {return {}}

  MsgToUser "Retrieving info for $win of type $type" info

  set rtn "$win $type "

  switch -glob -- $type {
     *.tcl {
        set type Toplevel

        set children [getReply "winfo children $win"]
	lappend rtn {} {}
	foreach ch $children {
	  append rtn " [getContents $ch]"
	}
     }
     Tobe -
     Html -
     Labelframe -
     Toplevel -
     Panedwindow -
     TNotebook -
     Notebook -
     TCombobox -
     Scale -
     ComboboxPopdown -
     TFrame -
     Vov -
     Frame {
        lappend rtn [getReply "$win configure"]
	lappend rtn [getPlacementInfo $win]
        set children [getReply "winfo children $win"]
	foreach ch $children {
	  append rtn " [getContents $ch]"
	}
     }
     Entry {
        set tdef [getReply "$win configure"]
        lappend tdef [list -textContent textContent TextContent [getReply "$win get"]]
	lappend rtn $tdef
	lappend rtn [getPlacementInfo $win]
     }
     Treeview -
     Listbox {
        lappend rtn [getReply "$win configure"]
	lappend rtn [getPlacementInfo $win]
     }
     Spinbox -
     Button -
     Listbox -
     Checkbutton -
     Message -
     Label {
        lappend rtn [getReply "$win configure"]
	lappend rtn [getPlacementInfo $win]
     }
     Menubutton -
     Menubar -
     Menu {
        lappend rtn [getReply "$win configure"]
	lappend rtn [getPlacementInfo $win]
	
	if {$type eq "Menu"} {
          set entryCount [getReply "$win index end"]
          if {[string is double $entryCount]} {
  	    for {set i 0} {$i <= $entryCount} {incr i} {
	      lappend rtn $i MenuEntry
	      lappend rtn [getReply "$win entryconfigure $i"]
	      lappend rtn {}
	    }
	  }
	}

        set children [getReply "winfo children $win"]
	foreach ch $children {
	  append rtn " [getContents $ch]"
	}
     }
     Text {
       set tdef [getReply "$win configure"]
       lappend tdef [list -textContent textContent TextContent [getReply "$win get 0.0 end"]]
       lappend tdef [list -imageDump imageDump ImageDump [getReply "$win dump -image 0.0 end"]]
       lappend tdef [list -tagDump tagDump TagDump [getReply "$win dump -tag 0.0 end"]]
       lappend tdef [list -winDump winDump WinDump [getReply "$win dump -window 0.0 end"]]
       lappend rtn $tdef
       lappend rtn [getPlacementInfo $win]
     }
     Canvas {
       set cdef [getReply "$win configure"]
       lappend cdef [list -elements elements Elements [lsort [getReply "$win find all"]] ]
       foreach i [getReply "$win find all"] {
         lappend cdef \
	   [list $i [getReply "$win type $i"] [getReply "$win itemconfigure $i"] [getReply "$win coords $i"]]
       }
       lappend rtn $cdef
       lappend rtn [getPlacementInfo $win]
     }

     TScrollbar -
     Scrollbar {
       lappend rtn [getReply "$win configure"]
       lappend rtn [getPlacementInfo $win]
     }

     Table {
       set tdef [getReply "$win configure"]
       for {set r 0} {$r < [getReply "$win cget -rows"]} {incr r} {
         for {set c 0} {$c < [getReply "$win cget -cols"]} {incr c} {
	   lappend tdef [list $r,$c [getReply "$win get $r,$c"]]
	 }
       }

       foreach t [getReply "$win tag names"] {
	 lappend tdef [list $t [getReply "$win tag cell $t"]]
       }
       lappend rtn $tdef
       lappend rtn [getPlacementInfo $win]
     }

     default {
       if {[set parsed [parseError $type]] ne ""} {
         lappend rtn $parsed
       } else {
         tk_messageBox -type ok -message "Can't track ..$type.. WIN: $win (yet)"
       }
     }
  }

  MsgToUser "Finished retrieving info for $win of type $type" info

  return $rtn
}

################################################################
# proc parseError {msg}--
#    Attempt to parse failure messages from client
# Arguments
#   msg		Returned "winfo class" in client.
# 
# Results
#   A more human readable error, or empty string if error
#   is not grokked.
# 
proc parseError {msg} {

  if {[string first "bad window path name" $msg] >= 0} {
    set p1 [string first {"} $msg]
    set p2 [string last {"} $msg]

    return "Target window [string range $msg $p1 $p2] does not exist in test"
  }
  return ""
}

proc grabArray {arrayName} {
    global ReplayData
    set xx [getReply "array get $arrayName"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckArrayReturn [list array get $arrayName] $xx] 1]
    set ReplayData(Timer) 1
}


proc grabSQL {cmd} {
    global ReplayData
    set xx [getReply "db eval {$cmd}"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckReturn [list db eval $cmd] $xx] 1]
    set ReplayData(Timer) 1
}

proc grabTCL {cmd} {
    global ReplayData
    set xx [getReply "eval $cmd"]
    
    set level $ReplayData(Level)
    
    InsertAction 0 $ReplayData(ConnectedApps) ExecTcl \
      [list [list CheckReturn [list eval $cmd] $xx] 1]
    set ReplayData(Timer) 1
}


proc CheckWinReturn {win expect {wipe {}} } {
  global  ReplayData
  set contents [getContents $win]
  
  if {!$ReplayData(strict)} {
    foreach item $ReplayData(looseConfigOptions) {
      set contents [reduceWindowReturn $item $contents]
      set expect [reduceWindowReturn $item $expect]
    }
  }
  
  foreach item $wipe {
    set contents [reduceWindowReturn $item $contents]
  }

  set misMatch 1
  if {[string equal $expect $contents]} {
    set misMatch 0
  }
# set of [open /tmp/MYout a]
# puts $of "WIN: $win\n[string range $expect 0 80]"
# puts $of "WIN: $win\n[string range $contents 0 80]"
# puts $of "A: $misMatch -- [string equal $expect $contents]"
  if {$misMatch} {
    if {[string match $expect $contents]} {
      set misMatch 0
    }
  }
# puts $of "B: $misMatch [string match $expect $contents]"
# close $of
if {$misMatch} {
if {0} {
set of [open /tmp/out1 w]
puts $of $expect
close $of

set of [open /tmp/out2 w]
puts $of $contents
close $of
}

      set misMatchLoc [strDiff $contents $expect]
      set expEl [getElementAtLoc $expect $misMatchLoc]
      set contEl [getElementAtLoc $contents $misMatchLoc]

      set msg "Window Compare FAIL: ($ReplayData(ScriptFileName)): $win Near $misMatchLoc"
      append msg "\n  FULL EXP: \"$expect\""
      append msg "\n  FULL SAW: \"$contents\""
      append msg "\n  ELEM EXP: \"$expEl\""
      append msg "\n  ELEM SAW: \"$contEl\""
      set ReplayData(failTest) 1
    } else {
      set msg "Window Check OK: ($ReplayData(ScriptFileName)): $win"
      set ReplayData(failTest) 0
    }
    MsgToUser $msg high
}

proc CheckReturn {cmd expect} {
    global ReplayData

    set xx [getReply "$cmd"]

    # String match can be confused by patterns that string
    # equal accepts - stuff with {{ }} confuses string match.
    # But if it's equal, go for it.
    # Else check the match. Maybe there's wildcards or something.

    if {![string equal $expect $xx]} {
      set rslt [string match $expect $xx]
    } else {
      set rslt 1
    }

    if {$rslt} {
      set msg "Cmd Check OK: ($ReplayData(ScriptFileName)): $cmd"
    } else {
puts "EXPLEN: [string length $expect] GOT: EXPLEN: [string length $xx]"
puts "EXP: ...$expect..."
puts "XXX: ...$xx..."

      set misMatchLoc [strDiff $xx $expect]
      set msg "Cmd FAIL: ($ReplayData(ScriptFileName)): [string range $cmd 0 60]"
      append msg "\n  FULL EXP: \"$expect\""
      append msg "\n  FULL SAW: \"$xx\""
      append msg "\n  ELEM EXP: [string range $expect [expr {$misMatchLoc-40}] [expr {$misMatchLoc+40}]]"
      append msg "\n  ELEM SAW: [string range $xx [expr {$misMatchLoc-40}] [expr {$misMatchLoc+40}]]"
    }
    MsgToUser "$msg" high
}

proc CheckArrayReturn {cmd expect} {
    global ReplayData
    set xx [getReply "$cmd"]
    if {[string match $expect $xx]} {
      set msg "Array Check OK: ($ReplayData(ScriptFileName)): $cmd"
    } else {
      set notsaw {}
      set notexp {}
      set mismatch {}
      set misMatchLoc [strDiff $xx $expect]
      set msg "Array Check FAIL: ($ReplayData(ScriptFileName)): [string range $cmd 0 60]"
      append msg "\n  EXP: [expr {[llength $expect]/2}] indices - $expect"
      append msg "\n  SAW: [expr {[llength $xx]/2}] indices - $xx"

      set ReplayData(detailedMessage) $msg
      
      array set saw $xx
      array set exp $expect
      foreach in [array names saw] {
        if {![info exists exp($in)]} {
	  lappend notexp $in
	} else {
	  if {![string match $exp($in) $saw($in)]} {
	    lappend mismatch [list $in $exp($in) $saw($in)]
	  }
	}
      }
      foreach in [array names exp] {
        if {![info exists saw($in)]} {
	  lappend notsaw $in
	} else {
	  if {![string match $exp($in) $saw($in)] &&
	       ([lsearch $mismatch "$in *"] < 0) } {
	    lappend mismatch [list $in $exp($in) $saw($in)]
	  }
	}
      }
      
      append ReplayData(detailedMessage) "\n Indices in new data, not in expected data\n"

      foreach in $notexp {
              append ReplayData(detailedMessage) "$in\n"
      }
      

      append ReplayData(detailedMessage) "\n Indices in expected data, not in new data\n"

      foreach in $notsaw {
              append ReplayData(detailedMessage) "$in\n"
      }

      append ReplayData(detailedMessage) "\n Mismatched values\n"

      foreach in $mismatch {
              append ReplayData(detailedMessage) "$in\n"
      }
    }
    MsgToUser "$msg" high
}


proc strDiff {str1 str2} {
  set pos 0
  foreach l1 [split $str1 ""] l2 [split $str2 ""] {
    if {$l1 ne $l2} {
      return $pos
    }
    incr pos
  }
  return $pos
}

