
set Release(mainwin.tcl) {$Header: /home/cvs/tktest/mainwin.tcl,v 1.48 2016/09/06 18:00:04 clif Exp $}

###################################################################
# MakeReplayWindow: creates the replay control window.
###################################################################
package require BWidget

################################################################
# proc labelNlabel {pnt txt1 txtvar2}--
#    Megawidget to show two labels in a frame.
# Arguments
#   pnt		Parent frame to create
#   txt1	Text for left label
#   txtvar2	Variable name to connect with right label.
# 
# Results
#   New frame and labels are created.  Labels are gridded within the
#   frame, but frame is not displayed.
# 
proc labelNlabel {pnt txt1 txtvar2} {
  set f [frame $pnt -borderwidth 1 -relief ridge]
  set l1 [label $f.l1 -text "${txt1}: " -borderwidth 0 -width 13 -anchor e]
  set l2 [label $f.l2 -textvar $txtvar2  -borderwidth 0 -width 20  -bg #eee -anchor w]
  grid $l1 $l2
  return $f
}

proc MakeReplayWindow {} {
    global ReplayData
    global GUI 
    
    set GUI(noAfterEvents) 1

    DynamicHelp::configure  -font {arial 12}
    
    # Construct and place the primary GUI widgets
    # Holders, Frames, etc.

    set mainframe [toplevel .replay -menu .replay.mm]
    wm title .replay "TkTest: $::VERSION"
    
    set row 0

    set GUI(editFrame) [frame $mainframe.ef]
    grid $GUI(editFrame) -row $row -column 0 -sticky news
    incr row

    frame $mainframe.div1 -height 5 -relief flat -borderwidth 1
    grid $mainframe.div1 -row $row -column 0 -sticky ew
    incr row

    set fr [frame $mainframe.status -relief sunken]
    grid $fr -row $row -column 0 -sticky ewns -columnspan 2
    incr row
    
    set f [labelNlabel $fr.st Status  ReplayData(Status)]
    grid $f  -row $row -column 0 -sticky ew  -padx {4 2} -pady {0 2}

    set f [labelNlabel $fr.scr "Event Script" ReplayData(ScriptFileName)]
    grid $f -row $row -column 1 -sticky ew  -padx {2 2} -pady {0 2}

    incr row

    set f [labelNlabel $fr.ct "Connected To" ReplayData(ConnectedApps)]
    grid $f  -row $row -column 0 -sticky ew -padx {4 2}

    set f [labelNlabel $fr.cscr "Control Script" ReplayData(ControlNameOnly)]
    grid $f -row $row -column 1 -sticky ew -padx {2 2} 

    incr row
    frame $mainframe.div2 -height 5 -relief flat -borderwidth 1
    grid $mainframe.div2 -row $row -column 0 -sticky ew

    incr row
    set GUI(nb) [NoteBook $mainframe.nb -height 400 -width 350]
    grid $GUI(nb) -row $row -column 0 -sticky news
    # Configure the windows to expand when main window resizes

    grid columnconfigure .replay 0 -weight 1
    grid rowconfigure .replay $row  -weight 1
    
    incr row
    
    label $mainframe.statusmessage -textvar ReplayData(StatusMessage) -width 70 -bg #eee
    grid $mainframe.statusmessage -row $row -column 0 -sticky w
    incr row

    # Start filling the primary widgets

    #             Create the replay menus
    # File menu
    
    set menu [menu $mainframe.mm]

    $menu add cascade -label "File" -menu $menu.file 
    menu $menu.file
    $menu.file add command -label "Open..." -command "Load"
    $menu.file add command -label "Save" -command "Save"
    $menu.file add command -label "Save As..." -command "SaveAs"

    MonitorApps
    $menu.file add separator
    $menu.file add command -label "Quit TkTest" -command "doExit"
    #
    # Edit menu
    #
    $menu add cascade -label "Edit" -menu $menu.edit 
    menu $menu.edit
    $menu.edit add command -label "Clear Event and Control scripts" -command "EraseScript; EraseControl"
    $menu.edit add separator

    #     No useful options in tktest
    #    $menu.edit add command -label "Preferences..." -command "OptionBox"

    #
    # Settings menu
    #
    $menu add cascade -label "Settings" -menu $menu.settings
    menu $menu.settings
    $menu.settings add radiobutton -label "Filter Out After Events" \
        -variable GUI(noAfterEvents) -value 1

    $menu.settings add radiobutton -label "Proc Level Coverage Report" \
        -variable GUI(ProcCoverage) -value 1

    #
    # Help menu
    #

    $menu add cascade -label "Help" -menu $menu.help
    menu $menu.help
#    $menu.help add command -label "Show help file" \
#        -command "ShowHelp"
    $menu.help add command -label "About" -command "help::about"
    $menu.help add command -label "Versions" -command "help::versions"
    help::fillHelpMenu $menu.help
    

    # Fill the initial notebook page
    
    set row 0
    set col 0

    set GUI(events) [$GUI(nb) insert end events -text "Event Script"]
    $GUI(nb) raise events
    
#    set menu [menu $GUI(events).mm -type menubar -relief groove ]
    set menu [frame $GUI(events).mm -relief groove ]
    grid $menu -row 0 -column 0 -columnspan 3 -sticky ew
    incr row

    #             Create the replay menus
    # File menu
    
    #$menu add cascade -label "File" -menu $menu.file 
    menubutton $menu.f  -text "File" -menu $menu.f.file 
    grid $menu.f -row 0 -column 1
    set mf [menu $menu.f.file -tearoff 0]
    $mf add command -label "Open..." -command "puts LOAD; Load"
    $mf add command -label "Save" -command "Save"
    $mf add command -label "Save As..." -command "SaveAs"

    #
    # Edit menu
    #
    #$menu add cascade -label "Edit" -menu $menu.edit 
    #menu $menu.edit

    menubutton $menu.e -text "Edit" -menu $menu.e.edit 
    grid $menu.e -row 0 -column 2
    set mf [menu $menu.e.edit ]

    $mf add command -label "Erase script" -command "EraseScript"

    $mf add separator
    $mf add command -label "Compress motion events" \
        -command "CompressMotionEvents"

    $mf add command -label "Regenerate Current Script" \
        -command "RebuildScript"

    $mf add command -label "Reset Current Script App Target" \
        -command "ResetTargetForScript"

    $mf add command -label "Remove Destroy Window events" \
        -command "removeDestroyWin"

    $mf add command -label "Genericize the current script" \
        -command "genericizeScriptGUI"

    $mf add separator

    $mf add command -label "Delete selected event" -command "DeleteEvent"
    $mf add command -label "Edit selected event" -command "EditEvent"
#    $mf add command -label "Change delay..." -command "EditEvent"
    
    set GUI(bbox) [ButtonBox $GUI(events).box1 -spacing 0 -padx 1 -pady 1]
    grid $GUI(bbox) -row $row -column 0 -sticky w

    #
    # Fill the button bar
    #

    set cmds {
	      record    Record      StartRecording
              play      Play        Replay
	      fforward  "Play Fast" ReplayFast
	      rewind    Rewind      Rewind
	      stop      Stop        StopRecording
              pause     Pause       AddPause
	      }
    
    foreach {img help cmd} $cmds {
      set GUI(button.$img) [$GUI(bbox) add -image $img \
        -helptext $help \
	-height 20 -width 20 \
        -command $cmd ]
    }
    
    set GUI(bbox2) [ButtonBox $GUI(events).box2 -spacing 0 -padx 1 -pady 1]
    grid $GUI(bbox2) -row $row -column 1 -sticky w

    incr row
     
    set cmds {
	      arraymagnify "Check an Array" grabArrayGUI
	      sqlmagnify "Check a SQL " grabSQLGUI
	      winmagnify "Check a Window including background Color" grabWindowContentsGUI
	      winmagnifyGray "Check a Window ignore background Color" {grabWindowContentsGUI noColor}
	      feathermagnify "Check Script return" grabTCLGUI
              pause     Pause       AddPause
	      wait	Wait	    AddWait
              tinytcl "Add Tcl Script" AddTcl
              comment "Add A Comment" AddComment
              erase16T  "Erase Script"       EraseScript
	      }
    
    foreach {img help cmd} $cmds {
      set GUI(button.$img) [$GUI(bbox2) add -image $img \
	-height 20 -width 20 \
        -helptext $help \
        -command $cmd ]
    }

    set GUI(eventlistbox) [ listbox $GUI(events).list -height 12 -width 35 \
        -relief sunken  -borderwidth 2 \
	-yscroll "$GUI(events).yscroll set" \
	-xscroll "$GUI(events).xscroll set" \
        -exportselection false ]
    
    scrollbar $GUI(events).yscroll -orient vertical -relief sunken \
        -bd 2 -command "$GUI(events).list yview"

    scrollbar $GUI(events).xscroll -orient horizontal -relief sunken \
        -bd 2 -command "$GUI(events).list xview"
     
    grid $GUI(events).list -row $row -column 0 -sticky news -columnspan 2
    grid $GUI(events).yscroll -row $row -column 2 -sticky ns
    grid columnconfigure $GUI(events) 0 -weight 1
    grid columnconfigure $GUI(events) 1 -weight 1
    grid rowconfigure $GUI(events) $row -weight 1
    incr row
    grid $GUI(events).xscroll -row $row -column 0 -sticky ew -columnspan 2
    
    # Define control notebook page

    set GUI(control) [$GUI(nb) insert end control -text "Control Script"]
    
#    set menu [menu $GUI(control).mm -type menubar -relief groove ]
    set menu [frame $GUI(control).mm -relief groove]
    grid $menu -row 0 -column 0 -columnspan 3 -sticky ew

    #             Create the replay menus
    # File menu
    
#    $menu add cascade -label "File" -menu $menu.file 
    menubutton $menu.f -text "File" -menu  $menu.f.file 
    grid $menu.f -row 0 -column 1

    set mf [menu $menu.f.file -tearoff 0]
    $mf add command -label "Open..." -command "LoadControlBox"
    $mf add command -label "Save" -command "SaveControlBox"
    $mf add command -label "Save As..." -command "SaveAsControlBox"

    #
    # Edit menu
    #
    #$menu add cascade -label "Edit" -menu $menu.edit 
    menubutton $menu.e -text "Edit" -menu $menu.e.edit 
    grid $menu.e -row 0 -column 2

    set mf [menu $menu.e.edit -tearoff 0]
    $mf add command -label "Erase script" -command "EraseControl"
    $mf add command -label "Generalize" -command "GeneralizeControl"
    $mf add separator
    
    set GUI(bbox) [ButtonBox $GUI(control).box1 -spacing 0 -padx 1 -pady 1]
    grid $GUI(bbox) -row $row -column 0 -sticky w

    # Fill the button bar

    set cmds {
              play      "Play Control Script"      "PlayControlGUI Normal"
	      fforward  "Play Control Script Fast" "PlayControlGUI Fast"
	      rewind    Rewind      Rewind
	      stop      Stop        {set ReplayData(ControlRun) 0}
              pause     Pause       AddPause
	      }
    
    foreach {img help cmd} $cmds {
      set GUI(button.$img) [$GUI(bbox) add -image $img \
        -helptext $help \
	-height 20 -width 20 \
        -command $cmd ]
    }

    set GUI(bbox2) [ButtonBox $GUI(control).box2 -spacing 0 -padx 1 -pady 1]
    grid $GUI(bbox2) -row $row -column 1 -sticky w
    incr row


    set cmds {
	      edit16T "Insert a Script" InsertControl
              erase16T  "Erase Script"       EraseControl
	      }
    
    foreach {img help cmd} $cmds {
      set GUI(button.$img) [$GUI(bbox2) add -image $img \
	-height 20 -width 20 \
        -helptext $help \
        -command $cmd ]
    }
    
    set ReplayData(controlText) [text $GUI(control).txt -width 40 \
        -xscroll "$GUI(control).xsb set" -yscroll "$GUI(control).ysb set" \
	-wrap none \
        -height 20 -background white]
    scrollbar $GUI(control).xsb -orient horizontal -command "$GUI(control).txt xview"
    scrollbar $GUI(control).ysb -orient vertical -command "$GUI(control).txt yview"

    grid $GUI(control).txt -row $row -column 0 -columnspan 2 -sticky news
    grid $GUI(control).ysb -row $row -column 2 -sticky ns
    grid columnconfigure $GUI(control) 0 -weight 1
    grid columnconfigure $GUI(control) 1 -weight 1
    grid rowconfigure $GUI(control) $row -weight 1

    incr row
    grid $GUI(control).xsb -row $row -column 0 -sticky ew -columnspan 2
    
    set ReplayData(Status) Disconnected
    
  wm withdraw .replay
  update idle;
  wm geometry .replay -5-70
#  wm geometry .replay 10 10
  wm deiconify .replay
  return
}

proc SetScriptFileName {} {
    global ReplayData
    set ReplayData(ScriptFileName) \
        [file tail $ReplayData($ReplayData(Level),ScriptFileName)]
}



#
# RecordMessage: record a message in the transcript window
#
proc RecordMessage {msg} {
    .messageWindow.text insert end $msg
    .messageWindow.text insert end \n
    .messageWindow.text yview -pickplace end
}
#
# MakeMessageWindow: create a window to record messages
#
proc MakeMessageWindow {} {
    set w .messageWindow
    toplevel $w
    wm geometry $w "+0+260"
    wm withdraw $w
    button $w.done -text "Hide this window" -command "wm withdraw $w"
    pack $w.done -side bottom
    scrollbar $w.yscroll -orient vertical -relief sunken -bd 2 \
        -command "$w.text yview"
    pack $w.yscroll -side right -fill y
    text $w.text -width 50 -height 16 -relief sunken -bd 2 \
        -yscrollcommand "$w.yscroll set"
    pack $w.text -side left -fill both -expand yes
    $w.text insert end "*** Transcript of all message ***\n"
}


