set Release(newwin.tcl) {$Header: /home/cvs/tktest/newwin.tcl,v 1.2 2015/11/16 18:26:15 clif Exp $}
namespace eval newwin {}

################################################################
# proc ::newwin::center {w {parent {}}}--
#    Center a window in a parent or the main screen
# Arguments
#   w		The window to center
#   parent	optional window to center within, else center in screen.
# Results
#   Screen modified.
# 
proc ::newwin::center {w {parent {}}} {
  ::update

  set ww [winfo reqwidth $w]
  set wh [winfo reqheight $w]
  if {$parent==""} {
    set px 0
    set py 0
    set pw [winfo screenwidth .]
    set ph [winfo screenheight .]
    if {$pw>$ph*1.25} {set pw [expr {int($ph*1.25)}]}
    if {$ph>$pw*1.25} {set ph [expr {int($pw*1.25)}]}
  } else {
    set px [winfo rootx $parent]
    set py [winfo rooty $parent]
    set pw [winfo width $parent]
    set ph [winfo height $parent]
  }
  set x [expr {$px+($pw-$ww)/2}]
  set y [expr {$py+($ph-$wh)/2}]
  if {$x<0} {set x 0}
  if {$y<0} {set y 0}
  wm geometry $w +$x+$y
  ::newwin::focus $w
}

# proc:  ::newwin::focus WINDOW
# title: Bring WINDOW into focus
#
# Deiconify WINDOW, raise it to the top in stacking order and give
# it keyboard focus.
#
proc ::newwin::focus {w} {
  if {![winfo exists $w]} {set w .df.c}
  set top [winfo toplevel $w]
  if {$top!=$w || [set target [::focus -lastfor $top]]==""} {
    set target $w
  }
  catch {::focus $target}
  wm deiconify $top
  # ::update
  raise $top
  ::focus $target
  after idle [subst -nocommands {catch {
    raise $top
    after idle {catch {::focus $target}}
  }}]
}

