if {$argv eq ""} {
  puts "vwish resultsViewer.tcl resultsFile.txt"
  exit
}

if {[info exists env(REPLAY_LIBRARY)]} {
    set ReplayData(HomeDirectory) $env(REPLAY_LIBRARY)
} else {
    set ReplayData(HomeDirectory) [file dirname [info script]]
}

set homePath [file normalize $ReplayData(HomeDirectory)]
lappend auto_path $homePath
lappend auto_path $homePath/minimalTcllib
tcl::tm::path add $homePath/minimalTcllib
# puts $auto_path
# puts [::tcl::tm::path list]

package require list
package require matrix
package require pool
package require prioqueue
package require record
package require skiplist

source $ReplayData(HomeDirectory)/details.tcl
source $ReplayData(HomeDirectory)/helpBalloon.tcl

wm withdraw .

set if [open $argv r]
set d [read $if]
close $if
catch {destroy [winfo children .]}
if {[catch {doWins $d} err]} {
  puts "doWins Failed: $err"
}

doDiff $d

