#!/bin/sh
# \
    exec wish $0 ${1+"$@"}
#
# tktest.tcl
#     This is the main program for tktest.
#
set Release(tktest.tcl) {$Header: /home/cvs/tktest/tktest.tcl,v 1.50 2016/07/24 14:54:27 clif Exp $}
set VERSION "Beta 0.95"

################################################################
# proc whereami {}--
#    print a call stack without throwing an error
# Arguments
#   NONE
# 
# Results
#   No side effects except to stdout
# 
proc whereami {} {
  for {set i 0} {$i < [info level]} {incr i} {
    puts "I: $i [info level $i]"
  }
}

################################################################
# proc doExit { status }--
#    Exit the application and optionally save data
# Arguments
#   status	Status for exit - default 0 (success)
# 
# Results
#   Creates file if ReplayData(recordFile) is not empty.
# 
proc doExit {{status 0}} {
  global ReplayData
  catch {close $ReplayData(recordFileInternal)}
  exit $status
}

proc destroyExit {w} {
  if {$w eq ".replay"} {
    exit
  }
}
###################################################################
# Set the directory where tktest is installed based on the
# REPLAY_LIBRARY environment variable if it exists.
# Otherwise use the directory where this script resides
if {[info exists env(REPLAY_LIBRARY)]} {
    set ReplayData(HomeDirectory) $env(REPLAY_LIBRARY)
} else {
    set ReplayData(HomeDirectory) [file dirname [info script]]
}
###################################################################
# Set the default wish to use to run applications based on
# the REPLAY_WISH environment variable if it exists.
# Otherwise use wish
if {[info exists env(REPLAY_WISH)]} {
    set ReplayData(DefaultWish) $env(REPLAY_WISH)
} elseif {[info nameofexecutable] != "tktest.tcl"} {
    set ReplayData(DefaultWish) [info nameofexecutable]
} else {
    set ReplayData(DefaultWish) wish
}
#
###################################################################
# Initialization.
###################################################################
global auto_path
global ReplayData
set homePath [file normalize $ReplayData(HomeDirectory)]
lappend auto_path $homePath
lappend auto_path $homePath/minimalTcllib
tcl::tm::path add $homePath/minimalTcllib
puts $auto_path
puts [::tcl::tm::path list]

package require Tk
# source $homePath/tktestLib/list-1.8.1.tm

package require list
package require matrix
package require pool
package require prioqueue
package require record
package require skiplist

source $ReplayData(HomeDirectory)/details.tcl
source $ReplayData(HomeDirectory)/introspect.tcl
source $ReplayData(HomeDirectory)/synchronize.tcl
source $ReplayData(HomeDirectory)/wmap.tcl
source $ReplayData(HomeDirectory)/control.tcl   
source $ReplayData(HomeDirectory)/debugging.tcl 
source $ReplayData(HomeDirectory)/images.tcl    
source $ReplayData(HomeDirectory)/initialize.tcl
source $ReplayData(HomeDirectory)/help.tcl
source $ReplayData(HomeDirectory)/mainwin.tcl
source $ReplayData(HomeDirectory)/connect.tcl
source $ReplayData(HomeDirectory)/edit.tcl   
source $ReplayData(HomeDirectory)/comment.tcl
source $ReplayData(HomeDirectory)/rr.tcl
source $ReplayData(HomeDirectory)/socksend/socksend.tcl
source $ReplayData(HomeDirectory)/tildefy.tcl
source $ReplayData(HomeDirectory)/helpBalloon.tcl
source $ReplayData(HomeDirectory)/directive.tcl
source $ReplayData(HomeDirectory)/details.tcl
source $ReplayData(HomeDirectory)/htmllib.tcl
source $ReplayData(HomeDirectory)/newwin.tcl

wm withdraw .

set ReplayData(scriptFileDir) $ReplayData(HomeDirectory)
# source introspect.tcl
# source control.tcl
# source debugging.tcl
# source images.tcl

#
# USER OPTION: you can leave the highlights in
#
# I don't like the highlights so I get rid of them
#
# option add {*highlightThickness} 0 widgetDefault
#
Initialize
MakeMessageWindow
MakeReplayWindow
EraseScript
update
#
# read the command line arguments (if any)
#
set len [llength $argv]

array set ReplayData {
  OldCursor {}
  MyPort 3010
  appNames {}
  demo 0
  detailedMessage {}
  exitChild 0
  playScript {}
  recordFile {}
  recordFileInternal {}
  resetTarget 0
  script {}
  strict 1
  useColor 1
  exitSelf 0
  autoRegen 0
  coverage 0
}

set validOptions {
Valid -options:
 -demo 		Run in demo mode
 -appNames   	Application to run/test
 -script 	Tkr script to load 
 -MyPort	Port if non standard.
 -playScript 	Play speed for auto runs [normal fast fastonce]
 -pointWithMouse 	UNUSED [1 0]
 -pointWithArrow 	UNUSED [01]
 -recordFile string	Record a log file
 -strict 	Windows checks are strict or loose [01]
 -exitChild     Send exit cmd to child after run
 -useColor	yes/no to remove #?????? info from Win returns
 -autoRegen	1/0 Run .tkr and regenerate it. OVERWRITES ORIGINAL
 -resetTarget	1/0 - Reset target to current before running.
 -coverage      1/0 - [0] Perform proc level coverage analysis
}

set ReplayData(looseConfigOptions) {
  -sticky -column -columnspan -coverage -in -ipadx -ipady -padx -pady -row -rowspan
  -browse -width -height -anchor -borderwidth -cursor -compound -font -justify 
  -orient -padx -pady -setgrid -takefocus -textvariable -selectmode -scrollregion
}

foreach {k v} $argv {
    set k [string trimleft $k -]
    if {[info exists ReplayData($k)]} {
      set ReplayData($k) $v
    } else {
      puts "INVALID OPTION: $k (VAL $v)"
      puts $validOptions
      exit -1
    }
}

parray ReplayData

    if {$ReplayData(demo)} {
      catch {wm withdraw .}
      catch {wm withdraw .replay}
      after 2000 {catch {wm withdraw .replaypointer}}
      after 2000 {catch {wm withdraw .messageWindow}}
      set ReplayData(pointWithArrow) 1
    }
  

#
# set up socket communication
#

    if {[catch {socksendsetup $ReplayData(MyPort)}]} {
      puts 'FAILED TO SETUP SOCKET: $errorInfo"
      exit -1
    }

    proc tkrsend {args} {
        socksendDebug "TKRSENDA: ARGS: $args"
        return [eval socksend $args]
    }

  # If there's apps to start, start them.

  foreach appCmd $ReplayData(appNames) {
     if {[file executable [lindex $appCmd 0]] == 0} {
        # if the file is not executable, prepend the name of a wish
        set appCmd [concat $ReplayData(DefaultWish) $appCmd]
     }
     if {![LoadApp $appCmd]} {
        # if load fails do not try to connect
        return
     }
  }
  

if {$ReplayData(script) ne ""} {

#    if {$ReplayData(playScript) eq ""} {
#      set ReplayData(playScript) normal
#    }

    set ReplayData(scriptDir) [file dirname $ReplayData(script)]

    if {[string first .tkr $ReplayData(script)] > 0} {

      LoadScript $ReplayData(script)

      switch [string tolower $ReplayData(playScript)] {
        normal {
          set cmd Replay
	  }
	fast {
          set cmd ReplayFast
	}
	fastonce {
          set cmd ReplayFast
	  set ReplayData(exitSelf) 1
	}
	"" {
          set cmd ReplayFast
	}
	default {
	  error "Unknown option \"$ReplayData(playScript)\""
	}
      }
    } else {
      LoadControl $ReplayData(script)

      switch [string tolower $ReplayData(playScript)] {
        normal -
	fast {
          set cmd "PlayControlGUI [string totitle $ReplayData(playScript)]"
	}
	fastonce {
          set cmd "PlayControlGUI Fast ; after 1000 {doExit}"
	}
	"" {
	}
	default {
	  error "Unknown option \"$ReplayData(playScript)\""
	}
      }
   }
}

  bind .replay <Destroy> "destroyExit %W"

  # If in auto-play mode we need to be connected before
  # loading scripts that may kick off a replay event.

  if {$ReplayData(playScript) ne ""} {
    while {$ReplayData(ConnectedApps) eq ""} {
      vwait ::ReplayData(ConnectedApps)
    }
  }
  
  # Send coverage stuff if requested.

  if {$ReplayData(coverage)} {
    set if [open $ReplayData(HomeDirectory)/getCovProcs.tcl r]
    set d [read $if]
    close $if
    while {$ReplayData(ConnectedApps) eq ""} {
      vwait ::ReplayData(ConnectedApps)
    }
    socksend $ReplayData(ConnectedApps) $d
    socksend $ReplayData(ConnectedApps) TkT_addCoverageTraces
  }

#
# play script immediately if it was requested
#
puts "PLAYIT: $ReplayData(playScript)"
if {$ReplayData(playScript) ne ""} {
puts "REPLAY: $cmd"
puts "EXIT: $ReplayData(exitChild)"
flush stdout
  eval $cmd
  if {$ReplayData(exitChild)} {
    socksend $ReplayData(ConnectedApps) exit
  }
}

if {$ReplayData(exitSelf)} {
  after 500 {exit}
}

